/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level70;

import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level70.SecurityValidator_70_Default;
import java.util.Iterator;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class SecurityNDValidator_70_Default
extends SecurityValidator_70_Default {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "9/16/05";

    public SecurityNDValidator_70_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getTraceName() {
        return "SecurityNDValidator_70_Default";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof LTPA) {
            this.trace("Object recognized as an LTPA; validating");
            this.validateLocal((LTPA)object);
            this.validateAcross((LTPA)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(LTPA lTPA) {
        if (lTPA.getShared() == null) {
            this.addError("ERROR_LTPA_SHARED_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        if (lTPA.getPublic() == null) {
            this.addError("ERROR_LTPA_PUBLIC_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        if (lTPA.getPrivate() == null) {
            this.addError("ERROR_LTPA_PRIVATE_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        this.validateAcross((AuthMechanism)lTPA);
    }

    protected void validateActiveUserRegistry(Security security2) {
        boolean bl = security2.isEnabled();
        if (bl) {
            String string;
            UserRegistry userRegistry = security2.getActiveUserRegistry();
            String string2 = userRegistry.getServerId();
            if (string2 == null || string2.length() == 0) {
                this.addError("ERROR_USER_REGISTRY_SERVER_ID_REQUIRED", new String[]{this.getCurrentFileName()}, userRegistry);
            }
            if ((string = userRegistry.getPrimaryAdminId()) == null || string.length() == 0) {
                this.addError("ERROR_USER_REGISTRY_PRIMARY_ADMIN_ID_REQUIRED", new String[]{this.getCurrentFileName()}, userRegistry);
            }
        }
    }

    protected void validateCacheTimeouts(Security security2) {
        int n = security2.getCacheTimeout();
        if (n < 1) {
            return;
        }
        Iterator iterator = security2.getAuthMechanisms().iterator();
        while (iterator.hasNext()) {
            LTPA lTPA;
            long l;
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            if (!(authMechanism instanceof LTPA) || (l = (lTPA = (LTPA)authMechanism).getTimeout()) <= 0L || (long)n >= l) continue;
            this.addError("ERROR_LTPA_SECURITY_CACHE_TIMEOUT_LESS_THAN_LTPA_TIMEOUT", new String[]{this.getCurrentFileName(), String.valueOf(n), lTPA.getOID(), String.valueOf(l)}, lTPA);
        }
    }
}

