/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level70;

import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeyReference;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.ipc.ssl.WSCertificateExpirationMonitor;
import com.ibm.websphere.models.config.ipc.ssl.WSNotification;
import com.ibm.websphere.models.config.ipc.ssl.WSSchedule;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.properties.DescriptiveProperty;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.AuthorizationTableImpl;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.DynamicSSLConfigSelection;
import com.ibm.websphere.models.config.security.LDAPSearchFilter;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.RoleBasedAuthorization;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.SWAMAuthentication;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SingleSignon;
import com.ibm.websphere.models.config.security.TAInterceptor;
import com.ibm.websphere.models.config.security.TrustAssociation;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.security.WIMUserRegistry;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level70.SecurityValidationConstants_70;
import com.ibm.websphere.validation.base.config.level70.ServerContextValidator_70;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class SecurityValidator_70_Default
extends ServerContextValidator_70
implements SecurityValidationConstants_70 {
    public static final String pgmVersion = "1.2";
    public static final String pgmUpdate = "9/20/05";
    protected AuthorizationConfig _boundAuthorizationConfig;
    protected TrustAssociation _boundTrustAssociation;
    protected AuthMechanism _boundAuthMechanism;
    protected UserRegistry _boundUserRegistry;

    public SecurityValidator_70_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.clearBindings();
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level70.securityvalidation_70_NLS";
    }

    public String getTraceName() {
        return "SecurityValidator_70_Default";
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this.clearBindings();
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this.clearBindings();
    }

    protected void clearBindings() {
        this._boundAuthorizationConfig = null;
        this._boundTrustAssociation = null;
        this._boundAuthMechanism = null;
        this._boundUserRegistry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        Object object2 = object;
        if (object2 instanceof AuthorizationConfig) {
            this._boundAuthorizationConfig = (AuthorizationConfig)object2;
        } else if (object2 instanceof TrustAssociation) {
            this._boundTrustAssociation = (TrustAssociation)object2;
        } else if (object2 instanceof UserRegistry) {
            this._boundUserRegistry = (UserRegistry)object2;
        }
        try {
            super.visit(object);
        }
        finally {
            if (this._boundAuthorizationConfig != null) {
                this._boundAuthorizationConfig = null;
            } else if (this._boundTrustAssociation != null) {
                this._boundTrustAssociation = null;
            } else if (this._boundUserRegistry != null) {
                this._boundUserRegistry = null;
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof JAASConfiguration || object instanceof JAASConfigurationEntry || object instanceof JAASLoginModule) {
            return true;
        }
        boolean bl = true;
        if (object instanceof AuthorizationConfig) {
            this.trace("Object recognized as an authorization configuration; validating");
            this.validateLocal((AuthorizationConfig)object);
            this.validateAcross((AuthorizationConfig)object);
        } else if (object instanceof AuthorizationTableImpl) {
            this.trace("Object recognized as an authorization table; validating");
            this.validateLocal((AuthorizationTableImpl)object);
            this.validateAcross((AuthorizationTableImpl)object);
        } else if (object instanceof AuthorizationProvider) {
            this.trace("Object recognized as an authorization provider; validating");
            this.validateLocal((AuthorizationProvider)object);
            this.validateAcross((AuthorizationProvider)object);
        } else if (object instanceof CustomUserRegistry) {
            this.trace("Object recognized as a custom user registry; validating");
            this.validateLocal((CustomUserRegistry)object);
            this.validateAcross((CustomUserRegistry)object);
        } else if (object instanceof LDAPSearchFilter) {
            this.trace("Object recognized as an LDAP search filter; validating");
            this.validateLocal((LDAPSearchFilter)object);
            this.validateAcross((LDAPSearchFilter)object);
        } else if (object instanceof LDAPUserRegistry) {
            this.trace("Object recognized as an LDAP user registry; validating");
            this.validateLocal((LDAPUserRegistry)object);
            this.validateAcross((LDAPUserRegistry)object);
        } else if (object instanceof LocalOSUserRegistry) {
            this.trace("Object recognized as a local OS user registry; validating");
            this.validateLocal((LocalOSUserRegistry)object);
            this.validateAcross((LocalOSUserRegistry)object);
        } else if (object instanceof WIMUserRegistry) {
            this.trace("Object recognized as an WIM user registry; validating");
            this.validateLocal((WIMUserRegistry)object);
            this.validateAcross((WIMUserRegistry)object);
        } else if (object instanceof RoleBasedAuthorization) {
            this.trace("Object recognized as an role based authorization; validating");
            this.validateLocal((RoleBasedAuthorization)object);
            this.validateAcross((RoleBasedAuthorization)object);
        } else if (object instanceof SWAMAuthentication) {
            this.trace("Object recognized as a security; validating");
            this.validateLocal((SWAMAuthentication)object);
            this.validateAcross((SWAMAuthentication)object);
        } else if (object instanceof Security) {
            this.trace("Object recognized as a security; validating");
            this.validateLocal((Security)object);
            this.validateAcross((Security)object);
        } else if (object instanceof SingleSignon) {
            this.trace("Object recognized as a security; validating");
            this.validateLocal((SingleSignon)object);
            this.validateAcross((SingleSignon)object);
        } else if (object instanceof SSLConfig) {
            this.trace("Object recognized as an SSL config; validating");
            this.validateLocal((SSLConfig)object);
            this.validateAcross((SSLConfig)object);
        } else if (object instanceof TrustAssociation) {
            this.trace("Object recognized as a trust association; validating");
            this.validateLocal((TrustAssociation)object);
            this.validateAcross((TrustAssociation)object);
        } else if (object instanceof TAInterceptor) {
            this.trace("Object recognized as a TA interceptor; validating");
            this.validateLocal((TAInterceptor)object);
            this.validateAcross((TAInterceptor)object);
        } else if (object instanceof AuthMechanism) {
            this.trace("Object recognized as an authentication mechanism; validating");
            this.validateLocal((AuthMechanism)object);
            this.validateAcross((AuthMechanism)object);
        } else if (object instanceof UserRegistry) {
            this.trace("Object recognized as a user registry; validating");
            this.validateLocal((UserRegistry)object);
            this.validateAcross((UserRegistry)object);
        } else if (object instanceof CryptoHardwareToken) {
            this.trace("Object recognized as a crypto-hardware token; validating");
            this.validateLocal((CryptoHardwareToken)object);
            this.validateAcross((CryptoHardwareToken)object);
        } else if (object instanceof SecureSocketLayer) {
            this.trace("Object recognized as a secure socket layer; validating");
            this.validateLocal((SecureSocketLayer)object);
            this.validateAcross((SecureSocketLayer)object);
        } else if (object instanceof JAASAuthData) {
            this.trace("Object recognized as a user registry; validating");
            this.validateLocal((JAASAuthData)object);
            this.validateAcross((JAASAuthData)object);
        } else if (object instanceof DescriptiveProperty) {
            this.trace("Object recognized as a user DescriptiveProperty; validating");
            this.validateLocal((DescriptiveProperty)object);
            this.validateAcross((DescriptiveProperty)object);
        } else if (object instanceof KeyManager) {
            this.trace("Object recognized as a user KeyManager; validating");
            this.validateLocal((KeyManager)object);
            this.validateAcross((KeyManager)object);
        } else if (object instanceof KeyReference) {
            this.trace("Object recognized as a user KeyReference; validating");
            this.validateLocal((KeyReference)object);
            this.validateAcross((KeyReference)object);
        } else if (object instanceof KeySet) {
            this.trace("Object recognized as a user KeySet; validating");
            this.validateLocal((KeySet)object);
            this.validateAcross((KeySet)object);
        } else if (object instanceof KeySetGroup) {
            this.trace("Object recognized as a user KeySetGroup; validating");
            this.validateLocal((KeySetGroup)object);
            this.validateAcross((KeySetGroup)object);
        } else if (object instanceof KeyStore) {
            this.trace("Object recognized as a user keyStore; validating");
            this.validateLocal((KeyStore)object);
            this.validateAcross((KeyStore)object);
        } else if (object instanceof ManagementScope) {
            this.trace("Object recognized as a user ManagementScope; validating");
            this.validateLocal((ManagementScope)object);
            this.validateAcross((ManagementScope)object);
        } else if (object instanceof TrustManager) {
            this.trace("Object recognized as a user TrustManager; validating");
            this.validateLocal((TrustManager)object);
            this.validateAcross((TrustManager)object);
        } else if (object instanceof WSCertificateExpirationMonitor) {
            this.trace("Object recognized as a user WSCertificateExpirationMonitor; validating");
            this.validateLocal((WSCertificateExpirationMonitor)object);
            this.validateAcross((WSCertificateExpirationMonitor)object);
        } else if (object instanceof WSNotification) {
            this.trace("Object recognized as a user WSNotification; validating");
            this.validateLocal((WSNotification)object);
            this.validateAcross((WSNotification)object);
        } else if (object instanceof WSSchedule) {
            this.trace("Object recognized as a user WSSchedule; validating");
            this.validateLocal((WSSchedule)object);
            this.validateAcross((WSSchedule)object);
        } else if (object instanceof DynamicSSLConfigSelection) {
            this.trace("Object recognized as a user DynamicSSLConfigSelection; validating");
            this.validateLocal((DynamicSSLConfigSelection)object);
            this.validateAcross((DynamicSSLConfigSelection)object);
        } else if (object instanceof SSLConfigGroup) {
            this.trace("Object recognized as a user SSLConfigGroup; validating");
            this.validateLocal((SSLConfigGroup)object);
            this.validateAcross((SSLConfigGroup)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcross(AuthorizationConfig authorizationConfig) {
        this.validateProviderNameDuplication(authorizationConfig);
    }

    protected void validateProviderNameDuplication(AuthorizationConfig authorizationConfig) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((AuthorizationProvider)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_AUTHORIZATION_PROVIDER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)authorizationConfig.getAuthorizationProviders(), false, this, authorizationConfig);
    }

    protected void validateAcross(AuthorizationTableImpl authorizationTableImpl) {
    }

    public void validateAcross(AuthMechanism authMechanism) {
    }

    protected void validateAcross(AuthorizationProvider authorizationProvider) {
    }

    public void validateAcross(CustomUserRegistry customUserRegistry) {
        this.validateAcross((UserRegistry)customUserRegistry);
    }

    public void validateAcross(LDAPSearchFilter lDAPSearchFilter) {
    }

    public void validateAcross(LDAPUserRegistry lDAPUserRegistry) {
        LDAPSearchFilter lDAPSearchFilter = lDAPUserRegistry.getSearchFilter();
        if (lDAPSearchFilter == null) {
            this.addError("ERROR_LDAP_USER_REGISTRY_LDAP_SEARCH_FILTER_ABSENT", new String[]{lDAPUserRegistry.getServerId()}, lDAPUserRegistry);
        }
        if (lDAPUserRegistry.getHosts().isEmpty()) {
            this.addError("ERROR_LDAP_USER_REGISTRY_HOST_REQUIRED", new String[]{lDAPUserRegistry.getServerId()}, lDAPUserRegistry);
        }
        this.validateLDAPHosts(lDAPUserRegistry);
        this.validateAcross((UserRegistry)lDAPUserRegistry);
    }

    protected void validateLDAPHosts(LDAPUserRegistry lDAPUserRegistry) {
        this.traceBegin("validateLDAPHosts(LDAPUserRegistry)");
        HashMap hashMap = new HashMap();
        Iterator iterator = lDAPUserRegistry.getHosts().iterator();
        while (iterator.hasNext()) {
            EndPoint endPoint = (EndPoint)iterator.next();
            if (endPoint.getHost() == null) continue;
            this.checkLDAPEndPoint(lDAPUserRegistry, hashMap, endPoint);
        }
        this.traceEnd();
    }

    protected void checkLDAPEndPoint(LDAPUserRegistry lDAPUserRegistry, HashMap hashMap, EndPoint endPoint) {
        String string = lDAPUserRegistry.getServerId();
        String string2 = endPoint.getHost();
        int n = endPoint.getPort();
        this.traceBegin("checkDLAPEndPoint(Hashtable, EndPoint)");
        this.trace("Host: ", string2);
        this.trace("Port: ", String.valueOf(n));
        Hashtable<String, EndPoint> hashtable = (Hashtable<String, EndPoint>)hashMap.get(String.valueOf(n));
        if (hashtable == null) {
            this.trace("First host using port");
            hashtable = new Hashtable<String, EndPoint>();
            hashtable.put(string2, endPoint);
            hashMap.put(String.valueOf(n), hashtable);
        } else {
            String string3;
            if (string2.equals("*")) {
                this.trace("Conflict of global host with existing host");
                string3 = "ERROR_LDAP_GLOBAL_PORT_CONFLICT";
            } else if (hashtable.containsKey("*")) {
                this.trace("Conflict of host with existing global host");
                string3 = "ERROR_LDAP_CONFLICT_WITH_GLOBAL_PORT";
            } else if (hashtable.containsKey(string2)) {
                this.trace("Conflict of host with existing host");
                string3 = "ERROR_LDAP_PORT_CONFLICT";
            } else {
                this.trace("New occurrance on host");
                string3 = null;
            }
            if (string3 != null) {
                this.addError(string3, new String[]{string, string2, String.valueOf(n)}, endPoint);
            } else {
                hashtable.put(string2, endPoint);
            }
        }
        this.traceEnd();
    }

    public void validateAcross(LocalOSUserRegistry localOSUserRegistry) {
        this.validateAcross((UserRegistry)localOSUserRegistry);
    }

    public void validateAcross(WIMUserRegistry wIMUserRegistry) {
        this.validateAcross((UserRegistry)wIMUserRegistry);
    }

    protected void validateAcross(RoleBasedAuthorization roleBasedAuthorization) {
    }

    public void validateAcross(SWAMAuthentication sWAMAuthentication) {
        this.traceStub("Cross validation of SWAMAuthentication values.");
        this.validateAcross((AuthMechanism)sWAMAuthentication);
    }

    public void validateAcross(Security security2) {
        if (security2.getCSI() == null) {
            this.addError("ERROR_SECURITY_CSI_REQUIRED", new String[]{this.getCurrentFileName()}, security2);
        }
        if (!this.isZOS() && security2.getIBM() == null) {
            this.addError("ERROR_SECURITY_IBM_REQUIRED", new String[]{this.getCurrentFileName()}, security2);
        }
        if (security2.getSystemLoginConfig() == null) {
            this.addError("ERROR_SECURITY_SYSTEM_LOGIN_CONFIGURATION_REQUIRED", new String[]{this.getCurrentFileName()}, security2);
        } else {
            this.validateAcross(security2.getSystemLoginConfig(), true);
        }
        if (security2.getApplicationLoginConfig() == null) {
            this.addError("ERROR_SECURITY_APPLICATION_LOGIN_CONFIGURATION_REQUIRED", new String[]{this.getCurrentFileName()}, security2);
        } else {
            this.validateAcross(security2.getApplicationLoginConfig(), false);
        }
        this.validateActiveUserRegistry(security2);
        this.validateCacheTimeouts(security2);
        this.validateSSLConfigAliasDuplication(security2);
        this.validateSSLAuthenticationOIDDuplication(security2);
        this.validateUserIDDuplication(security2);
        this.validateRoleNameDuplication(security2);
        this.validateWebAuthAttrsDuplication(security2);
        this.validateAdditionalSecAttrsDuplication(security2);
        this.validateKeyManagerDuplication(security2);
        this.validateKeySetDuplication(security2);
        this.validateKeySetGroupDuplication(security2);
        this.validateKeyStoreDuplication(security2);
        this.validateManagementScopeDuplication(security2);
        this.validateTrustManagerDuplication(security2);
        this.validateWSNotificationDuplication(security2);
        this.validateWSScheduleDuplication(security2);
        this.validateDynamicSSLConfigSelectionDuplication(security2);
        this.validateSSLConfigGroupDuplication(security2);
    }

    protected void validateActiveUserRegistry(Security security2) {
    }

    protected void validateCacheTimeouts(Security security2) {
        int n = security2.getCacheTimeout();
        if (n < 1) {
            return;
        }
        Iterator iterator = security2.getAuthMechanisms().iterator();
        while (iterator.hasNext()) {
            LTPA lTPA;
            long l;
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            if (!(authMechanism instanceof LTPA) || (l = (lTPA = (LTPA)authMechanism).getTimeout()) <= 0L || (long)n >= l) continue;
            this.addError("ERROR_LTPA_SECURITY_CACHE_TIMEOUT_LESS_THAN_LTPA_TIMEOUT", new String[]{this.getCurrentFileName(), String.valueOf(n), lTPA.getOID(), String.valueOf(l)}, lTPA);
        }
    }

    protected void validateSSLConfigAliasDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                ManagementScope managementScope = ((SSLConfig)eObject).getManagementScope();
                if (managementScope != null) {
                    return ((SSLConfig)eObject).getAlias().toUpperCase() + managementScope.getScopeName().toUpperCase();
                }
                return ((SSLConfig)eObject).getAlias().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_SSL_CONFIG_ALIAS_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getRepertoire(), false, this, security2);
    }

    protected void validateSSLAuthenticationOIDDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((AuthMechanism)eObject).getOID();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_AUTH_MECHANISM_OID_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getAuthMechanisms(), false, this, security2);
    }

    protected void validateUserIDDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((JAASAuthData)eObject).getUserId().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_JAAS_AUTH_DATA_USER_ID_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getAuthDataEntries(), false, this, security2);
    }

    protected void validateRoleNameDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((RoleBasedAuthorization)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_ROLE_AUTHORIZATION_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getRoleBasedAuthorization(), false, this, security2);
    }

    protected void validateWebAuthAttrsDuplication(Security security2) {
        this.validateDescriptiveProperties(security2, null, (List)security2.getWebAuthAttrs(), "ERROR_WEB_AUTH_ATTRS_NAME_DUPLICATION", "ERROR_WEB_AUTH_ATTRS_NAME_ABSENT", "ERROR_WEB_AUTH_ATTRS_VALUE_ABSENT", "ERROR_WEB_AUTH_ATTRS_TYPE_ABSENT");
    }

    protected void validateAdditionalSecAttrsDuplication(Security security2) {
        this.validateDescriptiveProperties(security2, null, (List)security2.getAdditionalSecAttrs(), "ERROR_ADD_SEC_ATTRS_NAME_DUPLICATION", "ERROR_ADD_SEC_ATTRS_NAME_ABSENT", "ERROR_ADD_SEC_ATTRS_VALUE_ABSENT", "ERROR_ADD_SEC_ATTRS_TYPE_ABSENT");
    }

    protected void validateKeyManagerDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((KeyManager)eObject).getName().toUpperCase() + ((KeyManager)eObject).getManagementScope().getScopeName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_KEY_MANAGER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getKeyManagers(), false, this, security2);
    }

    protected void validateKeySetDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((KeySet)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_KEY_SET_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getKeySets(), false, this, security2);
    }

    protected void validateKeySetGroupDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((KeySetGroup)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_KEY_SET_GROUP_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getKeySetGroups(), false, this, security2);
    }

    protected void validateKeyStoreDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((KeyStore)eObject).getName().toUpperCase() + ((KeyStore)eObject).getManagementScope().getScopeName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_KEY_STORE_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getKeyStores(), false, this, security2);
    }

    protected void validateManagementScopeDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((ManagementScope)eObject).getScopeName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_MANAGEMENT_SCOPE_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getManagementScopes(), false, this, security2);
    }

    protected void validateTrustManagerDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((TrustManager)eObject).getName().toUpperCase() + ((TrustManager)eObject).getManagementScope().getScopeName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_TRUST_MANAGER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getTrustManagers(), false, this, security2);
    }

    protected void validateDynamicSSLConfigSelectionDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((DynamicSSLConfigSelection)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DYNAMIC_SSL_CONFIG_SELECTION_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getDynamicSSLConfigSelections(), false, this, security2);
    }

    protected void validateSSLConfigGroupDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((SSLConfigGroup)eObject).getDirection().toUpperCase() + ((SSLConfigGroup)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_SSL_CONFIG_GROUP_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getSslConfigGroups(), false, this, security2);
    }

    protected void validateWSNotificationDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((WSNotification)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_WS_NOTIFICATION_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getWsNotifications(), false, this, security2);
    }

    protected void validateWSScheduleDuplication(Security security2) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((WSSchedule)eObject).getName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_WS_SCHEDULE_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)security2.getWsSchedules(), false, this, security2);
    }

    protected HashSet getAliasTable(Security security2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = security2.getRepertoire().iterator();
        while (iterator.hasNext()) {
            SSLConfig sSLConfig = (SSLConfig)iterator.next();
            String string = sSLConfig.getAlias();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void validateAcross(SingleSignon singleSignon) {
    }

    protected void validateAcross(TrustAssociation trustAssociation) {
        this.validateInterceptorClassNameDuplication(trustAssociation);
    }

    protected void validateInterceptorClassNameDuplication(TrustAssociation trustAssociation) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((TAInterceptor)eObject).getInterceptorClassName();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_TA_INTERCEPTOR_CLASS_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)trustAssociation.getInterceptors(), false, this, trustAssociation);
    }

    protected void validateAcross(TAInterceptor tAInterceptor) {
        this.validateProperties(tAInterceptor, null, (List)tAInterceptor.getTrustProperties(), "ERROR_TA_INTERCEPTOR_PROPERTY_DUPLICATION", "ERROR_TA_INTERCEPTOR_PROPERTY_NAME_ABSENT");
    }

    protected void validateAcross(UserRegistry userRegistry) {
        this.validateProperties(userRegistry, null, (List)userRegistry.getProperties(), "ERROR_USER_REGISTRY_PROPERTY_DUPLICATION", "ERROR_USER_REGISTRY_PROPERTY_NAME_ABSENT");
    }

    public void validateAcross(CryptoHardwareToken cryptoHardwareToken) {
    }

    public void validateAcross(SecureSocketLayer secureSocketLayer) {
        this.traceStub("validateAcross(SecureSocketLayer)");
    }

    protected void validateAcross(JAASAuthData jAASAuthData) {
    }

    protected void validateAcross(DescriptiveProperty descriptiveProperty) {
    }

    protected void validateAcross(KeyManager keyManager) {
        this.validateDescriptiveProperties(keyManager, keyManager.getName(), (List)keyManager.getAdditionalKeyManagerAttrs(), "ERROR_ADD_KEY_MANAGER_ATTRS_NAME_DUPLICATION", "ERROR_ADD_KEY_MANAGER_ATTRS_NAME_ABSENT", "ERROR_ADD_KEY_MANAGER_ATTRS_VALUE_ABSENT", "ERROR_ADD_KEY_MANAGER_ATTRS_TYPE_ABSENT");
    }

    protected void validateAcross(KeyReference keyReference) {
    }

    protected void validateAcross(KeySet keySet) {
        this.validateDescriptiveProperties(keySet, keySet.getName(), (List)keySet.getAdditionalKeySetAttrs(), "ERROR_ADD_KEY_SET_ATTRS_NAME_DUPLICATION", "ERROR_ADD_KEY_SET_ATTRS_NAME_ABSENT", "ERROR_ADD_KEY_SET_ATTRS_VALUE_ABSENT", "ERROR_ADD_KEY_SET_ATTRS_TYPE_ABSENT");
    }

    protected void validateAcross(KeySetGroup keySetGroup) {
    }

    protected void validateAcross(KeyStore keyStore) {
        this.validateDescriptiveProperties(keyStore, keyStore.getName(), (List)keyStore.getAdditionalKeyStoreAttrs(), "ERROR_ADD_KEY_STORE_ATTRS_NAME_DUPLICATION", "ERROR_ADD_KEY_STORE_ATTRS_NAME_ABSENT", "ERROR_ADD_KEY_STORE_ATTRS_VALUE_ABSENT", "ERROR_ADD_KEY_STORE_ATTRS_TYPE_ABSENT");
    }

    protected void validateAcross(ManagementScope managementScope) {
    }

    protected void validateAcross(TrustManager trustManager) {
        this.validateDescriptiveProperties(trustManager, trustManager.getName(), (List)trustManager.getAdditionalTrustManagerAttrs(), "ERROR_ADD_TRUST_MANAGER_ATTRS_NAME_DUPLICATION", "ERROR_ADD_TRUST_MANAGER_ATTRS_NAME_ABSENT", "ERROR_ADD_TRUST_MANAGER_ATTRS_VALUE_ABSENT", "ERROR_ADD_TRUST_MANAGER_ATTRS_TYPE_ABSENT");
    }

    protected void validateAcross(SSLConfigGroup sSLConfigGroup) {
    }

    protected void validateAcross(DynamicSSLConfigSelection dynamicSSLConfigSelection) {
    }

    protected void validateAcross(WSCertificateExpirationMonitor wSCertificateExpirationMonitor) {
    }

    protected void validateAcross(WSNotification wSNotification) {
    }

    protected void validateAcross(WSSchedule wSSchedule) {
    }

    protected void validateAcross(JAASConfiguration jAASConfiguration, boolean bl) {
        this.validateJAASAliasDuplication(jAASConfiguration, bl);
        Iterator iterator = jAASConfiguration.getEntries().iterator();
        while (iterator.hasNext()) {
            JAASConfigurationEntry jAASConfigurationEntry = (JAASConfigurationEntry)iterator.next();
            this.validateLocal(jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    protected void validateJAASAliasDuplication(JAASConfiguration jAASConfiguration, final boolean bl) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((JAASConfigurationEntry)eObject).getAlias();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                if (bl) {
                    return "ERROR_SYSTEM_JAAS_CONFIGURATION_ENTRY_ALIAS_DUPLICATION";
                }
                return "ERROR_APPLICATION_JAAS_CONFIGURATION_ENTRY_ALIAS_DUPLICATION";
            }
        };
        duplicationTester.test((List)jAASConfiguration.getEntries(), false, this, jAASConfiguration);
    }

    public void validateAcross(JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        Iterator iterator = jAASConfigurationEntry.getLoginModules().iterator();
        while (iterator.hasNext()) {
            JAASLoginModule jAASLoginModule = (JAASLoginModule)iterator.next();
            this.validateAcross(jAASLoginModule, jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    public void validateAcross(JAASLoginModule jAASLoginModule, JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        String string = bl ? "ERROR_SYSTEM_JAAS_LOGIN_MODULE_PROPERTY_DUPLICATION" : "ERROR_APPLICATION_JAAS_LOGIN_MODULE_PROPERTY_DUPLICATION";
        String string2 = bl ? "ERROR_SYSTEM_JAAS_LOGIN_MODULE_PROPERTY_NAME_ABSENT" : "ERROR_APPLICATION_JAAS_LOGIN_MODULE_PROPERTY_NAME_ABSENT";
        this.validateProperties(jAASLoginModule, null, (List)jAASLoginModule.getOptions(), string, string2);
    }

    protected void validateAcross(SSLConfig sSLConfig) {
        if (sSLConfig.getSetting() == null) {
            this.addError("ERROR_SSL_CONFIG_SETTING_REQUIRED", new String[]{sSLConfig.getAlias()}, sSLConfig);
        }
    }

    protected void validateLocal(AuthorizationConfig authorizationConfig) {
    }

    protected void validateLocal(AuthorizationTableImpl authorizationTableImpl) {
        String string = authorizationTableImpl.getClassName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_TABLE_CLASS_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, authorizationTableImpl);
        }
    }

    public void validateLocal(AuthMechanism authMechanism) {
        String string = authMechanism.getOID();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_AUTH_MECHANISM_OID_REQUIRED", authMechanism);
        }
    }

    protected void validateLocal(AuthorizationProvider authorizationProvider) {
        String string;
        String string2 = authorizationProvider.getName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_NAME_REQUIRED", authorizationProvider);
        }
        if ((string = authorizationProvider.getJ2eePolicyImplClassName()) == null || string.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_POLICY_CLASS_NAME_REQUIRED", new String[]{string2}, authorizationProvider);
        }
        this.validatePolicyConfigurationClassName(authorizationProvider);
    }

    protected void validatePolicyConfigurationClassName(AuthorizationProvider authorizationProvider) {
        String string = authorizationProvider.getPolicyConfigurationFactoryImplClassName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_AUTHORIZATION_PROVIDER_POLICY_CONFIGURATION_FACTORY_CLASS_NAME_REQUIRED", new String[]{authorizationProvider.getName()}, authorizationProvider);
        }
    }

    public void validateLocal(CustomUserRegistry customUserRegistry) {
        this.validateLocal((UserRegistry)customUserRegistry);
    }

    public void validateLocal(LDAPSearchFilter lDAPSearchFilter) {
        this.traceStub("Local validation of LDAP search filter values.");
    }

    public void validateLocal(LDAPUserRegistry lDAPUserRegistry) {
        int n = lDAPUserRegistry.getType().getValue();
        if (!this.testLDAPDirectoryType(n)) {
            this.addError("ERROR_LDAP_USER_REGISTRY_TYPE_INVALID", new String[]{lDAPUserRegistry.getServerId(), String.valueOf(n)}, lDAPUserRegistry);
        }
    }

    public void validateLocal(LTPA lTPA) {
        this.traceStub("Local validation of LTPA values; (advanced edition).");
        this.validateLocal((AuthMechanism)lTPA);
    }

    public void validateLocal(LocalOSUserRegistry localOSUserRegistry) {
        this.validateLocal((UserRegistry)localOSUserRegistry);
    }

    public void validateLocal(WIMUserRegistry wIMUserRegistry) {
        String string = wIMUserRegistry.getRegistryClassName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WIM_REGISTRY_CLASS_NAME_REQUIRED", new String[]{wIMUserRegistry.getServerId()}, wIMUserRegistry);
        }
        this.validateLocal((UserRegistry)wIMUserRegistry);
    }

    protected void validateLocal(RoleBasedAuthorization roleBasedAuthorization) {
        String string = roleBasedAuthorization.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_ROLE_BASED_AUTHORIZATION_NAME_REQUIRED", roleBasedAuthorization);
        }
    }

    public void validateLocal(SWAMAuthentication sWAMAuthentication) {
        this.traceStub("Local validation of SWAMAuthentication values.");
        this.validateLocal((AuthMechanism)sWAMAuthentication);
    }

    public void validateLocal(Security security2) {
        boolean bl = security2.isEnabled();
        int n = security2.getActiveProtocol().getValue();
        if (!this.testIIOPSecurityProtocolKind(n)) {
            this.addError("ERROR_SECURITY_ACTIVE_PROTOCOL_INVALID", new String[]{this.getCurrentFileName(), String.valueOf(n)}, security2);
        }
        int n2 = security2.getCacheTimeout();
        this.testIntegerMin(n2, 1, "ERROR_SECURITY_CACHE_TIMEOUT_INVALID", security2);
        if (n2 > 0 && n2 < 30) {
            this.addWarning("WARNING_SECURITY_CACHE_TIMEOUT_TOO_LOW", new String[]{this.getCurrentFileName(), String.valueOf(n2), new Integer(30).toString()}, security2);
        }
        if (security2.getSystemLoginConfig() != null) {
            this.validateLocal(security2.getSystemLoginConfig(), true);
        }
        if (security2.getApplicationLoginConfig() != null) {
            this.validateLocal(security2.getApplicationLoginConfig(), false);
        }
    }

    public void validateLocal(SingleSignon singleSignon) {
    }

    protected void validateLocal(SSLConfig sSLConfig) {
        String string = sSLConfig.getAlias();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_SSL_CONFIG_ALIAS_REQUIRED", sSLConfig);
        }
        if (sSLConfig.getManagementScope() == null) {
            this.addError("ERROR_SSL_CONFIG_SCOPE_REF_REQUIRED", new String[]{sSLConfig.getAlias()}, sSLConfig);
        }
    }

    protected void validateLocal(TrustAssociation trustAssociation) {
    }

    protected void validateLocal(TAInterceptor tAInterceptor) {
        String string = tAInterceptor.getInterceptorClassName();
        if (string == null || string.length() == 0) {
            if (this._boundAuthMechanism == null) {
                this.addError("ERROR_SECURITY_TA_INTERCEPTOR_CLASS_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, tAInterceptor);
            } else {
                this.addError("ERROR_AUTH_MECHANISM_TA_INTERCEPTOR_CLASS_NAME_REQUIRED", new String[]{this._boundAuthMechanism.getOID()}, tAInterceptor);
            }
        }
    }

    public void validateLocal(UserRegistry userRegistry) {
    }

    public void validateLocal(CryptoHardwareToken cryptoHardwareToken) {
        this.traceStub("Local validation of crypto-hardware token values.");
    }

    public void validateLocal(SecureSocketLayer secureSocketLayer) {
        this.traceStub("Local validation of secure socket layer values.");
    }

    public void validateLocal(JAASAuthData jAASAuthData) {
        String string = jAASAuthData.getAlias();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_JAAS_AUTH_DATA_ALIAS_REQUIRED", jAASAuthData);
        }
    }

    public void validateLocal(DescriptiveProperty descriptiveProperty) {
    }

    protected void validateLocal(KeyManager keyManager) {
        String string = keyManager.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_KEY_MANAGEMENT_NAME_REQUIRED", keyManager);
        }
        if (keyManager.getManagementScope() == null) {
            this.addError("ERROR_KEY_MANAGER_SCOPE_REF_REQUIRED", new String[]{keyManager.getName()}, keyManager);
        }
    }

    protected void validateLocal(KeyReference keyReference) {
        String string = keyReference.getKeyAlias();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_KEY_REFERENCE_ALIAS_REQUIRED", keyReference);
        }
    }

    protected void validateLocal(KeySet keySet) {
        String string = keySet.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_KEY_SET_NAME_REQUIRED", keySet);
        }
        if (keySet.getManagementScope() == null) {
            this.addError("ERROR_KEY_SET_SCOPE_REF_REQUIRED", new String[]{keySet.getName()}, keySet);
        }
    }

    protected void validateLocal(KeySetGroup keySetGroup) {
        String string = keySetGroup.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_KEY_SET_GROUP_NAME_REQUIRED", keySetGroup);
        }
        if (keySetGroup.getManagementScope() == null) {
            this.addError("ERROR_KEY_SET_GROUP_SCOPE_REF_REQUIRED", new String[]{keySetGroup.getName()}, keySetGroup);
        }
    }

    protected void validateLocal(KeyStore keyStore) {
        if (keyStore.getManagementScope() == null) {
            this.addError("ERROR_KEY_STORE_SCOPE_REF_REQUIRED", new String[]{keyStore.getName()}, keyStore);
        }
    }

    protected void validateLocal(ManagementScope managementScope) {
        String string = managementScope.getScopeName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_MANAGEMENT_SCOPE_NAME_REQUIRED", managementScope);
        }
    }

    protected void validateLocal(TrustManager trustManager) {
        String string = trustManager.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_TRUST_MANAGER_NAME_REQUIRED", trustManager);
        }
        if (trustManager.getManagementScope() == null) {
            this.addError("ERROR_TRUST_MANAGER_SCOPE_REF_REQUIRED", new String[]{trustManager.getName()}, trustManager);
        }
    }

    protected void validateLocal(SSLConfigGroup sSLConfigGroup) {
        String string = sSLConfigGroup.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_SSL_CONFIG_GROUP_NAME_REQUIRED", sSLConfigGroup);
        }
        if (sSLConfigGroup.getManagementScope() == null) {
            this.addError("ERROR_SSL_CONFIG_GROUP_SCOPE_REF_REQUIRED", new String[]{sSLConfigGroup.getName()}, sSLConfigGroup);
        }
    }

    protected void validateLocal(DynamicSSLConfigSelection dynamicSSLConfigSelection) {
        String string = dynamicSSLConfigSelection.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_DYNAMIC_SSL_CONFIG_SELECTION_NAME_REQUIRED", dynamicSSLConfigSelection);
        }
        if (dynamicSSLConfigSelection.getManagementScope() == null) {
            this.addError("ERROR_DYNAMIC_SSL_CONFIG_SELECTION_SCOPE_REF_REQUIRED", new String[]{dynamicSSLConfigSelection.getName()}, dynamicSSLConfigSelection);
        }
    }

    protected void validateLocal(WSCertificateExpirationMonitor wSCertificateExpirationMonitor) {
        String string = wSCertificateExpirationMonitor.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WS_CERT_EXP_MONITOR_NAME_REQUIRED", wSCertificateExpirationMonitor);
        }
    }

    protected void validateLocal(WSNotification wSNotification) {
        String string = wSNotification.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WS_NOTIFICATION_NAME_REQUIRED", wSNotification);
        }
    }

    protected void validateLocal(WSSchedule wSSchedule) {
        String string = wSSchedule.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WS_SCHEDULE_NAME_REQUIRED", wSSchedule);
        }
    }

    public void validateLocal(JAASConfiguration jAASConfiguration, boolean bl) {
        this.traceStub("Local validation of JAASConfiguration values.");
        Iterator iterator = jAASConfiguration.getEntries().iterator();
        while (iterator.hasNext()) {
            JAASConfigurationEntry jAASConfigurationEntry = (JAASConfigurationEntry)iterator.next();
            this.validateLocal(jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    public void validateLocal(JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        String string = jAASConfigurationEntry.getAlias();
        if (string == null || string.length() == 0) {
            if (bl) {
                this.addError("ERROR_SYSTEM_JAAS_CONFIGURATION_ENTRY_ALIAS_REQUIRED", jAASConfigurationEntry);
            } else {
                this.addError("ERROR_APPLICATION_JAAS_CONFIGURATION_ENTRY_ALIAS_REQUIRED", jAASConfigurationEntry);
            }
        }
        Iterator iterator = jAASConfigurationEntry.getLoginModules().iterator();
        while (iterator.hasNext()) {
            JAASLoginModule jAASLoginModule = (JAASLoginModule)iterator.next();
            this.validateLocal(jAASLoginModule, jAASConfigurationEntry, jAASConfiguration, bl);
        }
    }

    public void validateLocal(JAASLoginModule jAASLoginModule, JAASConfigurationEntry jAASConfigurationEntry, JAASConfiguration jAASConfiguration, boolean bl) {
        int n;
        String string = jAASLoginModule.getModuleClassName();
        if (string == null || string.length() == 0) {
            if (bl) {
                this.addError("ERROR_SYSTEM_JAAS_LOGIN_MODULE_CLASS_NAME_REQUIRED", new String[]{jAASConfigurationEntry.getAlias()}, jAASLoginModule);
            } else {
                this.addError("ERROR_APPLICATIOn_JAAS_LOGIN_MODULE_CLASS_NAME_REQUIRED", new String[]{jAASConfigurationEntry.getAlias()}, jAASLoginModule);
            }
        }
        if (!this.testJAASModuleControlFlag(n = jAASLoginModule.getAuthenticationStrategy().getValue())) {
            if (bl) {
                this.addError("ERROR_SYSTEM_JAAS_LOGIN_MODULE_AUTHENTICATION_STRATEGY_INVALID", new String[]{jAASConfigurationEntry.getAlias(), string, String.valueOf(n)}, jAASLoginModule);
            } else {
                this.addError("ERROR_APPLICATION_JAAS_LOGIN_MODULE_AUTHENTICATION_STRATEGY_INVALID", new String[]{jAASConfigurationEntry.getAlias(), string, String.valueOf(n)}, jAASLoginModule);
            }
        }
    }

    public boolean testJAASModuleControlFlag(int n) {
        return true;
    }

    public boolean testIIOPSecurityProtocolKind(int n) {
        return true;
    }

    public boolean testLDAPDirectoryType(int n) {
        return true;
    }
}

