/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.extensions.applicationext;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.base.extensions.applicationext.ApplicationExtensionMessageConstants;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class ApplicationExtensionValidator
extends J2EEValidator
implements ApplicationExtensionMessageConstants {
    String appDisplayName = null;

    public String getBaseName() {
        return "com.ibm.websphere.validation.base.extensions.applicationext.applicationextvalidation";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to ear file.");
        }
        String string = stringArray[0];
        try {
            EARFile eARFile = CommonarchiveFactoryImpl.getActiveFactory().openEARFile(string);
            ApplicationExtension applicationExtension = eARFile.getExtensions();
            PassthruHelper passthruHelper = new PassthruHelper(applicationExtension);
            FullReporter fullReporter = new FullReporter();
            ApplicationExtensionValidator applicationExtensionValidator = new ApplicationExtensionValidator();
            applicationExtensionValidator.validate(passthruHelper, fullReporter);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public ISchedulingRule getSchedulingRule(IValidationContext iValidationContext) {
        return null;
    }

    public void validate(ApplicationExtension applicationExtension) {
        try {
            Application application = applicationExtension.getApplication();
            if (application == null) {
                this.addError("NULL_APPLICATION_REFERENCE");
                return;
            }
            this.appDisplayName = application.getDisplayName();
            this.validateModuleExtensions(applicationExtension);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        this._reporter = iReporter;
        this._helper = iValidationContext;
        if (this._reporter == null || this._helper == null) {
            return;
        }
        try {
            Object object = this._helper.loadModel("ApplicationExtension");
            if (object == null) {
                return;
            }
            this.validate((ApplicationExtension)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_APPLICATIONEXT_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }

    public void validateModuleExtension(ModuleExtension moduleExtension) {
        String string;
        if (moduleExtension == null || (string = moduleExtension.getDependentClasspath()) != null) {
            // empty if block
        }
    }

    public void validateModuleExtensions(ApplicationExtension applicationExtension) {
        EList eList = applicationExtension.getModuleExtensions();
        if (eList != null) {
            return;
        }
        HashMap<Module, ModuleExtension> hashMap = new HashMap<Module, ModuleExtension>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ModuleExtension moduleExtension = (ModuleExtension)iterator.next();
            Module module = moduleExtension.getModule();
            if (module == null) {
                this.addError("NULL_MODULE_REFERENCE", new String[]{this.appDisplayName});
                return;
            }
            String string = "?";
            if (module.getUri() != null) {
                string = module.getUri();
            }
            if (hashMap.containsKey(module)) {
                this.addError("DUPLICATE_MODULE_EXTENSION", new String[]{string, this.appDisplayName});
                continue;
            }
            hashMap.put(module, moduleExtension);
            this.validateModuleExtension(moduleExtension);
        }
    }
}

