/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.extensions.ejbext;

import com.ibm.ejs.models.base.extensions.ejbext.AccessIntent;
import com.ibm.ejs.models.base.extensions.ejbext.BeanCache;
import com.ibm.ejs.models.base.extensions.ejbext.BeanInternationalization;
import com.ibm.ejs.models.base.extensions.ejbext.BeanStructure;
import com.ibm.ejs.models.base.extensions.ejbext.ContainerActivitySession;
import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbGeneralization;
import com.ibm.ejs.models.base.extensions.ejbext.EjbRelationship;
import com.ibm.ejs.models.base.extensions.ejbext.EjbRelationshipRole;
import com.ibm.ejs.models.base.extensions.ejbext.EjbqlFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.IsolationLevelAttributes;
import com.ibm.ejs.models.base.extensions.ejbext.LocalTran;
import com.ibm.ejs.models.base.extensions.ejbext.PersistenceSecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SessionExtension;
import com.ibm.ejs.models.base.extensions.ejbext.UseCallerIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseSystemIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.WhereClauseFinderDescriptor;
import com.ibm.websphere.validation.base.extensions.ejbext.EJBExtensionMessageConstants;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class EJBExtensionValidator
extends J2EEValidator
implements EJBExtensionMessageConstants {
    public String getBaseName() {
        return "com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation";
    }

    public ISchedulingRule getSchedulingRule(IValidationContext iValidationContext) {
        return null;
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        super.validate(iValidationContext, iReporter);
        this.validate(iValidationContext.loadModel(""));
    }

    public void validate(Object object) {
        if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                this.validate(iterator.next());
            }
        } else if (object instanceof EJBJarExtension) {
            this.validate((EJBJarExtension)object);
        } else {
            String[] stringArray = new String[]{object.getClass().getName()};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_TARGET", stringArray);
        }
    }

    private void validate(AccessIntent accessIntent) {
        if (accessIntent.getMethodElements().size() == 0) {
            String[] stringArray = new String[]{"METHOD_ELEMENT", "ACCESS_INTENT"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(BeanCache beanCache) {
    }

    private void validate(BeanInternationalization beanInternationalization) {
    }

    private void validate(BeanStructure beanStructure) {
    }

    private void validate(ContainerActivitySession containerActivitySession) {
        if (containerActivitySession.getMethodElement().size() == 0) {
            String[] stringArray = new String[]{"METHOD_ELEMENT", "CONTAINER_ACTIVITY_SESSION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(ContainerManagedEntityExtension containerManagedEntityExtension) {
        if (containerManagedEntityExtension.getPersistenceSecurityIdentity() != null) {
            this.validate(containerManagedEntityExtension.getPersistenceSecurityIdentity());
        }
        Iterator iterator = containerManagedEntityExtension.getAccessIntents().iterator();
        HashSet<EList> hashSet = new HashSet<EList>();
        while (iterator.hasNext()) {
            AccessIntent accessIntent = (AccessIntent)iterator.next();
            this.validate(accessIntent);
            hashSet.add(accessIntent.getMethodElements());
        }
        this.validateMethodElements(hashSet, "ACCESS_INTENT");
        this.validateForFinders(containerManagedEntityExtension);
        this.validateForAssociations(containerManagedEntityExtension);
    }

    private void validate(EjbGeneralization ejbGeneralization) {
        String[] stringArray;
        if (ejbGeneralization.getSupertype() == null) {
            stringArray = new String[]{"SUPER_TYPE", "EJB_GENERALIZATION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        if (ejbGeneralization.getSubtype() == null) {
            stringArray = new String[]{"SUB_TYPE", "EJB_GENERALIZATION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        if (ejbGeneralization.getEjbJarExtension() == null) {
            stringArray = new String[]{"EJB_JAR_EXTENSION", "EJB_GENERALIZATION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(EJBJarExtension eJBJarExtension) {
        String[] stringArray;
        EJBJar eJBJar = eJBJarExtension.getEjbJar();
        if (eJBJar == null) {
            stringArray = new String[]{"EJB_JAR", "EJB_JAR_EXTENSION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        stringArray = eJBJarExtension.getEjbExtensions().iterator();
        HashSet<EnterpriseBean> hashSet = new HashSet<EnterpriseBean>();
        while (stringArray.hasNext()) {
            String[] stringArray2;
            EnterpriseBeanExtension enterpriseBeanExtension = (EnterpriseBeanExtension)stringArray.next();
            EnterpriseBean enterpriseBean = enterpriseBeanExtension.getEnterpriseBean();
            if (eJBJar != null && !eJBJar.getEnterpriseBeans().contains((Object)enterpriseBean)) {
                stringArray2 = new String[]{"ENTERPRISE_BEAN", "ENTERPRISE_BEAN_EXTENSION", "EJB_JAR"};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_UNDEFINED", stringArray2);
            }
            if (hashSet.contains(enterpriseBean)) {
                stringArray2 = new String[]{"ENTERPRISE_BEAN_EXTENSION", "EJB_JAR_EXTENSION"};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_DUPLICATE", stringArray2);
            } else {
                hashSet.add(enterpriseBean);
            }
            this.validate(enterpriseBeanExtension);
        }
        this.validateForAssociations(eJBJarExtension);
    }

    private void validate(EjbqlFinderDescriptor ejbqlFinderDescriptor) {
    }

    private void validate(EjbRelationship ejbRelationship) {
        String[] stringArray;
        String[] stringArray2;
        if (ejbRelationship.getEjbJarExtension() == null) {
            stringArray2 = new String[]{"EJB_JAR_EXTENSION", "EJB_RELATIONSHIP"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray2);
        }
        if (ejbRelationship.getRelationshipRoles().size() != 2) {
            stringArray2 = new String[]{"EJB_JAR_EXTENSION", "EJB_RELATIONSHIP", "2"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NUMBER", stringArray2);
            return;
        }
        stringArray2 = ejbRelationship.getFirstRole();
        EjbRelationshipRole ejbRelationshipRole = ejbRelationship.getSecondRole();
        if (!stringArray2.getMultiplicity().isMany() && ejbRelationshipRole.getMultiplicity().isMany()) {
            if (stringArray2.isForward()) {
                stringArray = new String[]{"ONE_MANY", "FIRST_ROLE", Boolean.toString(stringArray2.isForward())};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
            if (!ejbRelationshipRole.isForward()) {
                stringArray = new String[]{"ONE_MANY", "SECOND_ROLE", Boolean.toString(ejbRelationshipRole.isForward())};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
        }
        if (stringArray2.getMultiplicity().isMany() && !ejbRelationshipRole.getMultiplicity().isMany()) {
            if (!stringArray2.isForward()) {
                stringArray = new String[]{"MANY_ONE", "FIRST_ROLE", Boolean.toString(stringArray2.isForward())};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
            if (ejbRelationshipRole.isForward()) {
                stringArray = new String[]{"MANY_ONE", "SECOND_ROLE", Boolean.toString(ejbRelationshipRole.isForward())};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
        }
        if (!stringArray2.getMultiplicity().isMany() && !ejbRelationshipRole.getMultiplicity().isMany() && !stringArray2.isForward() != ejbRelationshipRole.isForward()) {
            stringArray = new String[]{"ONE_ONE", "EJB_RELATIONSHIP"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_OPPOSITE");
        }
    }

    private void validate(EjbRelationshipRole ejbRelationshipRole) {
        String[] stringArray;
        if (ejbRelationshipRole.getBeanExtension() == null) {
            stringArray = new String[]{"CONTAINER_MANAGED_ENTITY_EXTENSION ", "EJB_RELATIONSHIP_ROLE"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        if (ejbRelationshipRole.getRelationship() == null) {
            stringArray = new String[]{"EJB_RELATIONSHIP", "EJB_RELATIONSHIP_ROLE"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(EnterpriseBeanExtension enterpriseBeanExtension) {
        Object object;
        Object object2;
        String[] stringArray;
        if (enterpriseBeanExtension.getEjbJarExtension() == null) {
            stringArray = new String[]{"EJB_JAR_EXTENSION", "ENTERPRISE_BEAN_EXTENSION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        if (enterpriseBeanExtension.getEnterpriseBean() == null) {
            stringArray = new String[]{"ENTERPRISE_BEAN", "ENTERPRISE_BEAN_EXTENSION"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        stringArray = enterpriseBeanExtension.getIsolationLevelAttributes().iterator();
        HashSet<EList> hashSet = new HashSet<EList>();
        while (stringArray.hasNext()) {
            object2 = (IsolationLevelAttributes)stringArray.next();
            this.validate((IsolationLevelAttributes)object2);
            hashSet.add(object2.getMethodElements());
        }
        this.validateMethodElements(hashSet, "ISOLATION_LEVEL_ATTRIBUTES");
        object2 = enterpriseBeanExtension.getMethodSessionAttributes().iterator();
        hashSet = new HashSet();
        while (object2.hasNext()) {
            object = (ContainerActivitySession)object2.next();
            this.validate((ContainerActivitySession)object);
            hashSet.add(object.getMethodElement());
        }
        this.validateMethodElements(hashSet, "CONTAINER_ACTIVITY_SESSION");
        object = enterpriseBeanExtension.getRunAsSettings().iterator();
        hashSet = new HashSet();
        while (object.hasNext()) {
            SecurityIdentity securityIdentity = (SecurityIdentity)object.next();
            this.validate(securityIdentity);
            hashSet.add(securityIdentity.getMethodElements());
        }
        this.validateMethodElements(hashSet, "SECURITY_IDENTITY");
        if (enterpriseBeanExtension.getLocalTran() != null) {
            this.validate(enterpriseBeanExtension.getLocalTran());
        }
        if (enterpriseBeanExtension.getBeanCache() != null) {
            this.validate(enterpriseBeanExtension.getBeanCache());
        }
        if (enterpriseBeanExtension.getInternationalization() != null) {
            this.validate(enterpriseBeanExtension.getInternationalization());
        }
        if (enterpriseBeanExtension.getStructure() != null) {
            this.validate(enterpriseBeanExtension.getStructure());
        }
        if (enterpriseBeanExtension instanceof SessionExtension) {
            this.validate((SessionExtension)enterpriseBeanExtension);
        } else if (enterpriseBeanExtension instanceof ContainerManagedEntityExtension) {
            this.validate((ContainerManagedEntityExtension)enterpriseBeanExtension);
        }
    }

    private void validate(FinderDescriptor finderDescriptor) {
        String[] stringArray;
        EList eList = finderDescriptor.getFinderMethodElements();
        if (eList.size() != 1) {
            stringArray = new String[]{"METHOD_ELEMENT", "FINDER_DESCRIPTOR", "1"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NUMBER", stringArray);
        }
        stringArray = eList.iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2;
            MethodElement methodElement = (MethodElement)stringArray.next();
            if (methodElement.getType().getValue() != 2) {
                stringArray2 = new String[]{"METHOD_ELEMENT", "FINDER_DESCRIPTOR", "HOME "};
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_TYPE", stringArray2);
            }
            if (methodElement.getMethods().length == 1) continue;
            stringArray2 = new String[]{"METHOD_ELEMENT", "FINDER_DESCRIPTOR", "METHOD ", "1"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_FINDERDESCRIPTOR_WRONG_METHOD", stringArray2);
        }
        if (finderDescriptor instanceof EjbqlFinderDescriptor) {
            this.validate((EjbqlFinderDescriptor)finderDescriptor);
        }
        if (finderDescriptor instanceof FullSelectFinderDescriptor) {
            this.validate((FullSelectFinderDescriptor)finderDescriptor);
        }
        if (finderDescriptor instanceof WhereClauseFinderDescriptor) {
            this.validate((WhereClauseFinderDescriptor)finderDescriptor);
        }
    }

    private void validate(FullSelectFinderDescriptor fullSelectFinderDescriptor) {
    }

    private void validate(IsolationLevelAttributes isolationLevelAttributes) {
        if (isolationLevelAttributes.getMethodElements().size() == 0) {
            String[] stringArray = new String[]{"METHOD_ELEMENT", "ISOLATION_LEVEL_ATTRIBUTES"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(LocalTran localTran) {
    }

    private void validate(PersistenceSecurityIdentity persistenceSecurityIdentity) {
        RunAsMode runAsMode = persistenceSecurityIdentity.getRunAsMode();
        if (runAsMode == null) {
            String[] stringArray = new String[]{"RUN_AS_MODE", "PERSISTENCE_SECURITY_IDENTITY"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        } else {
            this.validate(runAsMode);
        }
    }

    private void validate(RunAsMode runAsMode) {
        if (runAsMode instanceof RunAsSpecifiedIdentity) {
            this.validate((RunAsSpecifiedIdentity)runAsMode);
        } else if (runAsMode instanceof UseSystemIdentity) {
            this.validate((UseSystemIdentity)runAsMode);
        } else if (runAsMode instanceof UseCallerIdentity) {
            this.validate((UseCallerIdentity)runAsMode);
        }
    }

    private void validate(RunAsSpecifiedIdentity runAsSpecifiedIdentity) {
    }

    private void validate(SecurityIdentity securityIdentity) {
        String[] stringArray;
        RunAsMode runAsMode = securityIdentity.getRunAsMode();
        if (runAsMode == null) {
            stringArray = new String[]{"RUN_AS_MODE", "SECURITY_IDENTITY"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        } else {
            this.validate(runAsMode);
        }
        if (securityIdentity.getMethodElements().size() == 0) {
            stringArray = new String[]{"METHOD_ELEMENT", "SECURITY_IDENTITY"};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(SessionExtension sessionExtension) {
        int n = sessionExtension.getTimeout();
        if (n < 0) {
            String[] stringArray = new String[]{"TIMEOUT ", "SESSION_EXTENSION ", String.valueOf(n)};
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_VALUE_RANGE", stringArray);
        }
    }

    private void validate(UseCallerIdentity useCallerIdentity) {
    }

    private void validate(UseSystemIdentity useSystemIdentity) {
    }

    private void validate(WhereClauseFinderDescriptor whereClauseFinderDescriptor) {
    }

    private void validateForAssociations(ContainerManagedEntityExtension containerManagedEntityExtension) {
        Iterator iterator = containerManagedEntityExtension.getLocalRelationshipRoles().iterator();
        while (iterator.hasNext()) {
            this.validate((EjbRelationshipRole)iterator.next());
        }
    }

    private void validateForAssociations(EJBJarExtension eJBJarExtension) {
        Iterator iterator = eJBJarExtension.getGeneralizations().iterator();
        while (iterator.hasNext()) {
            this.validate((EjbGeneralization)iterator.next());
        }
        Iterator iterator2 = eJBJarExtension.getEjbRelationships().iterator();
        while (iterator2.hasNext()) {
            this.validate((EjbRelationship)iterator2.next());
        }
    }

    private void validateForFinders(ContainerManagedEntityExtension containerManagedEntityExtension) {
        Iterator iterator = containerManagedEntityExtension.getFinderDescriptors().iterator();
        while (iterator.hasNext()) {
            this.validate((FinderDescriptor)iterator.next());
        }
    }

    private void validateMethodElements(HashSet hashSet, String string) {
        Iterator iterator = hashSet.iterator();
        HashSet<String> hashSet2 = new HashSet<String>();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((EList)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                String[] stringArray;
                MethodElement methodElement = (MethodElement)iterator2.next();
                String string2 = methodElement.getName();
                String string3 = methodElement.getType().toString();
                String string4 = string3 + "." + string2;
                if (hashSet2.contains(string4)) {
                    stringArray = new String[]{string4, string};
                    this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "MESSAGE_DEFINITION_OVERLAP", stringArray);
                    continue;
                }
                if (string2.equals("*")) {
                    if (hashSet2.contains(string3 + ".**")) {
                        stringArray = new String[]{string4, string};
                        this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "MESSAGE_DEFINITION_OVERLAP", stringArray);
                    }
                } else if (hashSet2.contains(string3 + ".*")) {
                    stringArray = new String[]{string4, string};
                    this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "MESSAGE_DEFINITION_OVERLAP", stringArray);
                } else {
                    hashSet2.add(string3 + ".**");
                }
                hashSet2.add(string4);
            }
        }
    }
}

