/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.bundling;

import com.ibm.ejs.ras.BundleResolver;
import com.ibm.ejs.ras.BundleResolverImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidationMessage
implements IMessage {
    public static final String pgmVersion = "1.4.1.1";
    public static final String pgmUpdate = "8/29/06";
    protected static TraceComponent tc = Tr.register(ValidationMessage.class, null, null);
    protected String bundleName;
    protected String messageId;
    protected String[] params;
    protected int severity;
    protected Object targetObject;
    protected static BundleResolver bundleResolver = new BundleResolverImpl();

    public ValidationMessage(String string, int n, String string2, String[] stringArray, Object object) {
        this.setBundleName(string);
        this.setSeverity(n);
        this.setId(string2);
        this.setParams(stringArray);
        this.setTargetObject(object);
    }

    public ValidationMessage(String string, int n, String string2, String[] stringArray) {
        this.setBundleName(string);
        this.setSeverity(n);
        this.setId(string2);
        this.setParams(stringArray);
        this.setTargetObject(null);
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getId() {
        return this.messageId;
    }

    public void setId(String string) {
        this.messageId = string;
    }

    public void setParams(String[] stringArray) {
        this.params = stringArray;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setTargetObject(Object object) {
        this.targetObject = object;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setGroupName(String string) {
    }

    public String getGroupName() {
        return null;
    }

    public void setLength(int n) {
    }

    public int getLength() {
        return -1;
    }

    public void setLineNo(int n) {
    }

    public int getLineNo() {
        return -1;
    }

    public void setOffset(int n) {
    }

    public int getOffset() {
        return -1;
    }

    public ResourceBundle getBundle(Locale locale) {
        return null;
    }

    public String getText() {
        return this.getText(Locale.getDefault(), null);
    }

    public String getText(ClassLoader classLoader) {
        return this.getText(Locale.getDefault(), classLoader);
    }

    public String getText(Locale locale) {
        return this.getText(locale, null);
    }

    public String getText(Locale locale, ClassLoader classLoader) {
        Object object;
        Exception exception;
        String string;
        ResourceBundle resourceBundle;
        String string2 = this.getBundleName();
        try {
            resourceBundle = bundleResolver.resolve(string2, locale);
            string = null;
            exception = null;
        }
        catch (Exception exception2) {
            resourceBundle = null;
            string = "Failed to load message bundle: ";
            exception = exception2;
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string2, locale);
            }
            catch (RuntimeException runtimeException) {
                string = "Failed to load message bundle: ";
                exception = runtimeException;
            }
        }
        if (resourceBundle == null) {
            try {
                object = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                object = null;
                string = "Failed to retrieve context class loader for bundle: ";
                exception = privilegedActionException;
            }
            if (object != null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string2, locale, (ClassLoader)object);
                }
                catch (RuntimeException runtimeException) {
                    string = "Failed to load message bundle using context class loader: ";
                    exception = runtimeException;
                }
            }
        }
        if (resourceBundle != null) {
            Object[] objectArray;
            object = this.getId();
            try {
                string = resourceBundle.getString((String)object);
                exception = null;
            }
            catch (MissingResourceException missingResourceException) {
                string = "Failed to load message text: ";
                exception = missingResourceException;
            }
            if (exception == null && (objectArray = this.getParams()) != null) {
                string = MessageFormat.format(string, objectArray);
            }
        }
        if (exception != null) {
            string = string + this.getDefaultText();
            Tr.error(tc, string, exception);
        }
        return string;
    }

    public String getDefaultText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ValidationMessage [ ");
        stringBuffer.append(this.getBundleName());
        stringBuffer.append(" : ");
        stringBuffer.append(this.getId());
        stringBuffer.append(" ]");
        String[] stringArray = this.getParams();
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("; parameters:");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(" [ ");
                stringBuffer.append(Integer.toString(i));
                stringBuffer.append(" : ");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ]");
            }
        }
        return stringBuffer.toString();
    }

    public int getLineNumber() {
        return 0;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public void setAttribute(String string, Object object) {
    }

    public void setMarkerId(String string) {
    }

    public String getMarkerId() {
        return null;
    }

    public HashMap getAttributes() {
        return null;
    }
}

