/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.pme.config.level60;

import com.ibm.websphere.models.config.pmecluster.PMEClusterExtension;
import com.ibm.websphere.models.config.pmiservice.PMIService;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.wlmadvisor.ClusterWeightType;
import com.ibm.websphere.models.config.wlmadvisor.WeightAdvisor;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.pme.config.level60.PMEValidationConstants_60;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class PMEClusterCrossValidator_60
extends WebSpherePlatformCrossValidator
implements PMEValidationConstants_60 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";

    public String getBundleId() {
        return "com.ibm.websphere.validation.pme.config.level60.pmevalidation_60";
    }

    public String getTraceName() {
        return "PMEClusterCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof PMEClusterExtension) {
            this.trace("Object recognized as a PMEClusterExtension; validating");
            EList eList = ((PMEClusterExtension)object).getAdvisors();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof WeightAdvisor)) continue;
                this.validateAcross((WeightAdvisor)e2);
            }
        }
        return true;
    }

    public void validateAcross(WeightAdvisor weightAdvisor) {
        ClusterWeightType clusterWeightType;
        if (weightAdvisor != null && (clusterWeightType = weightAdvisor.getAdvisorType()) != null && clusterWeightType.equals(ClusterWeightType.WEB_SPHERE_DYNAMIC_WEIGHTING_LITERAL)) {
            this.validateClusterMembersPMI(weightAdvisor);
        }
    }

    public void validateClusterMembersPMI(WeightAdvisor weightAdvisor) {
        Object object = this.loadSiblingModel("cluster.xml");
        if (object instanceof List) {
            Object object2;
            Object object3;
            List list = (List)object;
            ServerCluster serverCluster = null;
            if (list != null) {
                object3 = list.iterator();
                if (serverCluster == null && object3.hasNext() && (object2 = object3.next()) instanceof ServerCluster) {
                    serverCluster = (ServerCluster)object2;
                }
            }
            if (serverCluster != null) {
                object3 = serverCluster.getName();
                object2 = serverCluster.getMembers();
                Iterator iterator = object2.iterator();
                boolean bl = false;
                while (!bl && iterator.hasNext()) {
                    Object e2 = iterator.next();
                    ClusterMember clusterMember = (ClusterMember)e2;
                    String string = clusterMember.getMemberName();
                    String string2 = clusterMember.getNodeName();
                    bl = this.validateNodePMI(string2, string);
                }
                if (bl) {
                    this.addError("ERROR_PME_CLUSTER_DYNAMIC_WEIGHTING_REQUIRES_PMI", new String[]{object3}, weightAdvisor);
                }
            }
        }
    }

    public boolean validateNodePMI(String string, String string2) {
        Object object;
        Server server2;
        Object object2;
        String string3;
        boolean bl = false;
        String string4 = this.getCellUri() + "/nodes/" + string + "/servers/";
        String string5 = string4 + "nodeagent/server.xml";
        Object object3 = this.loadModel(string5);
        if (object3 instanceof List) {
            string3 = null;
            object2 = (List)object3;
            if (object2 != null && (server2 = object2.iterator()).hasNext() && (object = server2.next()) instanceof Server) {
                string3 = (Server)object;
            }
            if (string3 != null) {
                bl = this.validateServerPMI((Server)string3);
            }
        }
        if ((object2 = this.loadModel(string3 = string4 + string2 + "/server.xml")) instanceof List) {
            Object e2;
            Iterator iterator;
            server2 = null;
            object = (List)object2;
            if (object != null && (iterator = object.iterator()).hasNext() && (e2 = iterator.next()) instanceof Server) {
                server2 = (Server)e2;
            }
            if (server2 != null) {
                bl |= this.validateServerPMI(server2);
            }
        }
        return bl;
    }

    public boolean validateServerPMI(Server server2) {
        boolean bl = false;
        EList eList = server2.getServices();
        Iterator iterator = eList.iterator();
        while (!bl && iterator.hasNext()) {
            Object e2 = iterator.next();
            Service service = (Service)e2;
            if (!(service instanceof PMIService)) continue;
            PMIService pMIService = (PMIService)service;
            bl = !pMIService.isEnable();
        }
        return bl;
    }
}

