/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.pme.config.level60;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.websphere.models.config.applicationserver.DynamicCacheReplicationKind;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.dynacache.CacheInstance;
import com.ibm.websphere.models.config.dynacache.CacheProvider;
import com.ibm.websphere.models.config.multibroker.drsclient.DRSRuntimeMode;
import com.ibm.websphere.models.config.objectpoolmanager.ObjectPool;
import com.ibm.websphere.models.config.objectpoolmanager.ObjectPoolManagerInfo;
import com.ibm.websphere.models.config.objectpoolmanager.ObjectPoolProvider;
import com.ibm.websphere.models.config.scheduler.SchedulerConfiguration;
import com.ibm.websphere.models.config.scheduler.SchedulerProvider;
import com.ibm.websphere.models.config.workmanager.TimerManagerInfo;
import com.ibm.websphere.models.config.workmanager.TimerManagerProvider;
import com.ibm.websphere.models.config.workmanager.WorkManagerInfo;
import com.ibm.websphere.models.config.workmanager.WorkManagerProvider;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextValidator_60;
import com.ibm.websphere.validation.pme.config.level60.PMEValidationConstants_60;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class PMEResourcesValidator_60_Default
extends ServerContextValidator_60
implements PMEValidationConstants_60 {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "5/9/05";
    protected boolean _pastTopList = false;

    public PMEResourcesValidator_60_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.pme.config.level60.pmevalidation_60";
    }

    public String getTraceName() {
        return "PMEResourcesValidator";
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
    }

    protected void visitList(List list) throws ValidationException {
        if (!this._pastTopList) {
            this._pastTopList = true;
            this.validateRootResources(list);
        }
        super.visitList(list);
    }

    protected void validateRootResources(List list) {
        String string = this.getCurrentFileName();
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            this.addError("ERROR_PME_EMPTY_DOCUMENT", new String[]{string}, null);
        } else {
            String string2 = null;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Object object = null;
                if (string.endsWith("resources-pme.xml")) {
                    if (!(e2 instanceof ObjectPoolProvider || e2 instanceof SchedulerProvider || e2 instanceof WorkManagerProvider || e2 instanceof TimerManagerProvider)) {
                        string2 = "ObjectPoolProvider, SchedulerProvider, WorkManagerProvider, TimerManagerProvider";
                        object = e2;
                    }
                } else if (string.endsWith("resources-pme502.xml") && !(e2 instanceof CacheProvider)) {
                    string2 = "CacheProvider, WebSphereBusinessIntegrationAdapterProvider";
                    object = e2;
                }
                if (object == null) continue;
                this.addError("ERROR_PME_INVALID_ROOT_OBJECT", new String[]{string, object.getClass().getName(), string2}, object);
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof CacheProvider) {
            this.trace("Object recognized as an CacheProvider; validating");
            this.validateLocal((CacheProvider)object);
            this.validateAcross((CacheProvider)object);
        } else if (object instanceof CacheInstance) {
            this.trace("Object recognized as an CacheInstance; validating");
            this.validateLocal((CacheInstance)object);
            this.validateAcross((CacheInstance)object);
        } else if (object instanceof DRSSettings) {
            this.trace("Object recognized as an DRSSettings; validating");
            this.validateLocal((DRSSettings)object);
            this.validateAcross((DRSSettings)object);
        } else if (object instanceof ObjectPoolProvider) {
            this.trace("Object recognized as a ObjectPoolProvider; validating");
            this.validateLocal((ObjectPoolProvider)object);
            this.validateAcross((ObjectPoolProvider)object);
        } else if (object instanceof ObjectPoolManagerInfo) {
            this.trace("Object recognized as a ObjectPoolManagerInfo; validating");
            this.validateLocal((ObjectPoolManagerInfo)object);
            this.validateAcross((ObjectPoolManagerInfo)object);
        } else if (object instanceof ObjectPool) {
            this.trace("Object recognized as a ObjectPool; validating");
            this.validateLocal((ObjectPool)object);
            this.validateAcross((ObjectPool)object);
        } else if (object instanceof SchedulerProvider) {
            this.trace("Object recognized as a SchedulerProvider; validating");
            this.validateLocal((SchedulerProvider)object);
            this.validateAcross((SchedulerProvider)object);
        } else if (object instanceof SchedulerConfiguration) {
            this.trace("Object recognized as a SchedulerConfiguration; validating");
            this.validateLocal((SchedulerConfiguration)object);
            this.validateAcross((SchedulerConfiguration)object);
        } else if (object instanceof WorkManagerProvider) {
            this.trace("Object recognized as a WorkManagerProvider; validating");
            this.validateLocal((WorkManagerProvider)object);
            this.validateAcross((WorkManagerProvider)object);
        } else if (object instanceof WorkManagerInfo) {
            this.trace("Object recognized as a WorkManagerInfo; validating");
            this.validateLocal((WorkManagerInfo)object);
            this.validateAcross((WorkManagerInfo)object);
        } else if (object instanceof J2EEResourcePropertySet) {
            this.trace("Object recognized as a J2EEResourcePropertySet; validating");
            this.validateLocal((J2EEResourcePropertySet)object);
            this.validateAcross((J2EEResourcePropertySet)object);
        } else if (object instanceof J2EEResourceProperty) {
            this.trace("Object recognized as a J2EEResourceProperty; validating");
            this.validateLocal((J2EEResourceProperty)object);
            this.validateAcross((J2EEResourceProperty)object);
        } else if (!(object instanceof TimerManagerProvider || object instanceof TimerManagerInfo || (bl = super.basicValidate(object)))) {
            this.trace("Object not recognized");
            this.addError("ERROR_PME_RECOGNITION_FAILED", new String[]{this.getCurrentFileName(), object.getClass().getName()}, object);
        }
        return bl;
    }

    public void validateAcross(CacheProvider cacheProvider) {
    }

    public void validateLocal(CacheProvider cacheProvider) {
        this.validateProvider((J2EEResourceProvider)cacheProvider);
    }

    public void validateAcross(CacheInstance cacheInstance) {
    }

    public void validateLocal(CacheInstance cacheInstance) {
        this.validateFactory((J2EEResourceFactory)cacheInstance);
        if (cacheInstance != null) {
            String string;
            int n;
            if (!cacheInstance.isSetCacheSize()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{cacheInstance.getClass().getName(), "cacheSize"}, cacheInstance);
            } else {
                n = cacheInstance.getCacheSize();
                if (n < 100 || n > 200000) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{cacheInstance.getClass().getName(), "cacheSize", "100", "200000"}, cacheInstance);
                }
            }
            if (!cacheInstance.isSetDefaultPriority()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{cacheInstance.getClass().getName(), "defaultPriority"}, cacheInstance);
            } else {
                n = cacheInstance.getDefaultPriority();
                if (n < 0 || n > 255) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{cacheInstance.getClass().getName(), "defaultPriority", "0", "255"}, cacheInstance);
                }
            }
            if (!cacheInstance.isSetReplicationType()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{cacheInstance.getClass().getName(), "replicationType"}, cacheInstance);
            } else {
                DynamicCacheReplicationKind dynamicCacheReplicationKind = cacheInstance.getReplicationType();
                String string2 = dynamicCacheReplicationKind != null ? dynamicCacheReplicationKind.getName() : null;
                if (string2 != null) {
                    if (string2.equals("PUSH") || string2.equals("PUSH_PULL")) {
                        if (!cacheInstance.isSetPushFrequency()) {
                            this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{cacheInstance.getClass().getName(), "pushFrequency"}, cacheInstance);
                        } else {
                            int n2 = cacheInstance.getPushFrequency();
                            if (n2 < 0) {
                                this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{cacheInstance.getClass().getName(), "pushFrequency", "0", Integer.toString(Integer.MAX_VALUE)}, cacheInstance);
                            }
                        }
                    } else if (!string2.equals("NONE") && !string2.equals("PULL")) {
                        this.addError("ERROR_PME_INVALID_ATTRIBUTE_VALUE", new String[]{cacheInstance.getClass().getName(), "replicationType", "NONE, PUSH, PULL, PUSH_PULL"}, cacheInstance);
                    }
                }
            }
            if (!cacheInstance.isSetEnableDiskOffload()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{cacheInstance.getClass().getName(), "enableDiskOffload"}, cacheInstance);
            } else if (cacheInstance.isEnableDiskOffload() && ((string = cacheInstance.getDiskOffloadLocation()) == null || string.length() == 0)) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{cacheInstance.getClass().getName(), "diskOffloadLocation"}, cacheInstance);
            }
            int n3 = cacheInstance.getHashSize();
            if (n3 < 1024 || n3 > 4096) {
                this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{cacheInstance.getClass().getName(), "hashSize", "1024", "4096"}, cacheInstance);
            }
        }
    }

    public void validateAcross(DRSSettings dRSSettings) {
    }

    public void validateLocal(DRSSettings dRSSettings) {
        if (dRSSettings != null) {
            String string;
            DRSRuntimeMode dRSRuntimeMode = dRSSettings.getDataReplicationMode();
            String string2 = dRSRuntimeMode != null ? dRSRuntimeMode.getName() : null;
            if (!(string2 == null || string2.equals("BOTH") || string2.equals("CLIENT") || string2.equals("SERVER"))) {
                this.addError("ERROR_PME_INVALID_ATTRIBUTE_VALUE", new String[]{dRSSettings.getClass().getName(), "dataReplicationMode", "BOTH, CLIENT, SERVER"}, dRSSettings);
            }
            if ((string = dRSSettings.getMessageBrokerDomainName()) == null || string.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{dRSSettings.getClass().getName(), "messageBrokerDomainName"}, dRSSettings);
            }
        }
    }

    public void validateAcross(ObjectPoolProvider objectPoolProvider) {
    }

    public void validateLocal(ObjectPoolProvider objectPoolProvider) {
        this.validateProvider((J2EEResourceProvider)objectPoolProvider);
    }

    public void validateAcross(ObjectPoolManagerInfo objectPoolManagerInfo) {
    }

    public void validateLocal(ObjectPoolManagerInfo objectPoolManagerInfo) {
        this.validateFactory((J2EEResourceFactory)objectPoolManagerInfo);
    }

    public void validateAcross(ObjectPool objectPool) {
    }

    public void validateLocal(ObjectPool objectPool) {
        if (objectPool != null) {
            String string;
            String string2 = objectPool.getPoolClassName();
            if (string2 == null || string2.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{objectPool.getClass().getName(), "poolClassName"}, objectPool);
            }
            if ((string = objectPool.getPoolImplClassName()) == null || string.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{objectPool.getClass().getName(), "poolImplClassName"}, objectPool);
            }
        }
    }

    public void validateAcross(SchedulerProvider schedulerProvider) {
    }

    public void validateLocal(SchedulerProvider schedulerProvider) {
        this.validateProvider((J2EEResourceProvider)schedulerProvider);
    }

    public void validateAcross(SchedulerConfiguration schedulerConfiguration) {
    }

    public void validateLocal(SchedulerConfiguration schedulerConfiguration) {
        this.validateFactory((J2EEResourceFactory)schedulerConfiguration);
        if (schedulerConfiguration != null) {
            int n;
            String string = schedulerConfiguration.getDatasourceJNDIName();
            if (string == null || string.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{schedulerConfiguration.getClass().getName(), "datasourceJNDIName"}, schedulerConfiguration);
            }
            if ((n = schedulerConfiguration.getPollInterval()) < 0) {
                this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{schedulerConfiguration.getClass().getName(), "pollInterval", "0", Integer.toString(Integer.MAX_VALUE)}, schedulerConfiguration);
            }
        }
    }

    public void validateAcross(WorkManagerProvider workManagerProvider) {
    }

    public void validateLocal(WorkManagerProvider workManagerProvider) {
        this.validateProvider((J2EEResourceProvider)workManagerProvider);
    }

    public void validateAcross(WorkManagerInfo workManagerInfo) {
    }

    public void validateLocal(WorkManagerInfo workManagerInfo) {
        this.validateFactory((J2EEResourceFactory)workManagerInfo);
        if (workManagerInfo != null) {
            int n;
            if (!workManagerInfo.isSetNumAlarmThreads()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workManagerInfo.getClass().getName(), "numAlarmThreads"}, workManagerInfo);
            } else {
                n = workManagerInfo.getNumAlarmThreads();
                if (n < 1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workManagerInfo.getClass().getName(), "numAlarmThreads", "1", Integer.toString(Integer.MAX_VALUE)}, workManagerInfo);
                }
            }
            if (!workManagerInfo.isSetMinThreads()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workManagerInfo.getClass().getName(), "minThreads"}, workManagerInfo);
            } else {
                n = workManagerInfo.getMinThreads();
                if (n < 1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workManagerInfo.getClass().getName(), "minThreads", "1", Integer.toString(Integer.MAX_VALUE)}, workManagerInfo);
                }
            }
            if (!workManagerInfo.isSetMaxThreads()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workManagerInfo.getClass().getName(), "maxThreads"}, workManagerInfo);
            } else {
                n = workManagerInfo.getMaxThreads();
                if (n < 1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workManagerInfo.getClass().getName(), "maxThreads", "1", Integer.toString(Integer.MAX_VALUE)}, workManagerInfo);
                }
            }
            if (!workManagerInfo.isSetThreadPriority()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workManagerInfo.getClass().getName(), "threadPriority"}, workManagerInfo);
            } else {
                n = workManagerInfo.getThreadPriority();
                if (n < 1 || n > 10) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workManagerInfo.getClass().getName(), "threadPriority", Integer.toString(1), Integer.toString(10)}, workManagerInfo);
                }
            }
            if (!workManagerInfo.isSetIsGrowable()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workManagerInfo.getClass().getName(), "isGrowable"}, workManagerInfo);
            }
        }
    }

    public void validateAcross(J2EEResourcePropertySet j2EEResourcePropertySet) {
    }

    public void validateLocal(J2EEResourcePropertySet j2EEResourcePropertySet) {
    }

    public void validateAcross(J2EEResourceProperty j2EEResourceProperty) {
    }

    public void validateLocal(J2EEResourceProperty j2EEResourceProperty) {
        if (j2EEResourceProperty != null) {
            String string;
            String string2;
            String string3 = j2EEResourceProperty.getName();
            if (string3 == null || string3.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{j2EEResourceProperty.getClass().getName(), "name"}, j2EEResourceProperty);
            }
            if ((string2 = j2EEResourceProperty.getType()) == null || string2.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{j2EEResourceProperty.getClass().getName(), "type"}, j2EEResourceProperty);
            }
            if ((string = j2EEResourceProperty.getValue()) == null) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{j2EEResourceProperty.getClass().getName(), "value"}, j2EEResourceProperty);
            }
        }
    }

    public void validateProvider(J2EEResourceProvider j2EEResourceProvider) {
        String string;
        if (j2EEResourceProvider != null && ((string = j2EEResourceProvider.getName()) == null || string.length() == 0)) {
            this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{j2EEResourceProvider.getClass().getName(), "name"}, j2EEResourceProvider);
        }
    }

    public void validateFactory(J2EEResourceFactory j2EEResourceFactory) {
        if (j2EEResourceFactory != null) {
            String string;
            String string2 = j2EEResourceFactory.getName();
            if (string2 == null || string2.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{j2EEResourceFactory.getClass().getName(), "name"}, j2EEResourceFactory);
            }
            if ((string = j2EEResourceFactory.getJndiName()) == null || string.length() == 0) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{j2EEResourceFactory.getClass().getName(), "jndiName"}, j2EEResourceFactory);
            }
        }
    }
}

