/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.pme.config.level60;

import com.ibm.websphere.models.config.activitysessionservice.ActivitySessionService;
import com.ibm.websphere.models.config.appprofileservice.ApplicationProfileService;
import com.ibm.websphere.models.config.compensationservice.CompensationService;
import com.ibm.websphere.models.config.dynacacheservice.CacheInstanceService;
import com.ibm.websphere.models.config.i18nservice.I18NService;
import com.ibm.websphere.models.config.objectpoolservice.ObjectPoolService;
import com.ibm.websphere.models.config.pmeserver.PME502ServerExtension;
import com.ibm.websphere.models.config.pmeserver.PME51ServerExtension;
import com.ibm.websphere.models.config.pmeserver.PMEServerExtension;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.schedulerservice.SchedulerService;
import com.ibm.websphere.models.config.startupbeansservice.StartupBeansService;
import com.ibm.websphere.models.config.workareaservice.WorkAreaPartition;
import com.ibm.websphere.models.config.workareaservice.WorkAreaPartitionService;
import com.ibm.websphere.models.config.workareaservice.WorkAreaService;
import com.ibm.websphere.models.config.workmanagerservice.WorkManagerService;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextValidator_60;
import com.ibm.websphere.validation.pme.config.level60.PMEValidationConstants_60;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class PMEServerValidator_60_Default
extends ServerContextValidator_60
implements PMEValidationConstants_60 {
    public static final String pgmVersion = "1.2";
    public static final String pgmUpdate = "8/4/05";
    protected boolean _pastTopList = false;

    public PMEServerValidator_60_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.pme.config.level60.pmevalidation_60";
    }

    public String getTraceName() {
        return "PMEServerValidator";
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
    }

    protected void visitList(List list) throws ValidationException {
        if (!this._pastTopList) {
            this._pastTopList = true;
            this.validateRootServer(list);
        }
        super.visitList(list);
    }

    protected void validateRootServer(List list) {
        String string = this.getCurrentFileName();
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            this.addError("ERROR_PME_EMPTY_DOCUMENT", new String[]{string}, null);
        } else {
            Object e2 = iterator.next();
            if (string.endsWith("server-pme.xml")) {
                if (!(e2 instanceof PMEServerExtension)) {
                    this.addError("ERROR_PME_INVALID_ROOT_OBJECT", new String[]{string, e2.getClass().getName(), PMEServerExtension.class.getName()}, e2);
                }
            } else if (string.endsWith("server-pme502.xml")) {
                if (!(e2 instanceof PME502ServerExtension)) {
                    this.addError("ERROR_PME_INVALID_ROOT_OBJECT", new String[]{string, e2.getClass().getName(), PME502ServerExtension.class.getName()}, e2);
                }
            } else if (string.endsWith("server-pme51.xml") && !(e2 instanceof PME51ServerExtension)) {
                this.addError("ERROR_PME_INVALID_ROOT_OBJECT", new String[]{string, e2.getClass().getName(), PME51ServerExtension.class.getName()}, e2);
            }
            if (iterator.hasNext()) {
                this.addError("ERROR_PME_DOCUMENT_HAS_MULTIPLE_ROOTS", new String[]{string}, null);
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof PMEServerExtension) {
            this.trace("Object recognized as a PMEServerExtension; validating");
            this.validateLocal((PMEServerExtension)object);
            this.validateAcross((PMEServerExtension)object);
        } else if (object instanceof PME502ServerExtension) {
            this.trace("Object recognized as a PME502ServerExtension; validating");
            this.validateLocal((PME502ServerExtension)object);
            this.validateAcross((PME502ServerExtension)object);
        } else if (object instanceof PME51ServerExtension) {
            this.trace("Object recognized as a PME51ServerExtension; validating");
            this.validateLocal((PME51ServerExtension)object);
            this.validateAcross((PME51ServerExtension)object);
        } else if (object instanceof ActivitySessionService) {
            this.trace("Object recognized as an ActivitySessionService; validating");
            this.validateLocal((ActivitySessionService)object);
            this.validateAcross((ActivitySessionService)object);
        } else if (object instanceof ApplicationProfileService) {
            this.trace("Object recognized as an ApplicationProfileService; validating");
            this.validateLocal((ApplicationProfileService)object);
            this.validateAcross((ApplicationProfileService)object);
        } else if (object instanceof CacheInstanceService) {
            this.trace("Object recognized as a CacheInstanceService; validating");
            this.validateLocal((CacheInstanceService)object);
            this.validateAcross((CacheInstanceService)object);
        } else if (object instanceof CompensationService) {
            this.trace("Object recognized as a CompensationService; validating");
            this.validateLocal((CompensationService)object);
            this.validateAcross((CompensationService)object);
        } else if (object instanceof I18NService) {
            this.trace("Object recognized as an I18NService; validating");
            this.validateLocal((I18NService)object);
            this.validateAcross((I18NService)object);
        } else if (object instanceof ObjectPoolService) {
            this.trace("Object recognized as an ObjectPoolService; validating");
            this.validateLocal((ObjectPoolService)object);
            this.validateAcross((ObjectPoolService)object);
        } else if (object instanceof SchedulerService) {
            this.trace("Object recognized as a SchedulerService; validating");
            this.validateLocal((SchedulerService)object);
            this.validateAcross((SchedulerService)object);
        } else if (object instanceof WorkAreaService) {
            this.trace("Object recognized as a WorkAreaService; validating");
            this.validateLocal((WorkAreaService)object);
            this.validateAcross((WorkAreaService)object);
        } else if (object instanceof WorkAreaPartitionService) {
            this.trace("Object recognized as a WorkAreaPartitionService; validating");
            this.validateLocal((WorkAreaPartitionService)object);
            this.validateAcross((WorkAreaPartitionService)object);
        } else if (object instanceof WorkAreaPartition) {
            this.trace("Object recognized as a WorkAreaPartition; validating");
            this.validateLocal((WorkAreaPartition)object);
            this.validateAcross((WorkAreaPartition)object);
        } else if (object instanceof WorkManagerService) {
            this.trace("Object recognized as a WorkManagerService; validating");
            this.validateLocal((WorkManagerService)object);
            this.validateAcross((WorkManagerService)object);
        } else if (object instanceof StartupBeansService) {
            this.trace("Object recognized as a startup beans service; validating.");
            this.validateLocal((StartupBeansService)object);
            this.validateAcross((StartupBeansService)object);
        } else {
            bl = super.basicValidate(object);
            if (!bl) {
                this.trace("Object not recognized");
                this.addError("ERROR_PME_RECOGNITION_FAILED", new String[]{this.getCurrentFileName(), object.getClass().getName()}, object);
            }
        }
        return bl;
    }

    public void validateAcross(PMEServerExtension pMEServerExtension) {
    }

    public void validateLocal(PMEServerExtension pMEServerExtension) {
    }

    public void validateAcross(PME502ServerExtension pME502ServerExtension) {
    }

    public void validateLocal(PME502ServerExtension pME502ServerExtension) {
    }

    public void validateAcross(PME51ServerExtension pME51ServerExtension) {
    }

    public void validateLocal(PME51ServerExtension pME51ServerExtension) {
    }

    public void validateAcross(ActivitySessionService activitySessionService) {
    }

    public void validateLocal(ActivitySessionService activitySessionService) {
        this.validateService((Service)activitySessionService);
        if (activitySessionService != null) {
            if (!activitySessionService.isSetDefaultTimeout()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{activitySessionService.getClass().getName(), "defaultTimeout"}, activitySessionService);
            } else {
                int n = activitySessionService.getDefaultTimeout();
                if (n < -1 || n > 1000000000) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{activitySessionService.getClass().getName(), "defaultTimeout", "-1", "1000000000"}, activitySessionService);
                }
            }
        }
    }

    public void validateAcross(ApplicationProfileService applicationProfileService) {
    }

    public void validateLocal(ApplicationProfileService applicationProfileService) {
        this.validateService((Service)applicationProfileService);
    }

    public void validateAcross(CacheInstanceService cacheInstanceService) {
    }

    public void validateLocal(CacheInstanceService cacheInstanceService) {
        this.validateService((Service)cacheInstanceService);
    }

    public void validateAcross(CompensationService compensationService) {
    }

    public void validateLocal(CompensationService compensationService) {
        this.validateService((Service)compensationService);
    }

    public void validateAcross(I18NService i18NService) {
    }

    public void validateLocal(I18NService i18NService) {
        this.validateService((Service)i18NService);
    }

    public void validateAcross(ObjectPoolService objectPoolService) {
    }

    public void validateLocal(ObjectPoolService objectPoolService) {
        this.validateService((Service)objectPoolService);
    }

    public void validateAcross(SchedulerService schedulerService) {
    }

    public void validateLocal(SchedulerService schedulerService) {
        this.validateService((Service)schedulerService);
    }

    public void validateAcross(WorkAreaService workAreaService) {
    }

    public void validateLocal(WorkAreaService workAreaService) {
        this.validateService((Service)workAreaService);
        if (workAreaService != null) {
            int n;
            if (!workAreaService.isSetMaxSendSize()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaService.getClass().getName(), "maxSendSize"}, workAreaService);
            } else {
                n = workAreaService.getMaxSendSize();
                if (n < -1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workAreaService.getClass().getName(), "maxSendSize", "-1", Integer.toString(Integer.MAX_VALUE)}, workAreaService);
                }
            }
            if (!workAreaService.isSetMaxReceiveSize()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaService.getClass().getName(), "maxReceiveSize"}, workAreaService);
            } else {
                n = workAreaService.getMaxReceiveSize();
                if (n < -1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workAreaService.getClass().getName(), "maxReceiveSize", "-1", Integer.toString(Integer.MAX_VALUE)}, workAreaService);
                }
            }
        }
    }

    public void validateAcross(WorkAreaPartitionService workAreaPartitionService) {
    }

    public void validateLocal(WorkAreaPartitionService workAreaPartitionService) {
        this.validateService((Service)workAreaPartitionService);
    }

    public void validateAcross(WorkAreaPartition workAreaPartition) {
    }

    public void validateLocal(WorkAreaPartition workAreaPartition) {
        if (workAreaPartition != null) {
            int n;
            String string = workAreaPartition.getName();
            if (string == null) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaPartition.getClass().getName(), "name"}, workAreaPartition);
            }
            if (!workAreaPartition.isSetEnable()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaPartition.getClass().getName(), "enable"}, workAreaPartition);
            }
            if (!workAreaPartition.isSetBidirectional()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaPartition.getClass().getName(), "bidirectional"}, workAreaPartition);
            }
            if (!workAreaPartition.isSetMaxSendSize()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaPartition.getClass().getName(), "maxSendSize"}, workAreaPartition);
            } else {
                n = workAreaPartition.getMaxSendSize();
                if (n < -1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workAreaPartition.getClass().getName(), "maxSendSize", "-1", Integer.toString(Integer.MAX_VALUE)}, workAreaPartition);
                }
            }
            if (!workAreaPartition.isSetMaxReceiveSize()) {
                this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{workAreaPartition.getClass().getName(), "maxReceiveSize"}, workAreaPartition);
            } else {
                n = workAreaPartition.getMaxReceiveSize();
                if (n < -1) {
                    this.addError("ERROR_PME_ATTRIBUTE_VALUE_OUT_OF_RANGE", new String[]{workAreaPartition.getClass().getName(), "maxReceiveSize", "-1", Integer.toString(Integer.MAX_VALUE)}, workAreaPartition);
                }
            }
        }
    }

    public void validateAcross(WorkManagerService workManagerService) {
    }

    public void validateAcross(StartupBeansService startupBeansService) {
    }

    public void validateLocal(WorkManagerService workManagerService) {
        this.validateService((Service)workManagerService);
    }

    public void validateLocal(StartupBeansService startupBeansService) {
        this.validateService((Service)startupBeansService);
    }

    public void validateService(Service service) {
        if (service != null && !service.isSetEnable()) {
            this.addError("ERROR_PME_REQUIRED_ATTRIBUTE", new String[]{service.getClass().getName(), "enable"}, service);
        }
    }
}

