/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim;

import com.ibm.websphere.wim.Service;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.EnvironmentManager;
import com.ibm.ws.wim.EventManager;
import com.ibm.ws.wim.ProfileManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.management.EventDataWrapper;
import com.ibm.ws.wim.pluginmanager.PluginManager;
import com.ibm.ws.wim.tx.JTAHelper;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceProvider
implements Service {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ServiceProvider.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String message = "dynamic update configuration event";
    private static ServiceProvider singleton = null;
    private ConfigManager configManager = null;
    private SchemaManager schemaManager = null;
    private ProfileManager profileManager = null;
    private DynamicReloadManager dynaReloadManager = null;
    private EventManager eventManager = null;
    private TransactionControl txControl = null;
    private EnvironmentManager environmentManager = null;
    private static JTAHelper jtaHelper = new JTAHelper();

    public static synchronized ServiceProvider singleton() throws WIMException {
        if (singleton == null) {
            singleton = new ServiceProvider();
        }
        return singleton;
    }

    public void initialize() throws WIMException {
        this.configManager = ConfigManager.singleton();
        PluginManager.singleton();
        this.schemaManager = SchemaManager.singleton();
        this.profileManager = ProfileManager.singleton();
        this.environmentManager = EnvironmentManager.singleton();
        this.dynaReloadManager = DynamicReloadManager.singleton();
        this.eventManager = EventManager.singleton();
    }

    private ServiceProvider() throws WIMException {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEPackages(String string) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API getEPackages", string);
        }
        byte[] byArray = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            byArray = this.schemaManager.getEPackages(string);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("getEPackages", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API getEPackages", byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject createSchema(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API createSchema", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.schemaManager.createSchema(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("createSchema", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API createSchema", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getSchema(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API getSchema", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.schemaManager.getSchema(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("getSchema", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API getSchema", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject createDataObject(String string, String string2) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API createDataObject");
        }
        DataObject dataObject = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject = this.schemaManager.createDataObject(string, string2);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("createDataObject", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API createDataObject", WIMTraceHelper.printDataGraph(dataObject));
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject createRootDataObject() throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API createRootDataObject");
        }
        DataObject dataObject = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject = this.schemaManager.createRootDataObject();
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("createRootDataObject", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API createRootDataObject", WIMTraceHelper.printDataGraph(dataObject));
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject create(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API create", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.profileManager.create(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("create", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API create", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject get(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API get", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.profileManager.get(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("get", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API get", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject delete(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API delete", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.profileManager.delete(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("delete", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API delete", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject update(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API update", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.profileManager.update(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("update", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API update", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject search(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API search", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.profileManager.search(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("search", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API search", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject login(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API login", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject2 = this.profileManager.login(dataObject);
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("login", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API login", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getConfigEPackage() throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API getConfigEPackage");
        }
        byte[] byArray = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            byArray = this.configManager.getConfigEPackage();
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("getConfigEPackage", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API getConfigEPackage");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getConfig() throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API getConfig");
        }
        DataObject dataObject = null;
        TxHandle txHandle = null;
        boolean bl = false;
        this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
        boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
        try {
            if (bl2) {
                txHandle = this.txControl.preinvoke(false, false);
            }
            dataObject = this.configManager.getConfig();
            bl = true;
        }
        catch (Exception exception) {
            jtaHelper.handleException(exception);
        }
        finally {
            if (bl2) {
                jtaHelper.closeTransaction("getConfig", this.txControl, txHandle, bl);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API getConfig", WIMTraceHelper.printDataGraph(dataObject));
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_API dynamicUpdateConfig", WIMMessageHelper.generateMsgParms(string, hashtable));
        }
        if (DynamicReloadManager.isRunningOnDeploymentManager() || DynamicReloadManager.isRunningOnSingleServer()) {
            TxHandle txHandle = null;
            boolean bl = false;
            if (this.txControl == null && this.environmentManager != null && !this.environmentManager.isDirectAccessMode()) {
                this.txControl = jtaHelper.getTransactionControl(this.txControl, this.environmentManager);
            }
            boolean bl2 = jtaHelper.useTransaction(this.txControl, this.environmentManager);
            try {
                if (bl2) {
                    txHandle = this.txControl.preinvoke(false, false);
                }
                if (!this.eventManager.isListeningToEvent(string)) {
                    throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_EVENT_NOT_SUPPORT", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "dynamicUpdateConfig");
                }
                EventDataWrapper eventDataWrapper = new EventDataWrapper(string, hashtable);
                this.eventManager.dynamicUpdateConfig(string, hashtable);
                if (DynamicReloadManager.isRunningOnDeploymentManager()) {
                    this.dynaReloadManager.broadcastEventAtDeploymentManager(string, message, eventDataWrapper);
                }
                bl = true;
            }
            catch (Exception exception) {
                jtaHelper.handleException(exception);
            }
            finally {
                if (bl2) {
                    jtaHelper.closeTransaction("dynamicUpdateConfig", this.txControl, txHandle, bl);
                }
            }
        } else {
            throw new DynamicUpdateConfigException("DYNAMIC_RELOAD_INVALID_UPDATE_AT_MANAGED_NODE", CLASSNAME, "dynamicUpdateConfig");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API dynamicUpdateConfig");
        }
    }
}

