/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.async;

import com.ibm.websphere.wim.exception.InvalidTicketException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ticket {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = Ticket.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String REPOID_START = "<reposId>";
    private static final String REPOID_END = "</reposId>";
    private static final String TICKET_START = "<ticket>";
    private static final String TICKET_END = "</ticket>";
    private static final String POST_PROCESS_START = "<postProcess>";
    private static final String POST_PROCESS_END = "</postProcess>";
    private static final String PAGING_SIZE_START = "<pagingSize>";
    private static final String PAGING_SIZE_END = "</pagingSize>";
    private static final String COUNT_LIMIT_START = "<countLimit>";
    private static final String COUNT_LIMIT_END = "</countLimit>";
    private static final String SEARCH_LIMIT_START = "<searchLimit>";
    private static final String SEARCH_LIMIT_END = "</searchLimit>";
    private String repoId = null;
    private Object ticket = null;
    private String postProcess = null;
    private int pagingSize = 0;
    private int countLimit = 0;
    private int searchLimit = 0;

    private Ticket() {
    }

    public Ticket(String string, Object object) {
        this.repoId = string;
        this.ticket = object;
    }

    public Ticket(String string) throws InvalidTicketException {
        if (string != null) {
            String string2;
            int n = string.indexOf(REPOID_START);
            int n2 = string.indexOf(REPOID_END);
            int n3 = string.indexOf(TICKET_START);
            int n4 = string.indexOf(TICKET_END);
            int n5 = string.indexOf(POST_PROCESS_START);
            int n6 = string.indexOf(POST_PROCESS_END);
            int n7 = string.indexOf(PAGING_SIZE_START);
            int n8 = string.indexOf(PAGING_SIZE_END);
            int n9 = string.indexOf(COUNT_LIMIT_START);
            int n10 = string.indexOf(COUNT_LIMIT_END);
            int n11 = string.indexOf(SEARCH_LIMIT_START);
            int n12 = string.indexOf(SEARCH_LIMIT_END);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "Ticket(String)", "repoIdStartIndex=" + n + ", repoIdEndIndex=" + n2 + ", ticketStartIndex=" + n3 + ", ticketEndIndex=" + n4);
            }
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
            }
            this.repoId = string.substring(n + REPOID_START.length(), n2);
            this.ticket = string.substring(n3 + TICKET_START.length(), n4);
            if (n5 > 0 && n6 > 0) {
                this.postProcess = string.substring(n5 + POST_PROCESS_START.length(), n6);
            }
            if (n7 > 0 && n8 > 0) {
                if (n7 >= n8 - PAGING_SIZE_START.length()) {
                    throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
                }
                string2 = string.substring(n7 + PAGING_SIZE_START.length(), n8);
                try {
                    this.pagingSize = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
                }
            }
            if (n9 > 0 && n10 > 0) {
                if (n9 >= n10 - COUNT_LIMIT_START.length()) {
                    throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
                }
                string2 = string.substring(n9 + COUNT_LIMIT_START.length(), n10);
                try {
                    this.countLimit = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
                }
            }
            if (n11 > 0 && n12 > 0) {
                if (n11 >= n12 - SEARCH_LIMIT_START.length()) {
                    throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
                }
                string2 = string.substring(n11 + SEARCH_LIMIT_START.length(), n12);
                try {
                    this.searchLimit = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidTicketException("INVALID_TICKET", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "Ticket(String)");
                }
            }
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "Ticket(String)", "repoId=" + this.repoId + ", ticket=" + this.ticket + ", postProcess=" + this.postProcess);
            }
        }
    }

    public String getRepositoryId() {
        return this.repoId;
    }

    public String getPostProcess() {
        return this.postProcess;
    }

    public void setPostProcess(String string) {
        this.postProcess = string;
    }

    public Object getTicket() {
        return this.ticket;
    }

    public int getPagingSize() {
        return this.pagingSize;
    }

    public void setPagingSize(int n) {
        this.pagingSize = n;
    }

    public void setCountLimit(int n) {
        this.countLimit = n;
    }

    public int getCountLimit() {
        return this.countLimit;
    }

    public void setSearchLimit(int n) {
        this.searchLimit = n;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(REPOID_START);
        stringBuffer.append(this.repoId);
        stringBuffer.append(REPOID_END);
        if (this.postProcess != null) {
            stringBuffer.append(POST_PROCESS_START);
            stringBuffer.append(this.postProcess);
            stringBuffer.append(POST_PROCESS_END);
        }
        if (this.pagingSize > 0) {
            stringBuffer.append(PAGING_SIZE_START);
            stringBuffer.append(new Integer(this.pagingSize).toString());
            stringBuffer.append(PAGING_SIZE_END);
        }
        if (this.countLimit > 0) {
            stringBuffer.append(COUNT_LIMIT_START);
            stringBuffer.append(new Integer(this.countLimit).toString());
            stringBuffer.append(COUNT_LIMIT_END);
        }
        if (this.searchLimit > 0) {
            stringBuffer.append(SEARCH_LIMIT_START);
            stringBuffer.append(new Integer(this.searchLimit).toString());
            stringBuffer.append(SEARCH_LIMIT_END);
        }
        stringBuffer.append(TICKET_START);
        stringBuffer.append(this.ticket);
        stringBuffer.append(TICKET_END);
        return stringBuffer.toString();
    }
}

