/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.client;

import com.ibm.websphere.wim.Service;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.client.LocalService;
import com.ibm.websphere.wim.ejb.WIMServiceHome;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wim.util.XSDHelper;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;

public class LocalServiceProvider
implements LocalService {
    private static final String CLASSNAME = LocalServiceProvider.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public static final String PROVIDER_URL = "providerURL";
    public static final String EJB_JNDI_NAME = "ejbJNDIName";
    private Service service = null;
    private String providerURL = null;
    private String ejbName = "ejb/com/ibm/websphere/wim/ejb/WIMServiceHome";
    private String ctxFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private EPackage configSchema = null;

    public LocalServiceProvider() throws WIMException {
        this.service = ServiceProvider.singleton();
    }

    public LocalServiceProvider(Hashtable hashtable) throws WIMException, NamingException, CreateException, RemoteException {
        if (hashtable != null) {
            String string;
            this.providerURL = (String)hashtable.remove(PROVIDER_URL);
            if (this.providerURL != null && (string = (String)hashtable.remove(EJB_JNDI_NAME)) != null) {
                this.ejbName = string;
            }
        }
        this.locateService(hashtable);
    }

    private void registerConfigSchema() throws WIMException, RemoteException {
        byte[] byArray = null;
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerConfigSchema", "Retrieving config schema...");
        }
        byArray = this.service.getConfigEPackage();
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerConfigSchema", "Config schema returned.");
        }
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerConfigSchema", "Registering config schema...");
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.createResource(URI.createURI((String)".ecore"));
        try {
            resource.load((InputStream)byteArrayInputStream, Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {
            throw new WIMSystemException(iOException.toString());
        }
        this.configSchema = (EPackage)resource.getContents().get(0);
        String string = this.configSchema.getNsURI();
        if (this.configSchema != XMLNamespacePackage.eINSTANCE) {
            this.configSchema.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
        }
        EPackage.Registry.INSTANCE.put((Object)string, (Object)this.configSchema);
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerConfigSchema", "Config schema registered.");
        }
    }

    private void registerSchemas() throws WIMException, RemoteException {
        byte[] byArray = null;
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerSchemas", "Retrieving model schema...");
        }
        byArray = this.service.getEPackages(null);
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerSchemas", "Model schema returned.");
        }
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerSchemas", "Registering model schema...");
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.createResource(URI.createURI((String)".ecore"));
        try {
            resource.load((InputStream)byteArrayInputStream, Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {
            throw new WIMSystemException(iOException.toString());
        }
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            EPackage ePackage = (EPackage)resource.getContents().get(i);
            String string = ePackage.getNsURI();
            if (ePackage != XMLNamespacePackage.eINSTANCE) {
                ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
            }
            EPackage.Registry.INSTANCE.put((Object)string, (Object)ePackage);
        }
        if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "registerSchemas", "Model schema registered.");
        }
    }

    private void locateService(Hashtable hashtable) throws WIMException, RemoteException, CreateException, NamingException {
        if (this.providerURL != null) {
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            hashtable.put("java.naming.provider.url", this.providerURL);
            hashtable.put("java.naming.factory.initial", this.ctxFactory);
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext(hashtable);
            }
            catch (NamingException namingException) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "locateService", "Can not create InitialContext using properties: " + hashtable, namingException);
                throw namingException;
            }
            if (trcLogger.isLoggable(Level.INFO)) {
                trcLogger.logp(Level.INFO, CLASSNAME, "locateService", "Looking up EJB: " + this.providerURL + "...");
            }
            WIMServiceHome wIMServiceHome = null;
            try {
                Object object = initialContext.lookup(this.ejbName);
                wIMServiceHome = (WIMServiceHome)PortableRemoteObject.narrow((Object)object, WIMServiceHome.class);
            }
            catch (NamingException namingException) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "locateService", "Can not find EJB: " + this.ejbName, namingException);
                throw namingException;
            }
            if (trcLogger.isLoggable(Level.INFO)) {
                trcLogger.logp(Level.INFO, CLASSNAME, "locateService", "EJB " + this.ejbName + " is found.");
            }
            try {
                this.service = wIMServiceHome.create();
            }
            catch (CreateException createException) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "locateService", "Can not create EJB " + this.ejbName, createException);
                throw createException;
            }
            if (EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/wim") == null) {
                this.registerSchemas();
            }
            if (EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/wim/config") == null) {
                this.registerConfigSchema();
            }
        } else {
            this.service = ServiceProvider.singleton();
        }
    }

    public DataObject createRootDataObject() throws WIMException, RemoteException {
        return this.service.createRootDataObject();
    }

    public EPackage getSchemaPackage(String string) throws WIMException {
        return XSDHelper.getPackage(string);
    }

    public byte[] getEPackages(String string) throws WIMException, RemoteException {
        return this.service.getEPackages(string);
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException, RemoteException {
        DataObject dataObject2 = this.service.createSchema(dataObject);
        if (this.providerURL != null) {
            this.registerSchemas();
        }
        return dataObject2;
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.getSchema(dataObject);
    }

    public DataObject createDataObject(String string, String string2) throws WIMException, RemoteException {
        return SDOHelper.createDataObject(string, string2);
    }

    public DataObject create(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.create(dataObject);
    }

    public DataObject get(DataObject dataObject) throws WIMException, RemoteException {
        DataObject dataObject2 = this.service.get(dataObject);
        if (this.providerURL != null && !dataObject2.getDataGraph().getChangeSummary().isLogging()) {
            dataObject2.getDataGraph().getChangeSummary().beginLogging();
        }
        return dataObject2;
    }

    public DataObject delete(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.delete(dataObject);
    }

    public DataObject update(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.update(dataObject);
    }

    public DataObject search(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.search(dataObject);
    }

    public DataObject login(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.login(dataObject);
    }

    public byte[] getConfigEPackage() throws WIMException, RemoteException {
        return this.service.getConfigEPackage();
    }

    public DataObject getConfig() throws WIMException, RemoteException {
        return this.service.getConfig();
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException, RemoteException {
        this.service.dynamicUpdateConfig(string, hashtable);
    }
}

