/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.common;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;

public class EntryUuidGenerator {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static long m_gregorianChange = 0L;
    private static long m_lastTime = 0L;
    private static int m_count = 0;
    private static int m_clockSeqVariant = 0;
    private static String m_nodeId = null;
    private static final String ZEROES = "00000000000000000000";

    private static String toHexString(long l, int n) {
        String string = Long.toHexString(l);
        return ZEROES.substring(0, n - string.length()) + string;
    }

    public static synchronized String newEntryUuid() {
        long l = Calendar.getInstance().getTime().getTime();
        if (l < m_lastTime) {
            m_clockSeqVariant &= 0x3FFF;
            ++m_clockSeqVariant;
            m_clockSeqVariant &= 0x3FFF;
            m_clockSeqVariant |= 0x8000;
            m_lastTime = l;
            m_count = 0;
        } else if (l == m_lastTime) {
            if (m_count == 9999) {
                System.err.println("EntryUuidGenerator: rolled over counter within one clock tick");
                m_lastTime = ++l;
                m_count = 0;
            } else {
                ++m_count;
            }
        } else {
            m_lastTime = l;
            m_count = 0;
        }
        long l2 = (l - m_gregorianChange) * 10000L;
        long l3 = (l2 += (long)m_count) & 0xFFFFFFFFL;
        long l4 = (l2 >>= 32) & 0xFFFFL;
        long l5 = (l2 >>= 16) & 0xFFFL | 0x1000L;
        return EntryUuidGenerator.toHexString(l3, 8) + "-" + EntryUuidGenerator.toHexString(l4, 4) + "-" + EntryUuidGenerator.toHexString(l5, 4) + "-" + EntryUuidGenerator.toHexString(m_clockSeqVariant, 4) + "-" + m_nodeId;
    }

    static {
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            gregorianCalendar.set(1582, 9, 15, 0, 0, 0);
            m_gregorianChange = gregorianCalendar.getTime().getTime();
            Random random = new Random(System.currentTimeMillis() % 1000L);
            m_clockSeqVariant = 0x3FFF & random.nextInt();
            m_clockSeqVariant |= 0x8000;
            int n = 0;
            byte[] byArray = InetAddress.getLocalHost().getHostName().getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                n += byArray[i];
            }
            n = n & Short.MAX_VALUE | 0x8000;
            long l = System.currentTimeMillis() / 1000L & 0xFFFFFFFFFFFFFFFFL;
            m_nodeId = EntryUuidGenerator.toHexString(n, 4) + EntryUuidGenerator.toHexString(l, 8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            m_nodeId = "800000000000";
            m_gregorianChange = 0L;
            m_clockSeqVariant = 32768;
        }
    }
}

