/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.exception;

import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.Routines;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WIMException
extends Exception {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final int SUCCESS = 0;
    private String messageKey = null;
    private String messageBundle = "com.ibm.websphere.wim.ras.properties.CWWIMMessages";
    private Object[] messageParams = null;
    private boolean rootErrorSet = false;
    private int rootErrorCode = 0;
    private String rootErrorMessage = null;
    private Object rootErrorSource = null;
    private static final String CONSTRUCTOR_METHOD = "<init>";
    private static final String CLASSNAME = WIMException.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(WIMException.class.getPackage().getName());
    private static Level defaultSeverity = Level.FINE;
    private static final String EMPTY_MSG = "";

    public WIMException() {
        trcLogger.logp(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, EMPTY_MSG, this);
    }

    public WIMException(String string) {
        super(string);
        this.messageKey = string;
        trcLogger.logp(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, string, this);
    }

    public WIMException(String string, String string2, String string3) {
        super(string);
        this.messageKey = string;
        trcLogger.logp(defaultSeverity, string2, string3, string, this);
    }

    public WIMException(String string, Level level, String string2, String string3) {
        super(string);
        this.messageKey = string;
        trcLogger.logp(level, string2, string3, string, this);
    }

    public WIMException(String string, String string2) {
        super(string);
        this.messageKey = string;
        this.messageBundle = string2;
        trcLogger.logrb(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, this.messageBundle, this.messageKey, (Throwable)this);
    }

    public WIMException(String string, String string2, String string3, String string4) {
        super(string);
        this.messageKey = string;
        this.messageBundle = string2;
        trcLogger.logrb(defaultSeverity, string3, string4, this.messageBundle, this.messageKey, (Throwable)this);
    }

    public WIMException(String string, String string2, Level level, String string3, String string4) {
        super(string);
        this.messageKey = string;
        this.messageBundle = string2;
        trcLogger.logrb(level, string3, string4, this.messageBundle, this.messageKey, (Throwable)this);
    }

    public WIMException(String string, Object[] objectArray) {
        super(string);
        this.messageKey = string;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.logrb2(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, Object[] objectArray, String string2, String string3) {
        super(string);
        this.messageKey = string;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.logrb2(defaultSeverity, string2, string3, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, Object[] objectArray, Level level, String string2, String string3) {
        super(string);
        this.messageKey = string;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.logrb2(level, string2, string3, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, String string2, Object[] objectArray) {
        super(string);
        this.messageKey = string;
        this.messageBundle = string2;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.logrb2(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, String string2, Object[] objectArray, String string3, String string4) {
        super(string);
        this.messageKey = string;
        this.messageBundle = string2;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.logrb2(defaultSeverity, string3, string4, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, String string2, Object[] objectArray, Level level, String string3, String string4) {
        super(string);
        this.messageKey = string;
        this.messageBundle = string2;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.logrb2(level, string3, string4, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(Throwable throwable) {
        super(throwable);
        this.propagateRootError(throwable);
        trcLogger.logp(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, EMPTY_MSG, this);
    }

    public WIMException(String string, String string2, Throwable throwable) {
        super(throwable);
        this.propagateRootError(throwable);
        trcLogger.logp(defaultSeverity, string, string2, EMPTY_MSG, this);
    }

    public WIMException(Level level, String string, String string2, Throwable throwable) {
        super(throwable);
        this.propagateRootError(throwable);
        trcLogger.logp(level, string, string2, EMPTY_MSG, this);
    }

    public WIMException(String string, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.propagateRootError(throwable);
        trcLogger.logp(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, string, this);
    }

    public WIMException(String string, String string2, String string3, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.propagateRootError(throwable);
        trcLogger.logp(defaultSeverity, string2, string3, string, this);
    }

    public WIMException(String string, Level level, String string2, String string3, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.propagateRootError(throwable);
        trcLogger.logp(level, string2, string3, string, this);
    }

    public WIMException(String string, String string2, String string3, String string4, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageBundle = string2;
        this.propagateRootError(throwable);
        trcLogger.logrb(defaultSeverity, string3, string4, this.messageBundle, this.messageKey, (Throwable)this);
    }

    public WIMException(String string, String string2, Level level, String string3, String string4, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageBundle = string2;
        this.propagateRootError(throwable);
        trcLogger.logrb(level, string3, string4, this.messageBundle, this.messageKey, (Throwable)this);
    }

    public WIMException(String string, Object[] objectArray, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.propagateRootError(throwable);
        this.logrb2(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, Object[] objectArray, String string2, String string3, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.propagateRootError(throwable);
        this.logrb2(defaultSeverity, string2, string3, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, Object[] objectArray, Level level, String string2, String string3, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.propagateRootError(throwable);
        this.logrb2(level, string2, string3, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, String string2, Object[] objectArray, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageBundle = string2;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.propagateRootError(throwable);
        this.logrb2(defaultSeverity, this.getClass().getName(), CONSTRUCTOR_METHOD, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, String string2, Object[] objectArray, String string3, String string4, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageBundle = string2;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.propagateRootError(throwable);
        this.logrb2(defaultSeverity, string3, string4, this.messageBundle, this.messageKey, this.messageParams);
    }

    public WIMException(String string, String string2, Object[] objectArray, Level level, String string3, String string4, Throwable throwable) {
        super(string, throwable);
        this.messageKey = string;
        this.messageBundle = string2;
        this.messageParams = Routines.arrayCopy(objectArray);
        this.propagateRootError(throwable);
        this.logrb2(level, string3, string4, this.messageBundle, this.messageKey, this.messageParams);
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public Object[] getMessageParams() {
        return Routines.arrayCopy(this.messageParams);
    }

    public boolean isRootErrorSet() {
        return this.rootErrorSet;
    }

    public void setRootErrorCode(int n) {
        this.setRootErrorCode(defaultSeverity, n);
    }

    public void setRootErrorCode(Level level, int n) {
        if (n != 0) {
            this.rootErrorCode = n;
            this.rootErrorSet = true;
            trcLogger.logp(level, this.getClass().getName(), "setRootErrorCode", "root error code=" + this.rootErrorCode);
        }
    }

    public int getRootErrorCode() {
        return this.rootErrorCode;
    }

    public void setRootErrorMessage(String string) {
        this.setRootErrorMessage(defaultSeverity, string);
    }

    public void setRootErrorMessage(Level level, String string) {
        if (string != null) {
            this.rootErrorMessage = string;
            this.rootErrorSet = true;
            trcLogger.logp(level, this.getClass().getName(), "setRootErrorMessage", "root error message=" + this.rootErrorMessage);
        }
    }

    public String getRootErrorMessage() {
        return this.rootErrorMessage;
    }

    public void setRootErrorSource(Object object) {
        this.setRootErrorSource(defaultSeverity, object);
    }

    public void setRootErrorSource(Level level, Object object) {
        this.rootErrorSource = object;
        trcLogger.logp(level, this.getClass().getName(), "setRootErrorSource", "root error source=" + this.rootErrorSource);
    }

    public Object getRootErrorSource() {
        return this.rootErrorSource;
    }

    public void setRootError(int n, String string, Object object) {
        this.setRootError(defaultSeverity, n, string, object);
    }

    public void setRootError(Level level, int n, String string, Object object) {
        this.setRootErrorCode(level, n);
        this.setRootErrorMessage(level, string);
        this.setRootErrorSource(level, object);
    }

    public String getRootError() {
        return "rootErrorCode=" + this.getRootErrorCode() + ", rootErrorMessage=" + this.getRootErrorMessage() + ", rootErrorSource=" + this.getRootErrorSource();
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getMessage(locale);
    }

    public String getMessage() {
        String string = this.messageKey;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.messageBundle);
            string = resourceBundle.getString(this.messageKey);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && this.messageParams != null) {
            string = MessageFormat.format(string, this.messageParams);
        }
        return string;
    }

    public String getMessage(Locale locale) {
        String string = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.messageBundle, locale);
            String string2 = resourceBundle.getString(this.messageKey);
            string = this.messageParams == null ? string2 : MessageFormat.format(string2, this.messageParams);
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, "WIMException", "getMessage(l)", EMPTY_MSG, exception);
            string = this.getMessage();
        }
        return string;
    }

    private void propagateRootError(Throwable throwable) {
        if (throwable instanceof WIMException) {
            WIMException wIMException = (WIMException)throwable;
            this.setRootError(wIMException.getRootErrorCode(), wIMException.getRootErrorMessage(), wIMException.getRootErrorSource());
        }
    }

    private void logrb2(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        trcLogger.logrb(level, string, string2, string3, string4, objectArray);
        trcLogger.logp(level, string, string2, EMPTY_MSG, this);
    }
}

