/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.ras;

import com.ibm.websphere.wim.util.SDOHelper;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.BasicESequence;

public class WIMTraceHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String DUMMY_VALUE = "****";
    public static final byte[] DUMMY_VALUE_BYTES = "****".getBytes();

    public static String printDataObject(DataObject dataObject) {
        if (dataObject != null) {
            return WIMTraceHelper.printDataGraph(dataObject.getDataGraph());
        }
        return "NULL DATAOBJECT";
    }

    public static String printDataGraph(DataObject dataObject) {
        return WIMTraceHelper.printDataGraph(dataObject.getDataGraph());
    }

    public static String printDataGraph(DataGraph dataGraph) {
        String string = "";
        if (dataGraph != null) {
            Object object;
            DataGraph dataGraph2 = null;
            DataObject dataObject = null;
            DataObject dataObject2 = dataGraph.getRootObject();
            BasicESequence basicESequence = (BasicESequence)dataObject2.get(0);
            if (basicESequence.size() > 0) {
                dataObject = (DataObject)basicESequence.getValue(0);
            }
            if (dataObject != null && !"RootType".equals(dataObject.getType().getName())) {
                dataGraph2 = dataGraph;
            } else if (dataObject.getList("entities").size() > 0) {
                object = SDOHelper.cloneRootDataObject(dataObject);
                ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
                if (changeSummary != null) {
                    boolean bl = false;
                    List list = changeSummary.getChangedDataObjects();
                    if (list.size() > 0) {
                        block4: for (DataObject dataObject3 : list) {
                            for (ChangeSummary.Setting setting : changeSummary.getOldValues(dataObject3)) {
                                Property property = setting.getProperty();
                                Object object2 = setting.getValue();
                                if (!"password".equals(property.getName())) continue;
                                bl = true;
                                object.getDataGraph().getChangeSummary().beginLogging();
                                object.getDataGraph().getChangeSummary().endLogging();
                                continue block4;
                            }
                        }
                    }
                    if (!bl) {
                        object = SDOHelper.deepCloneRootDataObject(dataObject);
                    }
                }
                List list = object.getList("entities");
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject4 = (DataObject)list.get(i);
                    try {
                        if (!dataObject4.isSet("password")) continue;
                        dataObject4.set("password", (Object)DUMMY_VALUE_BYTES);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                dataGraph2 = object.getDataGraph();
            } else {
                dataGraph2 = dataGraph;
            }
            object = new ByteArrayOutputStream();
            try {
                ((EDataGraph)dataGraph2).getDataGraphResource().save((OutputStream)object, null);
            }
            catch (IOException iOException) {
                return iOException.toString();
            }
            string = "\n" + object.toString();
        } else {
            string = "NULL DATAGRAPH";
        }
        return string;
    }

    public static String printObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object != null) {
                if (object instanceof Object[]) {
                    stringBuffer.append(WIMTraceHelper.printObjectArray((Object[])object));
                } else {
                    stringBuffer.append(object);
                }
            } else {
                stringBuffer.append("null");
            }
            if (i == objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String printIntArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            stringBuffer.append(n);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String printShortArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            stringBuffer.append(s);
            if (i == sArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String printIdentifier(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(dataObject.getString("uniqueName")).append("/").append(dataObject.getString("uniqueId")).append(", ");
        stringBuffer.append(dataObject.getString("externalName")).append("/").append(dataObject.getString("externalId")).append(", ");
        stringBuffer.append(dataObject.getString("repositoryId")).append("]");
        return stringBuffer.toString();
    }

    public static String printMapWithoutPassword(Map map) {
        if (map == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (string != null && string.toLowerCase().indexOf("password") >= 0) {
                object = DUMMY_VALUE;
            }
            stringBuffer.append("[" + string + "=" + object + "],");
        }
        return stringBuffer.toString();
    }
}

