/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.security.authz;

import java.io.Serializable;

public class Entitlement
implements Serializable {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String OBJECT_METHOD_CREATE = "CREATE";
    public static final String OBJECT_METHOD_DELETE = "DELETE";
    public static final String OBJECT_METHOD_DELETE_DSC = "DELETE_DESCENDANTS";
    public static final String OBJECT_METHOD_GET = "GET";
    public static final String OBJECT_METHOD_SEARCH = "SEARCH";
    public static final String OBJECT_METHOD_UPDATE = "UPDATE";
    public static final String ATTRIB_METHOD_READ = "READ";
    public static final String ATTRIB_METHOD_WRITE = "WRITE";
    public static final String METHOD_GET_ENTITLEMENTS = "GET_ENTITLEMENTS";
    private String method;
    private String object;
    private String attribute;

    public Entitlement(String string) {
        this(string, "", null);
    }

    public Entitlement(String string, String string2) {
        this(string, string2, null);
    }

    public Entitlement(String string, String string2, String string3) {
        this.method = string;
        this.object = string2;
        this.attribute = string3 == null || string3.length() == 0 ? null : string3;
    }

    public String getMethod() {
        return this.method;
    }

    public String getObject() {
        return this.object;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public boolean isAttributeEntitlement() {
        return this.attribute != null;
    }

    public boolean isObjectMethodAllowed(String string) {
        return this.method.equals(string);
    }

    public boolean isAttributeMethodAllowed(String string, String string2) {
        return this.method.equals(string) && this.attribute != null && this.attribute.equals(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof Entitlement) {
            Entitlement entitlement = (Entitlement)object;
            if (!this.method.equals(entitlement.method) || !this.object.equals(entitlement.object) || !this.isAttributeEntitlement() == entitlement.isAttributeEntitlement()) {
                return false;
            }
            if (this.isAttributeEntitlement()) {
                return this.attribute.equals(entitlement.attribute);
            }
            return this.attribute == entitlement.attribute;
        }
        return false;
    }

    public int hashCode() {
        if (this.isAttributeEntitlement()) {
            return (this.method + "::" + this.object + "::" + this.attribute).hashCode();
        }
        return (this.method + "::" + this.object).hashCode();
    }

    public String toString() {
        if (this.isAttributeEntitlement()) {
            return this.method + "  " + this.object + "  " + this.attribute;
        }
        return this.object.equals("") ? this.method : this.method + "  " + this.object;
    }

    public String toSimpleString() {
        String string = this.object;
        try {
            if (string.indexOf(47) != -1 && (string = string.substring(0, this.object.lastIndexOf(47))).indexOf(47) != -1) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = this.object;
        }
        if (this.isAttributeEntitlement()) {
            return this.method + "  " + string + "  " + this.attribute;
        }
        return string.equals("") ? this.method : this.method + "  " + string;
    }
}

