/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.util;

import com.ibm.websphere.wim.util.UniqueIdGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Routines {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static Locale defaultServerLocale = null;
    private static Hashtable resourceBundleCache = new Hashtable();
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String DEFAULT_COUNTRY = "";
    private static String newline = System.getProperty("line.separator");

    public static ResourceBundle getResourceBundle(String string) {
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = (ResourceBundle)resourceBundleCache.get(string);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        try {
            resourceBundle = ResourceBundle.getBundle(string, Routines.getServerLocale(), Thread.currentThread().getContextClassLoader());
            resourceBundleCache.put(string, resourceBundle);
        }
        catch (Throwable throwable) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public static String getMSG(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Throwable throwable) {
            string2 = null;
        }
        return string2;
    }

    public static String getMSGorKEY(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Throwable throwable) {
            string2 = string;
        }
        return string2;
    }

    public static Locale getServerLocale() {
        if (defaultServerLocale == null) {
            try {
                defaultServerLocale = Locale.getDefault();
            }
            catch (Exception exception) {
                defaultServerLocale = new Locale(DEFAULT_LANGUAGE, DEFAULT_COUNTRY);
            }
        }
        return defaultServerLocale;
    }

    public static String getErrorMessage(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append(newline + "\t\t\t").append(stackTraceElementArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static int getPropertyIntValue(String string, int n) {
        int n2 = n;
        if (string != null) {
            n2 = Integer.parseInt(string);
        }
        return n2;
    }

    public static long getPropertyLongValue(String string, long l) {
        long l2 = l;
        if (string != null) {
            l2 = Long.parseLong(string);
        }
        return l2;
    }

    public static String getUniqueID() {
        return UniqueIdGenerator.newUniqueId();
    }

    public static void enterMethod(Logger logger, String string, String string2, Level level) {
        if (logger.isLoggable(level)) {
            logger.entering(string, string2);
        }
    }

    public static void exitMethod(Logger logger, String string, String string2, Level level) {
        if (logger.isLoggable(level)) {
            logger.exiting(string, string2);
        }
    }

    public static void enterParamsMethod(Logger logger, String string, String string2, Level level, Object[] objectArray) {
        if (logger.isLoggable(level) && objectArray != null) {
            logger.entering(string, string2, objectArray);
        }
    }

    public static void exitResultMethod(Logger logger, String string, String string2, Level level, Object object) {
        if (logger.isLoggable(level)) {
            logger.exiting(string, string2, object);
        }
    }

    public static void logMessage(Logger logger, String string, String string2, Level level, String string3) {
        if (logger.isLoggable(level)) {
            logger.logp(level, string, string2, string3);
        }
    }

    public static void logException(Logger logger, String string, String string2, Level level, String string3, Throwable throwable) {
        if (logger.isLoggable(level)) {
            logger.logp(level, string, string2, string3, throwable);
        }
    }

    public static HashSet convertListToSet(List list) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static byte[] toByteArray(Object object) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public static Object toObject(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static Object[] arrayCopy(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        return objectArray2;
    }

    public static String[] stringArrayCopy(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        return stringArray2;
    }
}

