/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.util;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.util.XSDHelper;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SDOHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static String sdformatMillisec = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static String sdformatSec = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static DataObject rootDO = null;

    private static void createRootDataObjectCache() {
        EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
        DataObject dataObject = eDataGraph.createRootObject("http://www.ibm.com/websphere/wim", "DocumentRoot");
        rootDO = dataObject.createDataObject("Root");
    }

    public static DataObject createRootDataObject() throws WIMException {
        if (rootDO == null) {
            SDOHelper.createRootDataObjectCache();
        }
        try {
            return SDOHelper.cloneRootDataObject(rootDO);
        }
        catch (ClassCastException classCastException) {
            SDOHelper.createRootDataObjectCache();
            return SDOHelper.cloneRootDataObject(rootDO);
        }
    }

    public static DataObject createConfigDataObject(DataObject dataObject, String string, String string2) throws WIMException {
        if (dataObject == null) {
            EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
            DataObject dataObject2 = eDataGraph.createRootObject(string, "DocumentRoot");
            dataObject = dataObject2.createDataObject("configurationProvider");
        }
        return dataObject.createDataObject(string2);
    }

    public static DataObject createConfigProviderDataObject() {
        EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
        DataObject dataObject = eDataGraph.createRootObject("http://www.ibm.com/websphere/wim/config", "DocumentRoot");
        return dataObject.createDataObject("configurationProvider");
    }

    public static DataObject createConfigRepositoryDataObject(DataObject dataObject, String string) {
        return dataObject.createDataObject("repositories", "http://www.ibm.com/websphere/wim/config", string);
    }

    public static DataGraph createDataGraph(String string) {
        final String string2 = string;
        return (EDataGraph)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
                eDataGraph.createRootObject(string2, "DocumentRoot");
                return eDataGraph;
            }
        });
    }

    public static DataObject createEntityDataObject(DataGraph dataGraph, String string, String string2) {
        if (string == null) {
            string = "http://www.ibm.com/websphere/wim";
        }
        return dataGraph.getRootObject().getDataObject("Root").createDataObject("entities", string, string2);
    }

    public static DataObject createEntityDataObject(DataObject dataObject, String string, String string2) {
        if (string == null) {
            string = "http://www.ibm.com/websphere/wim";
        }
        return dataObject.createDataObject("entities", string, string2);
    }

    public static DataObject createControlDataObject(DataGraph dataGraph, String string, String string2) {
        if (string == null) {
            string = "http://www.ibm.com/websphere/wim";
        }
        return dataGraph.getRootObject().getDataObject("Root").createDataObject("controls", string, string2);
    }

    public static DataObject createControlDataObject(DataObject dataObject, String string, String string2) {
        if (string == null) {
            string = "http://www.ibm.com/websphere/wim";
        }
        return dataObject.createDataObject("controls", string, string2);
    }

    public static DataObject createContextDataObject(DataGraph dataGraph, String string, String string2) {
        if (string == null) {
            string = "http://www.ibm.com/websphere/wim";
        }
        return dataGraph.getRootObject().getDataObject("Root").createDataObject("contexts", string, string2);
    }

    public static DataObject createContextDataObject(DataObject dataObject, String string, String string2) {
        if (string == null) {
            string = "http://www.ibm.com/websphere/wim";
        }
        return dataObject.createDataObject("contexts", string, string2);
    }

    public static DataObject createDataObject(String string, String string2) {
        EClass eClass = XSDHelper.getClass(string, string2);
        if (eClass != null) {
            EObject eObject = EcoreUtil.create((EClass)eClass);
            return (DataObject)eObject;
        }
        return null;
    }

    public static String getDateString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdformatMillisec);
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.format(date));
        stringBuffer.insert(stringBuffer.length() - 2, ":");
        return stringBuffer.toString();
    }

    public static Date getDateFromString(String string) throws WIMException {
        try {
            string = string.replaceFirst("Z", "-0000");
            if (string.indexOf(".") != -1) {
                return new SimpleDateFormat(sdformatMillisec).parse(string);
            }
            return new SimpleDateFormat(sdformatSec).parse(string);
        }
        catch (ParseException parseException) {
            throw new WIMException(parseException);
        }
    }

    public static DataObject cloneDataObject(DataObject dataObject) {
        DataObject dataObject2 = null;
        if (dataObject != null) {
            dataObject2 = (DataObject)SDOHelper.cloneEObject((EObject)dataObject);
        }
        return dataObject2;
    }

    public static DataObject cloneRootDataObject(DataObject dataObject) {
        DataGraph dataGraph = SDOHelper.createDataGraph("http://www.ibm.com/websphere/wim");
        DataObject dataObject2 = SDOHelper.cloneDataObject(dataObject);
        dataGraph.getRootObject().setDataObject("Root", dataObject2);
        return dataObject2;
    }

    public static EObject cloneEObject(EObject eObject) {
        EObject eObject2 = null;
        if (eObject != null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            eObject2 = copier.copy(eObject);
            copier.copyReferences();
        }
        return eObject2;
    }

    public static final DataObject deepCloneRootDataObject(DataObject dataObject) {
        DataObject dataObject2;
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        if (changeSummary != null && changeSummary.getChangedDataObjects().size() > 0) {
            dataObject2 = SDOHelper.cloneRootDataObject(dataObject);
            EDataGraph eDataGraph = (EDataGraph)SDOHelper.deepCopyObject(changeSummary.getDataGraph());
            ((EDataGraph)dataObject2.getDataGraph()).setEChangeSummary(eDataGraph.getEChangeSummary());
        } else {
            dataObject2 = SDOHelper.cloneRootDataObject(dataObject);
        }
        return dataObject2;
    }

    /*
     * Exception decompiling
     */
    public static final Object deepCopyObject(Object var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

