/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.util;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.Diagnostician;

public class SDOUtils {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = SDOUtils.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static void validateDataObject(DataObject dataObject) throws WIMException {
        Diagnostician diagnostician = Diagnostician.INSTANCE;
        Diagnostic diagnostic = diagnostician.validate((EObject)((EDataObject)dataObject));
        StringBuffer stringBuffer = new StringBuffer();
        SDOUtils.checkDataGraphDiagnostic(diagnostic, stringBuffer);
    }

    public static void validateDataGraph(DataGraph dataGraph) throws WIMException {
        Diagnostician diagnostician = Diagnostician.INSTANCE;
        Diagnostic diagnostic = diagnostician.validate(((EDataGraph)dataGraph).getERootObject());
        StringBuffer stringBuffer = new StringBuffer();
        SDOUtils.checkDataGraphDiagnostic(diagnostic, stringBuffer);
    }

    public static void printDataGraphXML(String string, DataGraph dataGraph) {
        try {
            if (string != null) {
                SDOUtils.printOut(string);
            }
            ((EDataGraph)dataGraph).getDataGraphResource().save((OutputStream)System.out, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printDataGraph(String string, DataGraph dataGraph) {
        if (string != null) {
            SDOUtils.printOut(string);
        }
        System.out.print(WIMTraceHelper.printDataGraph(dataGraph));
        SDOUtils.printOut("");
    }

    public static void printDataGraph(String string, DataObject dataObject) {
        if (dataObject != null) {
            SDOUtils.printDataGraph(string, dataObject.getDataGraph());
        } else {
            System.out.println("NULL DATAOBJECT");
        }
    }

    public static String getDataGraphAsString(DataObject dataObject) {
        return WIMTraceHelper.printDataGraph(dataObject);
    }

    public static void printDataObject(String string, int n, EDataObject eDataObject) {
        try {
            int n2;
            List list;
            String string2;
            EStructuralFeature eStructuralFeature;
            int n3;
            if (string != null) {
                SDOUtils.printOut(string);
            }
            if (eDataObject == null) {
                return;
            }
            SDOUtils.printOut(SDOUtils.getBars(n, true) + eDataObject.eClass().getName());
            List list2 = eDataObject.getInstanceProperties();
            for (n3 = 0; n3 < list2.size(); ++n3) {
                eStructuralFeature = (EStructuralFeature)list2.get(n3);
                string2 = eStructuralFeature.getName();
                if (!(eStructuralFeature instanceof EAttribute)) continue;
                if (eStructuralFeature.isMany()) {
                    list = eDataObject.getList(string2);
                    if (list == null) continue;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        if (list.get(n2) == null) continue;
                        SDOUtils.printOut(SDOUtils.getBars(n, false) + string2 + "=" + list.get(n2));
                    }
                    continue;
                }
                if (eDataObject.get(string2) == null) continue;
                SDOUtils.printOut(SDOUtils.getBars(n, false) + string2 + "=" + eDataObject.get(string2));
            }
            for (n3 = 0; n3 < list2.size(); ++n3) {
                eStructuralFeature = (EStructuralFeature)list2.get(n3);
                string2 = eStructuralFeature.getName();
                if (!(eStructuralFeature instanceof EReference)) continue;
                if (eStructuralFeature.isMany()) {
                    list = eDataObject.getList(string2);
                    if (list == null) continue;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        SDOUtils.printDataObject(null, n + 1, (EDataObject)list.get(n2));
                    }
                    continue;
                }
                SDOUtils.printDataObject(null, n + 1, (EDataObject)eDataObject.get(string2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void printOut(String string) {
        System.out.println(string);
    }

    private static String getBars(int n, boolean bl) {
        if (n == 0) {
            return "|-";
        }
        StringBuffer stringBuffer = new StringBuffer("|");
        for (int i = 1; i < n * 2; ++i) {
            if (i % 2 == 0) {
                stringBuffer.append("|");
                continue;
            }
            stringBuffer.append(" ");
        }
        if (bl) {
            return stringBuffer.append("|-").toString();
        }
        return stringBuffer.append("|  ").toString();
    }

    private static void checkDataGraphDiagnostic(Diagnostic diagnostic, StringBuffer stringBuffer) throws WIMException {
        List list = diagnostic.getChildren();
        int n = diagnostic.getSeverity();
        int n2 = diagnostic.getCode();
        List list2 = diagnostic.getData();
        if (n == 4) {
            for (int i = 0; i < list2.size(); ++i) {
                Object e2 = list2.get(i);
            }
            throw new WIMApplicationException(diagnostic.toString(), Level.FINE, CLASSNAME, "checkDataGraphDiagnostic");
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SDOUtils.checkDataGraphDiagnostic((Diagnostic)list.get(i), stringBuffer);
            }
        }
    }
}

