/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wim.util;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;

public class XML2SDOService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private Map options;

    public XML2SDOService() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    private Map getOptions() {
        if (this.options == null) {
            this.options = new HashMap();
            this.options.put("EXTENDED_META_DATA", Boolean.TRUE);
            this.options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        return this.options;
    }

    private EDataGraph createDataGraph() {
        EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
        return eDataGraph;
    }

    public DataObject load(InputStream inputStream) throws IOException {
        EDataGraph eDataGraph = this.createDataGraph();
        Resource resource = eDataGraph.getRootResource();
        resource.unload();
        resource.load(inputStream, this.getOptions());
        EDataObject eDataObject = null;
        if (!resource.getContents().isEmpty()) {
            eDataObject = (EDataObject)resource.getContents().get(0);
            eDataGraph.setERootObject((EObject)eDataObject);
        }
        return eDataObject;
    }

    public DataGraph loadDataGraph(InputStream inputStream) throws IOException {
        EDataGraph eDataGraph = this.createDataGraph();
        Resource resource = eDataGraph.getDataGraphResource();
        resource.unload();
        resource.load(inputStream, this.getOptions());
        EDataGraph eDataGraph2 = null;
        if (!resource.getContents().isEmpty()) {
            eDataGraph2 = (EDataGraph)resource.getContents().get(0);
        }
        return eDataGraph2;
    }
}

