/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.ConfigurationProperty;
import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionClassLoader;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.ExtensionRegistryFactory;
import com.ibm.wkplc.extensionregistry.OffloadablePluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.ResourceHelper;
import com.ibm.wkplc.extensionregistry.Status;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationElement
extends OffloadablePluginModelObject
implements IConfigurationElement,
Serializable {
    private static final Logger s_logger = LoggerFactory.getLogger(ConfigurationElement.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String DOM_TAG_NAME = "config-element";
    private ConfigurationProperty[] _properties;
    private Object _parent;
    private String _value;
    private ConfigurationElement[] _subElements;
    private transient ExtensionRegistryFactory _registryFactory = null;
    private final String NULL = "null";

    public ConfigurationElement() {
        this.locateRegistryFactory();
    }

    private void locateRegistryFactory() {
        if (this._registryFactory == null) {
            this._registryFactory = ExtensionRegistryFactory.INSTANCE;
        }
    }

    public Object createExecutableExtension(String string) throws CoreException {
        Object object;
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "createExecutableExtension", new Object[]{string});
        }
        Object object2 = this.getClassNameToLoad(string);
        Object object3 = null;
        if (object2 != null) {
            object = object2;
            int n = object2.indexOf(58);
            if (n != -1) {
                object3 = object2.substring(n + 1);
                object2 = object2.substring(0, n).trim();
            }
        } else {
            object = this.getChildren();
            if (object != null && 0 < ((IConfigurationElement[])object).length) {
                IConfigurationElement iConfigurationElement = object[0];
                object2 = iConfigurationElement.getAttribute("class");
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("parameter");
                object3 = new Hashtable(iConfigurationElementArray.length);
                for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                    String string2 = iConfigurationElementArray[i].getAttribute("name");
                    String string3 = iConfigurationElementArray[i].getAttribute("value");
                    if (string2 == null || 0 >= string2.length()) continue;
                    ((Hashtable)object3).put(string2, string3);
                }
            }
        }
        if (object2 == null || object2.length() == 0) {
            throw new CoreException(this.getIStatusObject(string, ResourceHelper.getString("err.no_exe_spec_found_1", new Object[]{string}), new IllegalArgumentException("propertyName")));
        }
        object = this.getExecutable((String)object2);
        if (object != null) {
            if (object instanceof IExecutableExtension) {
                ((IExecutableExtension)object).setInitializationData((IConfigurationElement)this, string, object3);
            }
            if (object instanceof IExecutableExtensionFactory) {
                object = ((IExecutableExtensionFactory)object).create();
            }
        } else if (s_logger.isErrorEnabled()) {
            s_logger.error("err.class_load_failure_1", "Request", new Object[]{object2});
        }
        if (object == null) {
            throw new CoreException(this.getIStatusObject((String)object2, ResourceHelper.getString("err.failed_to_load_pojo_1", new Object[]{object2}), new RuntimeException()));
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "createExecutableExtension", object);
        }
        return object;
    }

    private Object getExecutable(String string) throws CoreException {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getExecutable", new Object[]{string});
        }
        Object var2_2 = null;
        boolean bl = true;
        Vector<ClassLoader> vector = this.getExtensionClassLoaders();
        if (vector == null || vector.isEmpty()) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Warning! falling back to ExtensionRegistry's ClassLoader: " + this.getDeclaringExtension().toString());
            }
            vector = new Vector<ClassLoader>();
            vector.add(this.getClass().getClassLoader());
            bl = false;
        }
        if (vector != null && !vector.isEmpty()) {
            final Vector<ClassLoader> vector2 = vector;
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Creating classLoader with doPrivileged.");
            }
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ExtensionClassLoader(vector2, ConfigurationElement.this.getClassLoadersForTheExtensionPoint());
                }
            });
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    try {
                        classLoader = this.getClass().getClassLoader();
                        clazz = classLoader.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        this.pojoLoadError(string, classNotFoundException2, "2");
                    }
                }
                this.pojoLoadError(string, classNotFoundException, "1");
            }
            if (clazz != null) {
                try {
                    var2_2 = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    this.pojoLoadError(string, instantiationException, "3");
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.pojoLoadError(string, illegalAccessException, "4");
                }
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getExecutable", var2_2);
        }
        return var2_2;
    }

    private void pojoLoadError(String string, Throwable throwable, String string2) throws CoreException {
        FFDCFilter.processException(throwable, this.getClass().toString() + ".getExecutable", string2);
        throw new CoreException(this.getIStatusObject(string, ResourceHelper.getString("err.failed_to_load_pojo_1", new Object[]{string}), throwable));
    }

    public String getAttribute(String string) {
        String string2 = this.getAttributeAsIs(string);
        return this.translate(string2, this.getMyPluginDescriptor(), s_logger);
    }

    public String getAttributeAsIs(String string) {
        ConfigurationProperty[] configurationPropertyArray = this.getProperties();
        if (configurationPropertyArray == null) {
            return null;
        }
        for (int i = 0; i < configurationPropertyArray.length; ++i) {
            if (!string.equals(configurationPropertyArray[i].getName())) continue;
            return configurationPropertyArray[i].getValue();
        }
        return null;
    }

    public String[] getAttributeNames() {
        ConfigurationProperty[] configurationPropertyArray = this.getProperties();
        if (configurationPropertyArray == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[configurationPropertyArray.length];
        for (int i = 0; i < configurationPropertyArray.length; ++i) {
            stringArray[i] = configurationPropertyArray[i].getName();
        }
        return stringArray;
    }

    public IConfigurationElement[] getChildren() {
        IConfigurationElement[] iConfigurationElementArray = this.getSubElements();
        return iConfigurationElementArray != null ? iConfigurationElementArray : Constants.EMPTY_CONFIGELEM_ARRAY;
    }

    public IConfigurationElement[] getChildren(String string) {
        ConfigurationElement[] configurationElementArray = this.getSubElements();
        if (configurationElementArray == null) {
            return Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        ArrayList<ConfigurationElement> arrayList = new ArrayList<ConfigurationElement>();
        for (int i = 0; i < configurationElementArray.length; ++i) {
            ConfigurationElement configurationElement = configurationElementArray[i];
            if (!string.equals(configurationElement.getName())) continue;
            arrayList.add(configurationElementArray[i]);
        }
        return arrayList.toArray(new IConfigurationElement[arrayList.size()]);
    }

    public IExtension getDeclaringExtension() {
        Object object = this.getParent();
        if (object instanceof Extension) {
            return (IExtension)object;
        }
        while (object != null && object instanceof ConfigurationElement) {
            object = ((ConfigurationElement)object).getParent();
        }
        return (IExtension)object;
    }

    public Object getParent() {
        return this._parent;
    }

    public String getValue() {
        return this.translate(this._value, this.getMyPluginDescriptor(), s_logger);
    }

    public String getValueAsIs() {
        return this._value;
    }

    public String getNamespace() throws InvalidRegistryObjectException {
        return this.getDeclaringExtension().getNamespace();
    }

    public boolean isValid() {
        return true;
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return null;
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.getDeclaringExtension().getNamespace();
    }

    private String getClassNameToLoad(String string) {
        String string2;
        String string3 = string2 = string != null ? this.getAttribute(string) : this.getValue();
        if (string2 != null) {
            return 0 < (string2 = string2.trim()).length() ? string2 : null;
        }
        return null;
    }

    private Vector getExtensionClassLoaders() {
        Stack stack = null;
        IPluginDescriptor iPluginDescriptor = this.getMyPluginDescriptor();
        if (iPluginDescriptor != null) {
            if (iPluginDescriptor instanceof PluginDescriptor) {
                stack = ((PluginDescriptor)iPluginDescriptor).getPluginClassLoaders();
            } else if (iPluginDescriptor instanceof PluginDescriptorProxy) {
                stack = ((PluginDescriptorProxy)iPluginDescriptor).getPluginClassLoaders();
            }
        }
        return stack;
    }

    private ConfigurationProperty[] getProperties() {
        return this._properties;
    }

    ConfigurationElement[] getSubElements() {
        return this._subElements;
    }

    void setParent(Object object) {
        if (object instanceof Extension) {
            Extension extension2 = (Extension)object;
            try {
                String string = extension2.getUniqueIdentifier();
                this._parent = RegistryCache.INSTANCE.getExtensionProxy(string, extension2.getVersion());
            }
            catch (NullPointerException nullPointerException) {
                this._parent = extension2;
            }
        } else {
            this._parent = object;
        }
    }

    void setParentAsIs(Object object) {
        this._parent = object;
    }

    void setProperties(ConfigurationProperty[] configurationPropertyArray) {
        this._properties = configurationPropertyArray;
    }

    void setSubElements(ConfigurationElement[] configurationElementArray) {
        this._subElements = configurationElementArray;
    }

    void setValue(String string) {
        this._value = string;
    }

    private Vector getClassLoadersForTheExtensionPoint() {
        PluginDescriptorProxy pluginDescriptorProxy;
        this.locateRegistryFactory();
        ExtensionRegistry extensionRegistry = this._registryFactory.getGlobalExtensionRegistry();
        IExtensionPoint iExtensionPoint = extensionRegistry.getExtensionPoint(this.getDeclaringExtension().getExtensionPointUniqueIdentifier());
        if (iExtensionPoint != null && (pluginDescriptorProxy = extensionRegistry.getPlugin(iExtensionPoint.getNamespace())) != null) {
            return pluginDescriptorProxy.getPluginClassLoaders();
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInputStream.readInt();
        if (n2 == 0) {
            String string = objectInputStream.readUTF();
            String string2 = objectInputStream.readUTF();
            this._parent = RegistryCache.INSTANCE.getExtensionProxy(string, string2);
        } else {
            this._parent = objectInputStream.readObject();
        }
        this._value = objectInputStream.readUTF();
        int n3 = objectInputStream.readInt();
        if (0 < n3) {
            this._properties = new ConfigurationProperty[n3];
            for (int i = 0; i < n3; ++i) {
                this._properties[i] = (ConfigurationProperty)objectInputStream.readObject();
            }
        } else {
            this._properties = null;
        }
        if (0 < (n = objectInputStream.readInt())) {
            this._subElements = new ConfigurationElement[n];
            for (int i = 0; i < n; ++i) {
                this._subElements[i] = (ConfigurationElement)objectInputStream.readObject();
            }
        } else {
            this._subElements = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        if (this._parent != null) {
            IExtension iExtension;
            if (this._parent instanceof ExtensionProxy) {
                objectOutputStream.writeInt(0);
                iExtension = (ExtensionProxy)this._parent;
                objectOutputStream.writeUTF(iExtension.getUniqueIdentifier());
                objectOutputStream.writeUTF(iExtension.getVersion());
            } else if (this._parent instanceof Extension) {
                objectOutputStream.writeInt(0);
                iExtension = (Extension)this._parent;
                objectOutputStream.writeUTF(iExtension.getUniqueIdentifier());
                objectOutputStream.writeUTF(iExtension.getVersion());
            } else {
                objectOutputStream.writeInt(1);
                objectOutputStream.writeObject(this._parent);
            }
        } else {
            objectOutputStream.writeUTF("null");
        }
        objectOutputStream.writeUTF(this._value != null ? this._value : "null");
        if (this._properties != null) {
            int n2 = this._properties.length;
            objectOutputStream.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                objectOutputStream.writeObject(this._properties[n]);
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        if (this._subElements != null) {
            int n3 = this._subElements.length;
            objectOutputStream.writeInt(n3);
            for (n = 0; n < n3; ++n) {
                objectOutputStream.writeObject(this._subElements[n]);
            }
        } else {
            objectOutputStream.writeInt(0);
        }
    }

    public String getRootElementName() {
        return DOM_TAG_NAME;
    }

    public void initFromDom(Element element) {
        Object object;
        Node node;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        super.initFromDom(element);
        NodeList nodeList = element.getElementsByTagName("parent");
        Node node2 = nodeList.item(0);
        if (node2 != null && node2.hasAttributes() && (object5 = (object4 = node2.getAttributes()).getNamedItem("type")) != null) {
            object3 = object5.getNodeValue();
            if (((String)object3).equals("extension")) {
                object2 = object4.getNamedItem("id");
                node = object4.getNamedItem("version");
                if (object2 != null && node != null) {
                    this._parent = RegistryCache.INSTANCE.getExtensionProxy(object2.getNodeValue(), node.getNodeValue());
                }
            } else {
                this._parent = null;
            }
        }
        this._value = this.readTextFromDomElement(element, "value");
        nodeList = element.getElementsByTagName("configuration-properties");
        object4 = nodeList.item(0);
        if (object4 != null && object4.hasChildNodes()) {
            object5 = object4.getChildNodes();
            object3 = new ArrayList();
            for (int i = 0; i < object5.getLength(); ++i) {
                node = object5.item(i);
                if (!node.getNodeName().equals("config-property")) continue;
                object = new ConfigurationProperty();
                ((ConfigurationProperty)object).initFromDom((Element)node);
                object3.add(object);
            }
            this._properties = object3.toArray(new ConfigurationProperty[object3.size()]);
        }
        if ((object5 = (nodeList = element.getElementsByTagName("sub-elements")).item(0)) != null && object5.hasChildNodes()) {
            object3 = object5.getChildNodes();
            object2 = new ArrayList();
            for (int i = 0; i < object3.getLength(); ++i) {
                object = object3.item(i);
                if (!object.getNodeName().equals(DOM_TAG_NAME)) continue;
                ConfigurationElement configurationElement = new ConfigurationElement();
                configurationElement.initFromDom((Element)object);
                configurationElement.setParent(this);
                object2.add(configurationElement);
            }
            this._subElements = object2.toArray(new ConfigurationElement[object2.size()]);
        }
    }

    public void toXml(Element element) {
        Element element2;
        super.toXml(element);
        Document document = element.getOwnerDocument();
        if (this._parent != null) {
            Serializable serializable;
            element2 = null;
            if (this._parent instanceof ExtensionProxy) {
                serializable = (ExtensionProxy)this._parent;
                element2 = this.getDomElementForProxy(document, "parent", ((RegistryObjectProxy)serializable).getUniqueIdentifier(), ((RegistryObjectProxy)serializable).getVersion());
                element2.setAttribute("type", "extension");
            } else if (this._parent instanceof Extension) {
                serializable = (Extension)this._parent;
                element2 = this.getDomElementForProxy(document, "parent", ((Extension)serializable).getUniqueIdentifier(), ((OffloadablePluginModelObject)serializable).getVersion());
                element2.setAttribute("type", "extension");
            } else if (this._parent instanceof ConfigurationElement) {
                serializable = (ConfigurationElement)this._parent;
                element2 = document.createElement("parent");
                element2.setAttribute("type", DOM_TAG_NAME);
            }
            element.appendChild(element2);
        }
        element.appendChild(this.getDomElementForText(document, "value", this._value));
        element2 = document.createElement("configuration-properties");
        if (this._properties != null) {
            for (int i = 0; i < this._properties.length; ++i) {
                Element element3 = document.createElement("config-property");
                this._properties[i].toXml(element3);
                element2.appendChild(element3);
            }
        }
        element.appendChild(element2);
        Element element4 = document.createElement("sub-elements");
        if (this._subElements != null) {
            for (int i = 0; i < this._subElements.length; ++i) {
                Element element5 = document.createElement(DOM_TAG_NAME);
                this._subElements[i].toXml(element5);
                element4.appendChild(element5);
            }
        }
        element.appendChild(element4);
    }

    private IStatus getIStatusObject(String string, String string2, Throwable throwable) {
        Status status = new Status(string, 4, 4, string2);
        if (throwable != null) {
            status.setException(throwable);
        }
        return status;
    }

    private IPluginDescriptor getMyPluginDescriptor() {
        IPluginDescriptor iPluginDescriptor = null;
        IExtension iExtension = this.getDeclaringExtension();
        if (iExtension != null && iExtension instanceof Extension) {
            iPluginDescriptor = ((Extension)iExtension).getDeclaringPluginDescriptor();
        } else if (iExtension != null && iExtension instanceof ExtensionProxy) {
            iPluginDescriptor = ((ExtensionProxy)iExtension).getDeclaringPluginDescriptor();
        }
        return iPluginDescriptor;
    }
}

