/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.ResourceHelper;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.PluginVersionIdentifier;

class DumpHelper {
    private final String SEPARATOR = "\n==============================================================================\n";
    private final String INDENT1 = "\n   ";
    private final String INDENT2 = "      ";
    private final String INDENT3 = "         ";
    private final String INDENT4 = "            ";
    private final String INDENT5 = "               ";
    private ResourceBundle _rb = ResourceHelper.getDumpResourceBundle();
    private StringBuffer _buf = new StringBuffer();

    DumpHelper() {
    }

    void addHeader() {
        this._buf.append("\n==============================================================================\n");
        this._buf.append(this._rb.getString("tool.dump.begin"));
        this._buf.append("\n==============================================================================\n");
    }

    void addFooter() {
        this._buf.append("\n==============================================================================\n");
        this._buf.append(this._rb.getString("tool.dump.end"));
        this._buf.append("\n==============================================================================\n");
    }

    void addPlugin(PluginDescriptorProxy pluginDescriptorProxy) {
        this._buf.append("\n   " + this._rb.getString("tool.dump.plugin") + ": " + pluginDescriptorProxy.getUniqueIdentifier() + this.formatVersion(pluginDescriptorProxy.getVersion()) + this.formatResolved(pluginDescriptorProxy.isResolved()) + "\n");
        String string = pluginDescriptorProxy.getLabel();
        this._buf.append("      " + this._rb.getString("tool.dump.name") + ": " + (string != null ? string : "") + "\n");
        String string2 = pluginDescriptorProxy.getProviderName();
        if (string2 != null && 0 < string2.length()) {
            this._buf.append("      " + this._rb.getString("tool.dump.provider") + ": " + string2 + "\n");
        }
        this._buf.append("      " + this._rb.getString("tool.dump.location") + ": " + pluginDescriptorProxy.getInstallURL() + "\n");
        IPluginPrerequisite[] iPluginPrerequisiteArray = pluginDescriptorProxy.getPluginPrerequisites();
        for (int i = 0; iPluginPrerequisiteArray != null && i < iPluginPrerequisiteArray.length; ++i) {
            PluginVersionIdentifier pluginVersionIdentifier = iPluginPrerequisiteArray[i].getVersionIdentifier();
            this._buf.append("      " + this._rb.getString("tool.dump.requires") + ": " + iPluginPrerequisiteArray[i].getUniqueIdentifier() + (pluginVersionIdentifier != null ? this.formatVersion(pluginVersionIdentifier.toString()) : "") + "\n");
        }
    }

    void addExtensions(ExtensionProxy[] extensionProxyArray) {
        this._buf.append("      " + ResourceHelper.getString(this._rb, "tool.dump.x.extensions", new Object[]{Integer.toString(extensionProxyArray.length)}) + "\n");
        TreeMap<String, ExtensionProxy> treeMap = new TreeMap<String, ExtensionProxy>();
        for (int i = 0; i < extensionProxyArray.length; ++i) {
            treeMap.put(extensionProxyArray[i].getSimpleIdentifier(), extensionProxyArray[i]);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            ExtensionProxy extensionProxy = (ExtensionProxy)treeMap.get(iterator.next());
            this._buf.append("         " + this._rb.getString("tool.dump.extension") + ": " + extensionProxy.getSimpleIdentifier() + this.formatResolved(extensionProxy.isResolved()) + "\n");
            String string = extensionProxy.getLabel();
            if (string != null && 0 < string.length()) {
                this._buf.append("            " + this._rb.getString("tool.dump.name") + ": " + string + "\n");
            }
            this._buf.append("            " + this._rb.getString("tool.dump.for.extensionpoint") + ": " + extensionProxy.getExtensionPointUniqueIdentifier() + "\n");
        }
    }

    void addNoExtensionsInPlugin() {
        this._buf.append("      " + this._rb.getString("tool.dump.no.extensions.defined") + "\n");
    }

    void addExtensionPoints(IExtensionPointProxy[] iExtensionPointProxyArray) {
        this._buf.append("      " + ResourceHelper.getString(this._rb, "tool.dump.x.extensionpoints", new Object[]{Integer.toString(iExtensionPointProxyArray.length)}) + "\n");
        TreeMap<String, IExtensionPointProxy> treeMap = new TreeMap<String, IExtensionPointProxy>();
        for (int i = 0; i < iExtensionPointProxyArray.length; ++i) {
            treeMap.put(iExtensionPointProxyArray[i].getSimpleIdentifier(), iExtensionPointProxyArray[i]);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            IExtensionPointProxy iExtensionPointProxy = (IExtensionPointProxy)treeMap.get(iterator.next());
            this._buf.append("         " + this._rb.getString("tool.dump.extensionpoint") + ": " + iExtensionPointProxy.getSimpleIdentifier() + this.formatResolved(iExtensionPointProxy.isResolved()) + "\n");
            String string = iExtensionPointProxy.getLabel();
            this._buf.append("            " + this._rb.getString("tool.dump.name") + ": " + (string != null ? string : "") + "\n");
            this._buf.append("            " + this._rb.getString("tool.dump.schema") + ": " + iExtensionPointProxy.getSchemaReference() + "\n");
            IExtension[] iExtensionArray = iExtensionPointProxy.getExtensions();
            if (0 < iExtensionArray.length) {
                this._buf.append("            " + ResourceHelper.getString(this._rb, "tool.dump.x.extensions.attached", new Object[]{Integer.toString(iExtensionArray.length)}) + "\n");
                TreeMap<String, IExtension> treeMap2 = new TreeMap<String, IExtension>();
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    treeMap2.put(iExtensionArray[i].getUniqueIdentifier(), iExtensionArray[i]);
                }
                Iterator iterator2 = treeMap2.keySet().iterator();
                while (iterator2.hasNext()) {
                    ExtensionProxy extensionProxy = (ExtensionProxy)treeMap2.get(iterator2.next());
                    IPluginDescriptor iPluginDescriptor = extensionProxy.getDeclaringPluginDescriptor();
                    String string2 = iPluginDescriptor != null ? iPluginDescriptor.getVersionIdentifier().toString() : "";
                    this._buf.append("               " + extensionProxy.getUniqueIdentifier() + this.formatVersion(string2) + "\n");
                }
                continue;
            }
            this._buf.append("            " + this._rb.getString("tool.dump.no.extensions.attached") + "\n");
        }
    }

    void addNoExtensionPointsInPlugin() {
        this._buf.append("      " + this._rb.getString("tool.dump.no.extensionpoints.defined") + "\n");
    }

    String getResult() {
        return this._buf.toString();
    }

    private String formatVersion(String string) {
        return " [" + string + "]";
    }

    private String formatResolved(boolean bl) {
        return " (" + this._rb.getString(bl ? "tool.dump.resolved" : "tool.dump.unresolved") + ")";
    }
}

