/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.ConfigurationElement;
import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.OffloadablePluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extension
extends OffloadablePluginModelObject
implements IExtension,
Serializable {
    private static final Logger s_logger = LoggerFactory.getLogger(Extension.class);
    public static final String DOM_TAG_NAME = "extension";
    private IPluginDescriptor _parentDescriptor;
    private String _simpleId = null;
    private String _extensionPointUniqueId = null;
    private ConfigurationElement[] _elements;

    public IConfigurationElement[] getConfigurationElements() {
        IConfigurationElement[] iConfigurationElementArray = this.getElements();
        if (iConfigurationElementArray == null) {
            return Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        return iConfigurationElementArray;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return this._parentDescriptor;
    }

    public String getNamespace() {
        return this._parentDescriptor.getUniqueIdentifier();
    }

    public String getExtensionPointUniqueIdentifier() {
        return this._extensionPointUniqueId;
    }

    public String getLabel() {
        return this.getLabel(this.getDeclaringPluginDescriptor(), s_logger);
    }

    public String getSimpleIdentifier() {
        return this._simpleId;
    }

    public String getUniqueIdentifier() {
        String string = this.getSimpleIdentifier();
        if (string == null) {
            return null;
        }
        return this.getDeclaringPluginDescriptor().getUniqueIdentifier() + "." + string;
    }

    public boolean isValid() {
        return true;
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.getDeclaringPluginDescriptor().getUniqueIdentifier();
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return null;
    }

    ConfigurationElement[] getElements() {
        return this._elements;
    }

    void setElements(ConfigurationElement[] configurationElementArray) {
        this._elements = configurationElementArray;
        this.setDirty(true);
    }

    void setExtensionPointUniqueId(String string) {
        this._extensionPointUniqueId = string;
        this.setDirty(true);
    }

    void setParentDescriptor(PluginDescriptor pluginDescriptor) {
        this._parentDescriptor = RegistryCache.INSTANCE.getPluginDescriptorProxy(pluginDescriptor.getUniqueIdentifier(), pluginDescriptor.getVersion());
        this.setVersion(pluginDescriptor.getVersion());
        this.setDirty(true);
    }

    void setParentDescriptorAsIs(PluginDescriptor pluginDescriptor) {
        this._parentDescriptor = pluginDescriptor;
        this.setVersion(pluginDescriptor.getVersion());
    }

    void setSimpleId(String string) {
        this._simpleId = string;
        this.setDirty(true);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Extension) {
            Extension extension2 = (Extension)object;
            if ((this._parentDescriptor == null || this._parentDescriptor.equals(extension2.getDeclaringPluginDescriptor())) && (this._parentDescriptor != null || extension2.getDeclaringPluginDescriptor() == null) && this._simpleId.equals(extension2.getSimpleIdentifier()) && this._extensionPointUniqueId.equals(extension2.getExtensionPointUniqueIdentifier())) {
                ConfigurationElement[] configurationElementArray = extension2.getElements();
                if (!(this._elements != null ? configurationElementArray == null || this._elements.length != configurationElementArray.length : configurationElementArray != null && 0 < configurationElementArray.length)) {
                    int n;
                    for (n = 0; n < this._elements.length && this._elements[n].equals(configurationElementArray[n]); ++n) {
                    }
                    if (n >= this._elements.length) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        this._parentDescriptor = RegistryCache.INSTANCE.getPluginDescriptorProxy(string, string2);
        String string3 = objectInputStream.readUTF();
        this._simpleId = string3.equals("null") ? null : string3;
        string3 = objectInputStream.readUTF();
        this._extensionPointUniqueId = string3.equals("null") ? null : string3;
        int n = objectInputStream.readInt();
        this._elements = new ConfigurationElement[n];
        for (int i = 0; i < n; ++i) {
            this._elements[i] = (ConfigurationElement)objectInputStream.readObject();
        }
        this.setDirty(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this._parentDescriptor != null) {
            String string = this._parentDescriptor.getUniqueIdentifier();
            objectOutputStream.writeUTF(string != null ? string : "null");
            String string2 = this._parentDescriptor.getVersionIdentifier().toString();
            objectOutputStream.writeUTF(string2 != null ? string2 : "null");
        } else {
            objectOutputStream.writeUTF("null");
            objectOutputStream.writeUTF("null");
        }
        objectOutputStream.writeUTF(this._simpleId != null ? this._simpleId : "null");
        objectOutputStream.writeUTF(this._extensionPointUniqueId != null ? this._extensionPointUniqueId : "null");
        if (this._elements != null) {
            int n = this._elements.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeObject(this._elements[i]);
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        this.setDirty(false);
    }

    public String getRootElementName() {
        return DOM_TAG_NAME;
    }

    public void initFromDom(Element element) {
        Object object;
        Object object2;
        Object object3;
        super.initFromDom(element);
        NodeList nodeList = element.getElementsByTagName("plugin-descriptor");
        Node node = nodeList.item(0);
        if (node != null && node.hasAttributes()) {
            object3 = node.getAttributes();
            object2 = object3.getNamedItem("id");
            object = object3.getNamedItem("version");
            if (object2 != null && object != null) {
                this._parentDescriptor = RegistryCache.INSTANCE.getPluginDescriptorProxy(object2.getNodeValue(), object.getNodeValue());
            }
        }
        this._simpleId = this.readTextFromDomElement(element, "simple-id");
        this._extensionPointUniqueId = this.readTextFromDomElement(element, "extension-point-id");
        nodeList = element.getElementsByTagName("configuration-elements");
        object3 = nodeList.item(0);
        if (object3 != null && object3.hasChildNodes()) {
            object2 = object3.getChildNodes();
            object = new ArrayList();
            for (int i = 0; i < object2.getLength(); ++i) {
                Node node2 = object2.item(i);
                if (!node2.getNodeName().equals("config-element")) continue;
                ConfigurationElement configurationElement = new ConfigurationElement();
                configurationElement.initFromDom((Element)node2);
                configurationElement.setParent(this);
                object.add(configurationElement);
            }
            this._elements = object.toArray(new ConfigurationElement[object.size()]);
        }
    }

    public void toXml(Element element) {
        super.toXml(element);
        Document document = element.getOwnerDocument();
        element.appendChild(this.getDomElementForProxy(document, "plugin-descriptor", this._parentDescriptor.getUniqueIdentifier(), this._parentDescriptor.getVersionIdentifier().toString()));
        element.appendChild(this.getDomElementForText(document, "simple-id", this._simpleId));
        element.appendChild(this.getDomElementForText(document, "extension-point-id", this._extensionPointUniqueId));
        Element element2 = document.createElement("configuration-elements");
        if (this._elements != null) {
            for (int i = 0; i < this._elements.length; ++i) {
                Element element3 = document.createElement("config-element");
                this._elements[i].toXml(element3);
                element2.appendChild(element3);
            }
        }
        element.appendChild(element2);
    }

    public String toString() {
        return "Extension: '" + this.getUniqueIdentifier() + "' [" + this.getVersion() + "]";
    }

    void setRealExtensionObjectInConfigElements() {
        if (this._elements == null) {
            return;
        }
        for (int i = 0; i < this._elements.length; ++i) {
            if (this._elements[i] == null) continue;
            this._elements[i].setParentAsIs(this);
        }
    }
}

