/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Iterator;
import java.util.Vector;

public class ExtensionClassLoader
extends ClassLoader {
    private static final Logger s_logger = LoggerFactory.getLogger(ExtensionClassLoader.class);
    private ClassLoader _main = null;
    private ClassLoader _supplemental = null;
    private Vector classLoaderList = new Vector();

    public ExtensionClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        this.classLoaderList.add(classLoader);
        this.classLoaderList.add(classLoader2);
    }

    public ExtensionClassLoader(Vector vector, Vector vector2) {
        this.classLoaderList.addAll(vector);
        this.classLoaderList.addAll(vector2);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "loadClass", new Object[]{string});
        }
        Class<?> clazz = null;
        Throwable throwable = null;
        if (this.classLoaderList != null) {
            Iterator iterator = this.classLoaderList.iterator();
            while (clazz == null && iterator.hasNext()) {
                try {
                    ClassLoader classLoader = (ClassLoader)iterator.next();
                    clazz = classLoader.loadClass(string);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("Could not load class. ClassLoader list was empty. name=" + string);
        }
        if (clazz == null) {
            if (throwable != null) {
                FFDCFilter.processException(throwable, this.getClass().toString() + ".loadClass", "1");
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(throwable.toString());
                }
            } else if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Class did not load. name=" + string);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "loadClass", clazz);
        }
        return clazz;
    }
}

