/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ExtensionInvoker
implements InvocationHandler {
    private static final Logger s_logger = LoggerFactory.getLogger(ExtensionInvoker.class);
    private Object _remoteObj;
    private HashMap _availableMethods;

    ExtensionInvoker(Object object, Class[] classArray) {
        try {
            Assert.it(object != null, "null remoteObj");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException("remoteObj");
        }
        this._remoteObj = object;
        this._availableMethods = new HashMap();
        for (int i = 0; i < classArray.length; ++i) {
            Method[] methodArray = classArray[i].getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                this._availableMethods.put(this.getMethodKey(methodArray[j]), methodArray[j]);
            }
        }
    }

    private String getMethodKey(Method method2) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getMethodKey", new Object[]{method2});
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(method2.getReturnType().getName()).append(' ');
        stringBuffer.append(method2.getName()).append('(');
        Object object = method2.getParameterTypes();
        if (((Class<?>[])object).length > 0) {
            stringBuffer.append(object[0].getName());
            for (int i = 1; i < ((Class<?>[])object).length; ++i) {
                stringBuffer.append(',').append(object[i].getName());
            }
        }
        stringBuffer.append(')');
        object = stringBuffer.toString();
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getMethodKey", object);
        }
        return object;
    }

    public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
        try {
            Assert.it(method2 != null, "null method");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException("method");
        }
        String string = this.getMethodKey(method2);
        Method method3 = (Method)this._availableMethods.get(string);
        if (method3 != null) {
            return method3.invoke(this._remoteObj, objectArray);
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("Can't invoke " + string + " on " + this._remoteObj);
        }
        throw new IllegalArgumentException("method");
    }
}

