/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.OffloadablePluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginVersionTracker;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtensionPoint
extends OffloadablePluginModelObject
implements IExtensionPoint,
Serializable {
    private static final Logger s_logger = LoggerFactory.getLogger(ExtensionPoint.class);
    public static final String DOM_TAG_NAME = "extension-point";
    private IPluginDescriptor _parentDescriptor = null;
    private String _simpleId = null;
    private String _schema = null;
    private HashMap _extensions = new HashMap();

    public IConfigurationElement[] getConfigurationElements() {
        List list = this.getConfigurationElementsInternal();
        return list != null ? list.toArray(new IConfigurationElement[list.size()]) : Constants.EMPTY_CONFIGELEM_ARRAY;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return this._parentDescriptor;
    }

    public String getNamespace() {
        return this.getDeclaringPluginDescriptor().getUniqueIdentifier();
    }

    public IExtension getExtension(String string) {
        ExtensionProxy extensionProxy = (ExtensionProxy)this._extensions.get(string);
        return extensionProxy != null && extensionProxy.isResolved() ? extensionProxy : null;
    }

    public IExtension[] getExtensions() {
        HashSet<ExtensionProxy> hashSet = null;
        Collection collection = this._extensions.values();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            hashSet = new HashSet<ExtensionProxy>();
            while (iterator.hasNext()) {
                ExtensionProxy extensionProxy = (ExtensionProxy)iterator.next();
                if (extensionProxy == null || !extensionProxy.isResolved()) continue;
                hashSet.add(extensionProxy);
            }
        }
        return hashSet != null ? hashSet.toArray(new ExtensionProxy[hashSet.size()]) : Constants.EMPTY_EXTENSION_ARRAY;
    }

    public String getLabel() {
        return this.getLabel(this.getDeclaringPluginDescriptor(), s_logger);
    }

    public String getSchemaReference() {
        return this._schema;
    }

    public String getSimpleIdentifier() {
        return this._simpleId;
    }

    public String getUniqueIdentifier() {
        return this.getDeclaringPluginDescriptor().getUniqueIdentifier() + "." + this.getSimpleIdentifier();
    }

    public boolean isValid() {
        return true;
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.getDeclaringPluginDescriptor().getUniqueIdentifier();
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return null;
    }

    protected List getConfigurationElementsInternal() {
        ArrayList<IConfigurationElement> arrayList = null;
        IExtension[] iExtensionArray = this.getExtensions();
        if (iExtensionArray != null) {
            arrayList = new ArrayList<IConfigurationElement>();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                if (iConfigurationElementArray == null) continue;
                for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                    arrayList.add(iConfigurationElementArray[j]);
                }
            }
        }
        return arrayList;
    }

    boolean addExtension(ExtensionProxy extensionProxy) {
        boolean bl = true;
        if (this._extensions.containsKey(extensionProxy.getUniqueIdentifier())) {
            ExtensionProxy extensionProxy2 = (ExtensionProxy)this._extensions.get(extensionProxy.getUniqueIdentifier());
            if (PluginVersionTracker.compareVersionStrings(extensionProxy.getVersion(), extensionProxy2.getVersion()) == 1) {
                extensionProxy2.setResolved(false);
            } else {
                bl = false;
            }
        }
        if (bl) {
            this._extensions.put(extensionProxy.getUniqueIdentifier(), extensionProxy);
            this.setDirty(true);
            if (s_logger.isInfoEnabled()) {
                s_logger.info("info.extension.connected_2", "Connect", new Object[]{extensionProxy.getUniqueIdentifier(), this.getUniqueIdentifier()});
            } else if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this.toString() + ".addExtension: " + extensionProxy.toString() + " (" + this._extensions.size() + ")");
            }
        }
        return bl;
    }

    void removeExtension(ExtensionProxy extensionProxy) {
        Iterator iterator = this._extensions.keySet().iterator();
        while (iterator.hasNext()) {
            ExtensionProxy extensionProxy2;
            String string = (String)iterator.next();
            if (!string.equals(extensionProxy.getUniqueIdentifier()) || !(extensionProxy2 = (ExtensionProxy)this._extensions.get(string)).equals(extensionProxy)) continue;
            this._extensions.remove(string);
            this.setDirty(true);
            if (!s_logger.isTraceDebugEnabled()) break;
            s_logger.traceDebug(this.toString() + ".removeExtension: " + extensionProxy.toString() + " (" + this._extensions.size() + ")");
            break;
        }
    }

    public IExtension[] getExtensionsInternal() {
        HashSet<ExtensionProxy> hashSet = null;
        Collection collection = this._extensions.values();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            hashSet = new HashSet<ExtensionProxy>();
            while (iterator.hasNext()) {
                ExtensionProxy extensionProxy = (ExtensionProxy)iterator.next();
                if (extensionProxy == null || !extensionProxy.isLoaded()) continue;
                hashSet.add(extensionProxy);
            }
        }
        return hashSet != null ? hashSet.toArray(new ExtensionProxy[hashSet.size()]) : Constants.EMPTY_EXTENSION_ARRAY;
    }

    void setParentDescriptor(PluginDescriptor pluginDescriptor) {
        this._parentDescriptor = RegistryCache.INSTANCE.getPluginDescriptorProxy(pluginDescriptor.getUniqueIdentifier(), pluginDescriptor.getVersion());
        this.setVersion(pluginDescriptor.getVersion());
        this.setDirty(true);
    }

    void setParentDescriptorAsIs(PluginDescriptor pluginDescriptor) {
        this._parentDescriptor = pluginDescriptor;
        this.setVersion(pluginDescriptor.getVersion());
    }

    void setSchema(String string) {
        this._schema = string;
        this.setDirty(true);
    }

    void setSimpleId(String string) {
        this._simpleId = string;
        this.setDirty(true);
    }

    public boolean equals(Object object) {
        boolean bl;
        block3: {
            block6: {
                int n;
                ExtensionProxy[] extensionProxyArray;
                block5: {
                    block4: {
                        bl = false;
                        if (!(object instanceof ExtensionPoint)) break block3;
                        ExtensionPoint extensionPoint = (ExtensionPoint)object;
                        if (this._parentDescriptor != null && !this._parentDescriptor.equals(extensionPoint.getDeclaringPluginDescriptor()) || this._parentDescriptor == null && extensionPoint.getDeclaringPluginDescriptor() != null || !this._simpleId.equals(extensionPoint.getSimpleIdentifier()) || this._schema != null && !this._schema.equals(extensionPoint.getSchemaReference()) || this._schema == null && extensionPoint.getSchemaReference() != null) break block3;
                        extensionProxyArray = (ExtensionProxy[])extensionPoint.getExtensions();
                        if (this._extensions != null) break block4;
                        if (extensionProxyArray == null || 0 >= extensionProxyArray.length) break block5;
                        break block3;
                    }
                    if (extensionProxyArray != null ? this._extensions.size() != extensionProxyArray.length : 0 < this._extensions.size()) break block3;
                }
                if (this._extensions == null || extensionProxyArray == null) break block6;
                for (n = 0; n < extensionProxyArray.length && this._extensions.containsValue(extensionProxyArray[n]); ++n) {
                }
                if (n < extensionProxyArray.length) break block3;
            }
            bl = true;
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        this._parentDescriptor = RegistryCache.INSTANCE.getPluginDescriptorProxy(string, string2);
        this._simpleId = objectInputStream.readUTF();
        if (this._simpleId.equals("null")) {
            this._simpleId = null;
        }
        this._schema = objectInputStream.readUTF();
        if (this._schema.equals("null")) {
            this._schema = null;
        }
        this._extensions = new HashMap();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string3 = objectInputStream.readUTF();
            String string4 = objectInputStream.readUTF();
            this._extensions.put(string3, RegistryCache.INSTANCE.getExtensionProxy(string3, string4));
        }
        this.setDirty(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        if (this._parentDescriptor != null) {
            String string = this._parentDescriptor.getUniqueIdentifier();
            objectOutputStream.writeUTF(string != null ? string : "null");
            object = this._parentDescriptor.getVersionIdentifier().toString();
            objectOutputStream.writeUTF((String)(object != null ? object : "null"));
        } else {
            objectOutputStream.writeUTF("null");
            objectOutputStream.writeUTF("null");
        }
        objectOutputStream.writeUTF(this._simpleId != null ? this._simpleId : "null");
        objectOutputStream.writeUTF(this._schema != null ? this._schema : "null");
        if (this._extensions != null) {
            int n = this._extensions.size();
            objectOutputStream.writeInt(n);
            if (0 < n) {
                object = this._extensions.keySet().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    ExtensionProxy extensionProxy = (ExtensionProxy)this._extensions.get(string);
                    objectOutputStream.writeUTF(string);
                    objectOutputStream.writeUTF(extensionProxy.getVersion());
                }
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        this.setDirty(false);
    }

    public String getRootElementName() {
        return DOM_TAG_NAME;
    }

    public void initFromDom(Element element) {
        super.initFromDom(element);
        NodeList nodeList = element.getElementsByTagName("plugin-descriptor");
        Node node = nodeList.item(0);
        if (node != null && node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("id");
            Node node3 = namedNodeMap.getNamedItem("version");
            if (node2 != null && node3 != null) {
                this._parentDescriptor = RegistryCache.INSTANCE.getPluginDescriptorProxy(node2.getNodeValue(), node3.getNodeValue());
            }
        }
        this._simpleId = this.readTextFromDomElement(element, "simple-id");
        this._schema = this.readTextFromDomElement(element, "schema");
        this.readExtensionsFromDomElement(element, this._extensions, "");
        this.setDirty(false);
    }

    public void toXml(Element element) {
        super.toXml(element);
        Document document = element.getOwnerDocument();
        element.appendChild(this.getDomElementForProxy(document, "plugin-descriptor", this._parentDescriptor.getUniqueIdentifier(), this._parentDescriptor.getVersionIdentifier().toString()));
        element.appendChild(this.getDomElementForText(document, "simple-id", this._simpleId));
        element.appendChild(this.getDomElementForText(document, "schema", this._schema));
        element.appendChild(this.getDomElementForExtensions(document, this._extensions));
    }

    public String toString() {
        return "ExtensionPoint: '" + this.getUniqueIdentifier() + "' [" + this.getVersion() + "]";
    }
}

