/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.IModifiableRegistry;
import com.ibm.wkplc.extensionregistry.IRegistryTool;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.PluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginVersionTracker;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryConfig;
import com.ibm.wkplc.extensionregistry.RegistryLoader;
import com.ibm.wkplc.extensionregistry.RegistryNotifier;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.RegistryResolver;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeListener;

public class ExtensionRegistry
extends PluginModelObject
implements IModifiableRegistry,
IRegistryTool {
    protected static final Logger s_logger = LoggerFactory.getLogger(ExtensionRegistry.class);
    public static final String DOM_TAG_NAME = "extension-registry";
    private transient RegistryLoader _loader = null;
    private transient RegistryResolver _resolver = null;
    private transient RegistryNotifier _notifier = null;
    private transient PluginVersionTracker _tracker = null;
    private Map _plgProxies = new HashMap();
    private Map _xptProxies = new HashMap();
    private Map _extProxies = new HashMap();
    private boolean _bResolved = false;
    private boolean _bSkipResolve = false;

    public ExtensionRegistry() {
        this._loader = new RegistryLoader(this);
        this._resolver = new RegistryResolver(this);
        this._notifier = new RegistryNotifier(this);
        this._tracker = new PluginVersionTracker(this);
        if (RegistryConfig.isPagingEnabled()) {
            this._bSkipResolve = this._loader.restore();
        }
        this._loader.loadSelf();
    }

    public void load(ClassLoader classLoader) {
        this._loader.loadModule(classLoader);
    }

    public void unload(ClassLoader classLoader) {
        this._loader.unloadModule(classLoader);
    }

    public synchronized void resolve() {
        if (!this.isResolved()) {
            this._resolver.resolve();
            this.setResolved(true);
        }
        RegistryCache.INSTANCE.updateSerializedFiles();
        if (s_logger.isTraceDebugEnabled()) {
            this.dumpUnresolved();
        }
    }

    public synchronized boolean isResolved() {
        return this._bResolved;
    }

    private synchronized void setResolved(boolean bl) {
        this._bResolved = bl;
    }

    void notifyChanges() {
        this._notifier.fireChangeEvent();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string) {
        IExtensionPointProxy iExtensionPointProxy;
        if (!this.isResolved()) {
            this.resolve();
        }
        if ((iExtensionPointProxy = (IExtensionPointProxy)this.getExtensionPoint(string)) == null || !iExtensionPointProxy.isLoaded() || iExtensionPointProxy.isPlaceHolder()) {
            return Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPointProxy.getConfigurationElements();
        return iConfigurationElementArray == null ? Constants.EMPTY_CONFIGELEM_ARRAY : iConfigurationElementArray;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2) {
        return this.getConfigurationElementsFor(string + "." + string2);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2, String string3) {
        ExtensionProxy extensionProxy = (ExtensionProxy)this.getExtension(string, string2, string3);
        if (extensionProxy == null || !extensionProxy.isResolved()) {
            return Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        IConfigurationElement[] iConfigurationElementArray = extensionProxy.getConfigurationElements();
        return iConfigurationElementArray == null ? Constants.EMPTY_CONFIGELEM_ARRAY : iConfigurationElementArray;
    }

    public IExtension getExtension(String string) {
        ExtensionProxy extensionProxy;
        if (!this.isResolved()) {
            this.resolve();
        }
        return (extensionProxy = (ExtensionProxy)this._extProxies.get(string)) != null && extensionProxy.isResolved() ? extensionProxy : null;
    }

    public IExtension getExtension(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return this.getExtension(string.substring(0, n), string.substring(n + 1), string2);
    }

    public IExtension getExtension(String string, String string2, String string3) {
        IExtensionPointProxy iExtensionPointProxy;
        if (!this.isResolved() && !this._bSkipResolve) {
            this.resolve();
        }
        return (iExtensionPointProxy = (IExtensionPointProxy)this.getExtensionPoint(string, string2)) != null && iExtensionPointProxy.isResolved() ? iExtensionPointProxy.getExtension(string3) : null;
    }

    public IExtensionPoint getExtensionPoint(String string) {
        ExtensionPointProxy extensionPointProxy;
        if (!this.isResolved()) {
            this.resolve();
        }
        return (extensionPointProxy = (ExtensionPointProxy)this._xptProxies.get(string)) != null && extensionPointProxy.isResolved() ? extensionPointProxy : null;
    }

    public IExtensionPoint getExtensionPoint(String string, String string2) {
        return this.getExtensionPoint(string + "." + string2);
    }

    public IExtensionPoint[] getExtensionPoints() {
        if (!this.isResolved()) {
            this.resolve();
        }
        HashSet<ExtensionPointProxy> hashSet = new HashSet<ExtensionPointProxy>();
        Iterator iterator = this._xptProxies.values().iterator();
        while (iterator.hasNext()) {
            ExtensionPointProxy extensionPointProxy = (ExtensionPointProxy)iterator.next();
            if (!extensionPointProxy.isResolved()) continue;
            hashSet.add(extensionPointProxy);
        }
        return hashSet.toArray(new IExtensionPointProxy[hashSet.size()]);
    }

    public IExtensionPoint[] getExtensionPoints(String string) {
        PluginDescriptorProxy pluginDescriptorProxy;
        if (!this.isResolved() && !this._bSkipResolve) {
            this.resolve();
        }
        return (pluginDescriptorProxy = this.getPlugin(string, false)) != null && pluginDescriptorProxy.hasClassLoader() ? pluginDescriptorProxy.getExtensionPoints() : Constants.EMPTY_EXTENSIONPOINT_ARRAY;
    }

    public IExtension[] getExtensions(String string) {
        IExtensionPointProxy iExtensionPointProxy;
        if (!this.isResolved() && !this._bSkipResolve) {
            this.resolve();
        }
        return (iExtensionPointProxy = (IExtensionPointProxy)this.getExtensionPoint(string)) != null && iExtensionPointProxy.isResolved() ? iExtensionPointProxy.getExtensions() : Constants.EMPTY_EXTENSION_ARRAY;
    }

    public String[] getNamespaces() {
        if (!this.isResolved() && !this._bSkipResolve) {
            this.resolve();
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this._plgProxies.values().iterator();
        while (iterator.hasNext()) {
            PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)iterator.next();
            if (pluginDescriptorProxy == null || !pluginDescriptorProxy.isResolved() && (!this._bSkipResolve || !pluginDescriptorProxy.hasClassLoader())) continue;
            hashSet.add(pluginDescriptorProxy.getUniqueIdentifier());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener, String string) {
        this._notifier.addRegistryChangeListener(iRegistryChangeListener, string);
    }

    public void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        this._notifier.addRegistryChangeListener(iRegistryChangeListener, null);
    }

    public void removeRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        this._notifier.removeRegistryChangeListener(iRegistryChangeListener);
    }

    public boolean addContribution(InputStream inputStream, IContributor iContributor, boolean bl, String string, ResourceBundle resourceBundle, Object object) throws IllegalArgumentException {
        return false;
    }

    public boolean removeExtension(IExtension iExtension, Object object) {
        return false;
    }

    public boolean removeExtensionPoint(IExtensionPoint iExtensionPoint, Object object) {
        return false;
    }

    public void stop(Object object) {
    }

    public void addPlugin(PluginDescriptor pluginDescriptor) {
        this.addPlugin(pluginDescriptor, true);
    }

    void addPlugin(PluginDescriptor pluginDescriptor, boolean bl) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "addPlugin", new Object[]{pluginDescriptor});
        }
        if (this._resolver.checkPluginDescriptorBasics(pluginDescriptor)) {
            String string = pluginDescriptor.getUniqueIdentifier();
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("adding plugin=" + string + ", " + pluginDescriptor.getVersion() + " (CLID=" + (pluginDescriptor.getPluginClassLoader() != null ? pluginDescriptor.getPluginClassLoader().hashCode() : 0) + ")");
            }
            PluginDescriptorProxy pluginDescriptorProxy = RegistryCache.INSTANCE.getPluginDescriptorProxy(string, pluginDescriptor.getVersion());
            ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
            if (classLoader != null) {
                pluginDescriptorProxy.setPluginClassLoader(classLoader);
            }
            boolean bl2 = bl ? this._tracker.addPlugin(pluginDescriptorProxy) : true;
            pluginDescriptor.convertObjectsToProxies();
            RegistryCache.INSTANCE.putPluginDescriptor(pluginDescriptor);
            if (bl2) {
                ExtensionProxy[] extensionProxyArray;
                this.addPluginDescriptorProxy(pluginDescriptorProxy, false);
                ExtensionPointProxy[] extensionPointProxyArray = (ExtensionPointProxy[])pluginDescriptor.getExtensionPoints();
                if (extensionPointProxyArray != null) {
                    for (int i = 0; i < extensionPointProxyArray.length; ++i) {
                        this.addExtensionPointProxy(extensionPointProxyArray[i], bl);
                    }
                }
                if ((extensionProxyArray = (ExtensionProxy[])pluginDescriptor.getExtensions()) != null) {
                    for (int i = 0; i < extensionProxyArray.length; ++i) {
                        this.addExtensionProxy(extensionProxyArray[i], bl);
                    }
                }
                this._notifier.addDelta(pluginDescriptor, 1, false);
                this.setResolved(false);
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.warn("err.resolve_failure_0", "Request", null);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "addPlugin");
        }
    }

    public void removePlugin(String string, String string2) {
        this.removePlugin(string, string2, true);
    }

    void removePlugin(String string, String string2, boolean bl) {
        boolean bl2;
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "removePlugin", new Object[]{string + " [" + string2 + "], version tracking=" + bl});
        }
        boolean bl3 = bl2 = bl ? this._tracker.removePlugin(string, string2) : true;
        if (bl2) {
            PluginDescriptor pluginDescriptor;
            PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)this._plgProxies.get(string);
            if (pluginDescriptorProxy != null) {
                String string3;
                RegistryObjectProxy registryObjectProxy;
                ExtensionProxy[] extensionProxyArray;
                pluginDescriptor = RegistryCache.INSTANCE.getRealPluginDescriptor(pluginDescriptorProxy);
                this._notifier.addDelta(pluginDescriptor, 2, bl);
                ExtensionProxy[] extensionProxyArray2 = (ExtensionProxy[])pluginDescriptorProxy.getExtensions();
                for (int i = 0; i < extensionProxyArray2.length; ++i) {
                    String string4 = extensionProxyArray2[i].getExtensionPointUniqueIdentifier();
                    extensionProxyArray = (ExtensionProxy[])this._xptProxies.get(string4);
                    if (extensionProxyArray != null) {
                        extensionProxyArray.removeExtension(extensionProxyArray2[i]);
                    }
                    if ((registryObjectProxy = (ExtensionProxy)this._extProxies.get(string3 = extensionProxyArray2[i].getUniqueIdentifier())) == null || !registryObjectProxy.getVersion().equals(string2)) continue;
                    this._extProxies.remove(string3);
                    if (bl) {
                        RegistryCache.INSTANCE.removeObject(string3, string2);
                    }
                    if (!s_logger.isTraceDebugEnabled()) continue;
                    s_logger.traceDebug("removed: " + extensionProxyArray2[i]);
                }
                IExtensionPointProxy[] iExtensionPointProxyArray = (IExtensionPointProxy[])pluginDescriptorProxy.getExtensionPoints();
                for (int i = 0; i < iExtensionPointProxyArray.length; ++i) {
                    extensionProxyArray = (ExtensionProxy[])iExtensionPointProxyArray[i].getExtensions();
                    for (int j = 0; j < extensionProxyArray.length; ++j) {
                        extensionProxyArray[j].setResolved(false);
                    }
                    string3 = iExtensionPointProxyArray[i].getUniqueIdentifier();
                    registryObjectProxy = (ExtensionPointProxy)this._xptProxies.get(string3);
                    if (registryObjectProxy == null || !registryObjectProxy.getVersion().equals(string2)) continue;
                    this._xptProxies.remove(string3);
                    if (bl) {
                        RegistryCache.INSTANCE.removeObject(string3, string2);
                    }
                    if (!s_logger.isTraceDebugEnabled()) continue;
                    s_logger.traceDebug("removed: " + iExtensionPointProxyArray[i]);
                }
                this._plgProxies.remove(string);
                if (bl) {
                    RegistryCache.INSTANCE.removeObject(string, string2);
                }
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("removed: " + pluginDescriptorProxy);
                }
            }
            if (bl) {
                pluginDescriptor = this._tracker.getHighestVersion(string);
                if (pluginDescriptor != null) {
                    this.addPlugin(pluginDescriptor, false);
                }
                this.setResolved(false);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "removePlugin");
        }
    }

    public PluginDescriptorProxy getPlugin(String string) {
        return this.getPlugin(string, true);
    }

    PluginDescriptorProxy getPlugin(String string, boolean bl) {
        PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)this._plgProxies.get(string);
        if (pluginDescriptorProxy != null) {
            if (bl && !pluginDescriptorProxy.isResolved()) {
                pluginDescriptorProxy = null;
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("Requested plug-in unresolved at this time: " + string);
                }
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("Requested plug-in not found: " + string);
        }
        return pluginDescriptorProxy;
    }

    Collection getAllPluginProxies() {
        return this._plgProxies.values();
    }

    void addPluginDescriptorProxy(PluginDescriptorProxy pluginDescriptorProxy, boolean bl) {
        pluginDescriptorProxy.setResolved(false);
        if (!bl || this._tracker.addPlugin(pluginDescriptorProxy)) {
            this._plgProxies.put(pluginDescriptorProxy.getUniqueIdentifier(), pluginDescriptorProxy);
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("added: " + pluginDescriptorProxy);
            }
            this.setResolved(false);
        }
    }

    void addExtensionPointProxy(ExtensionPointProxy extensionPointProxy, boolean bl) {
        ExtensionPointProxy extensionPointProxy2;
        extensionPointProxy.setResolved(false);
        String string = extensionPointProxy.getUniqueIdentifier();
        boolean bl2 = true;
        if (bl && (extensionPointProxy2 = (ExtensionPointProxy)this._xptProxies.get(string)) != null && PluginVersionTracker.compareVersionStrings(extensionPointProxy2.getVersion(), extensionPointProxy.getVersion()) == 1) {
            bl2 = false;
        }
        if (bl2) {
            this._xptProxies.put(string, extensionPointProxy);
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("added: " + extensionPointProxy);
            }
            this.setResolved(false);
        }
    }

    void addExtensionProxy(ExtensionProxy extensionProxy, boolean bl) {
        ExtensionProxy extensionProxy2;
        extensionProxy.setResolved(false);
        String string = extensionProxy.getUniqueIdentifier();
        boolean bl2 = true;
        if (bl && (extensionProxy2 = (ExtensionProxy)this._extProxies.get(string)) != null && PluginVersionTracker.compareVersionStrings(extensionProxy2.getVersion(), extensionProxy.getVersion()) == 1) {
            bl2 = false;
        }
        if (bl2) {
            this._extProxies.put(string, extensionProxy);
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("added: " + extensionProxy);
            }
            this.setResolved(false);
        }
    }

    void setClassLoaderInPlugin(String string, String string2, ClassLoader classLoader) {
        PluginDescriptorProxy pluginDescriptorProxy = RegistryCache.INSTANCE.getPluginDescriptorProxy(string, string2);
        if (pluginDescriptorProxy != null) {
            if (!pluginDescriptorProxy.hasClassLoader()) {
                this._notifier.addDelta(pluginDescriptorProxy, 1, false);
                this.setResolved(false);
            }
            pluginDescriptorProxy.setPluginClassLoader(classLoader);
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("ExtensionRegistry.setClassLoaderInPlugin failed to get proxy for: " + string + " [" + string2 + "]");
        }
    }

    private void dumpUnresolved() {
        Object object;
        Object object2;
        Iterator iterator = this._plgProxies.values().iterator();
        while (iterator.hasNext()) {
            object2 = (PluginDescriptorProxy)iterator.next();
            if (((RegistryObjectProxy)object2).isResolved()) continue;
            s_logger.traceDebug("Unresolved: " + ((PluginDescriptorProxy)object2).toString());
        }
        object2 = this._xptProxies.values().iterator();
        while (object2.hasNext()) {
            object = (ExtensionPointProxy)object2.next();
            if (((RegistryObjectProxy)object).isResolved()) continue;
            s_logger.traceDebug("Unresolved: " + ((ExtensionPointProxy)object).toString());
        }
        object = this._extProxies.values().iterator();
        while (object.hasNext()) {
            ExtensionProxy extensionProxy = (ExtensionProxy)object.next();
            if (extensionProxy.isResolved()) continue;
            s_logger.traceDebug("Unresolved: " + extensionProxy.toString());
        }
    }

    public String dumpAll() {
        return this._tracker.dump();
    }

    public String getContentXml() throws CoreException {
        return this._tracker.toXml();
    }

    public void shutdown() {
        if (!RegistryConfig.isZOS()) {
            if (!this.isResolved()) {
                this.resolve();
            }
            this._loader.save(this._plgProxies.values().toArray(new PluginDescriptorProxy[this._plgProxies.size()]), this._xptProxies.values().toArray(new ExtensionPointProxy[this._xptProxies.size()]), this._extProxies.values().toArray(new ExtensionProxy[this._extProxies.size()]));
        }
        this._bSkipResolve = true;
        RegistryCache.INSTANCE.setServerStopping();
        if (RegistryConfig.isZOS()) {
            this.cleanCache();
        }
    }

    private void cleanCache() {
        boolean bl;
        File file = new File(RegistryConfig.getStorageLocation());
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            bl = fileArray[i].delete();
            if (bl) continue;
            fileArray[i].deleteOnExit();
        }
        bl = file.delete();
        if (!bl) {
            file.deleteOnExit();
        }
    }

    public synchronized void enableResolving() {
        this._bSkipResolve = false;
    }

    synchronized boolean isSkippingResolve() {
        return this._bSkipResolve;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._plgProxies = (HashMap)objectInputStream.readObject();
        this._xptProxies = (HashMap)objectInputStream.readObject();
        this._extProxies = (HashMap)objectInputStream.readObject();
        this.setResolved(false);
        this._loader = new RegistryLoader(this);
        this._resolver = new RegistryResolver(this);
        this._notifier = new RegistryNotifier(this);
        this._tracker = new PluginVersionTracker(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this._plgProxies);
        objectOutputStream.writeObject(this._xptProxies);
        objectOutputStream.writeObject(this._extProxies);
    }
}

