/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.ExtensionRegistryProxy;
import com.ibm.wkplc.extensionregistry.FilteredExtensionRegistry;
import com.ibm.wkplc.extensionregistry.IRegistryTool;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.RegistryConfig;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;

public class ExtensionRegistryFactory
implements Serializable {
    protected static final Logger s_logger = LoggerFactory.getLogger(ExtensionRegistryFactory.class);
    private static final String THIS_CLASS = "com.ibm.wkplc.extensionregistry.ExtensionRegistryFactory";
    public static final String GLOBAL_FILTER_NAME = "";
    public static ExtensionRegistryFactory INSTANCE = new ExtensionRegistryFactory();
    private static ExtensionRegistry s_globalRegistry = new ExtensionRegistry();
    private static HashMap s_namedRegistries = new HashMap();
    private static RegistryInstanceListener s_listener = null;

    private ExtensionRegistryFactory() {
        AdminService adminService;
        if (s_globalRegistry != null && s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("Global ExtensionRegistry instance created");
        }
        if ((adminService = AdminServiceFactory.getAdminService()) != null) {
            block4: {
                try {
                    InitialContext initialContext = new InitialContext();
                    JndiHelper.recursiveCreateSubcontext((Context)initialContext, "services/extensionregistry");
                }
                catch (Exception exception) {
                    if (exception instanceof NameAlreadyBoundException) break block4;
                    FFDCFilter.processException(exception, "com.ibm.wkplc.extensionregistry.ExtensionRegistryFactory.<init>", "1");
                }
            }
            ExtensionRegistryFactory.rebindJndiEntity(null);
        }
    }

    public static void init() {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(THIS_CLASS, "init");
        }
        ExtensionRegistryFactory.setupListener();
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "init");
        }
    }

    public static void setupListener() {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(THIS_CLASS, "setupListener");
        }
        if (s_listener == null) {
            s_listener = new RegistryInstanceListener();
            s_globalRegistry.addRegistryChangeListener(s_listener, "org.eclipse.extensionregistry");
            s_listener.refreshJndiEntities();
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "setupListener");
        }
    }

    public synchronized IExtensionRegistry getExtensionRegistry() {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getExtensionRegistry");
        }
        IRegistryTool iRegistryTool = null;
        if (RegistryConfig.isGlobalFilteringEnabled()) {
            iRegistryTool = this.retrieveRegistryInstance(GLOBAL_FILTER_NAME);
            if (iRegistryTool == null) {
                iRegistryTool = new FilteredExtensionRegistry(this.getGlobalExtensionRegistry(), GLOBAL_FILTER_NAME);
                this.storeRegistryInstance((FilteredExtensionRegistry)iRegistryTool);
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("FilteredExtensionRegistry instance created for global filters");
                }
            }
        } else {
            iRegistryTool = this.getGlobalExtensionRegistry();
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getExtensionRegistry", (Object)iRegistryTool);
        }
        return iRegistryTool;
    }

    public synchronized IExtensionRegistry getExtensionRegistry(String string) {
        FilteredExtensionRegistry filteredExtensionRegistry;
        try {
            Assert.it(string != null, "null name");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException("name");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getExtensionRegistry", new Object[]{string});
        }
        if ((filteredExtensionRegistry = this.retrieveRegistryInstance(string)) == null) {
            filteredExtensionRegistry = new FilteredExtensionRegistry(this.getGlobalExtensionRegistry(), string);
            this.storeRegistryInstance(filteredExtensionRegistry);
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("FilteredExtensionRegistry instance created for: " + string);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getExtensionRegistry", (Object)filteredExtensionRegistry);
        }
        return filteredExtensionRegistry;
    }

    private FilteredExtensionRegistry retrieveRegistryInstance(String string) {
        return (FilteredExtensionRegistry)s_namedRegistries.get(string);
    }

    private void storeRegistryInstance(FilteredExtensionRegistry filteredExtensionRegistry) {
        if (filteredExtensionRegistry != null) {
            s_namedRegistries.put(filteredExtensionRegistry.getName(), filteredExtensionRegistry);
        }
    }

    private static synchronized void rebindJndiEntity(String string) {
        block21: {
            NameClassPair nameClassPair;
            String string2;
            String string3;
            InitialContext initialContext;
            boolean bl;
            block20: {
                if (s_logger.isTraceEntryExitEnabled()) {
                    s_logger.traceEntry(THIS_CLASS, "rebindJndiEntity", new Object[]{string});
                }
                bl = s_logger.isTraceDebugEnabled();
                initialContext = null;
                try {
                    initialContext = new InitialContext();
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException(namingException, THIS_CLASS, "2");
                    if (s_logger.isErrorEnabled()) {
                        s_logger.error("err.registry_bind_failure_1", "Request", new Object[]{"new InitialContext()"}, namingException);
                    }
                    return;
                }
                string3 = null;
                string2 = null;
                if (string != null && 0 < string.length()) {
                    string3 = "services/extensionregistry/" + string;
                    string2 = string;
                } else {
                    string3 = "services/extensionregistry/global";
                    string2 = GLOBAL_FILTER_NAME;
                }
                nameClassPair = null;
                try {
                    NamingEnumeration<NameClassPair> namingEnumeration;
                    int n = string3.lastIndexOf(47);
                    String string4 = string3.substring(0, n);
                    String string5 = string3.substring(n + 1);
                    if (bl) {
                        s_logger.traceDebug("searching JNDI Bindings for Context: " + string4);
                    }
                    if ((namingEnumeration = initialContext.list(string4)) != null) {
                        while (nameClassPair == null && namingEnumeration.hasMore()) {
                            NameClassPair nameClassPair2 = namingEnumeration.next();
                            if (s_logger.isTraceDebugEnabled()) {
                                s_logger.traceDebug("  " + nameClassPair2.getName() + " (relative=" + nameClassPair2.isRelative() + "), " + nameClassPair2.getClassName());
                            }
                            if (!nameClassPair2.getName().equals(string5)) continue;
                            nameClassPair = nameClassPair2;
                            if (!bl) continue;
                            s_logger.traceDebug("    BINGO!");
                        }
                    } else if (bl) {
                        s_logger.traceDebug("Error - null NamingEnumeration returned");
                    }
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException(namingException, THIS_CLASS, "3");
                    if (!bl) break block20;
                    namingException.printStackTrace();
                }
            }
            if (nameClassPair == null) {
                try {
                    if (bl) {
                        s_logger.traceDebug("calling JndiHelper.recursiveRebind for: " + string3);
                    }
                    JndiHelper.recursiveRebind((Context)initialContext, string3, (Object)new ExtensionRegistryProxy(string2));
                    if (bl) {
                        s_logger.traceDebug("  successfully bound - new ExtensionRegistryProxy(\"" + string2 + "\")");
                    }
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException(namingException, THIS_CLASS, "3");
                    if (!s_logger.isErrorEnabled()) break block21;
                    s_logger.error("err.registry_bind_failure_1", "Request", new Object[]{string3}, namingException);
                }
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "rebindJndiEntity");
        }
    }

    private static synchronized void cleanupJndiForExtension(IExtension iExtension) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(THIS_CLASS, "cleanupJndiForExtension", new Object[]{iExtension});
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, THIS_CLASS, "4");
            if (s_logger.isErrorEnabled()) {
                s_logger.error("err.registry_bind_failure_1", "Request", new Object[]{"new InitialContext()"}, namingException);
            }
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            String string;
            if (!iConfigurationElementArray[i].getName().equals("registry") || (string = iConfigurationElementArray[i].getAttributeAsIs("name")) == null || 0 >= string.length() || string.equals("*")) continue;
            try {
                initialContext.unbind("services/extensionregistry/" + string);
                continue;
            }
            catch (NamingException namingException) {
                if (!s_logger.isTraceDebugEnabled()) continue;
                s_logger.traceDebug("Failed to unbind: services/extensionregistry/" + string);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "cleanupJndiForExtension");
        }
    }

    ExtensionRegistry getGlobalExtensionRegistry() {
        return s_globalRegistry;
    }

    static class RegistryInstanceListener
    implements IRegistryChangeListener {
        RegistryInstanceListener() {
        }

        public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
            IExtensionDelta[] iExtensionDeltaArray;
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "registryChanged");
            }
            if (0 < (iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.extensionregistry", "RegistryInstance")).length) {
                if (s_logger.isTraceDebugEnabled()) {
                    IExtensionDelta[] iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas();
                    s_logger.traceDebug("RegistryInstanceListener received (" + iExtensionDeltaArray2.length + ") : " + iRegistryChangeEvent.toString());
                }
                for (int i = 0; i < iExtensionDeltaArray.length; ++i) {
                    if (iExtensionDeltaArray[i].getKind() != 1) continue;
                    this.refreshJndiForExtension(iExtensionDeltaArray[i].getExtension());
                }
            }
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceExit(this, "registryChanged");
            }
        }

        synchronized void refreshJndiEntities() {
            ExtensionPointProxy extensionPointProxy;
            PluginDescriptorProxy pluginDescriptorProxy = s_globalRegistry.getPlugin("org.eclipse.extensionregistry", false);
            if (pluginDescriptorProxy != null && (extensionPointProxy = (ExtensionPointProxy)pluginDescriptorProxy.getExtensionPoint("RegistryInstance")) != null) {
                IExtension[] iExtensionArray = extensionPointProxy.getExtensionsInternal();
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    this.refreshJndiForExtension(iExtensionArray[i]);
                }
            }
        }

        private void refreshJndiForExtension(IExtension iExtension) {
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                if (!iConfigurationElementArray[i].getName().equals("registry")) continue;
                String string = iConfigurationElementArray[i].getAttribute("name");
                if (string.equals("*")) {
                    string = null;
                }
                ExtensionRegistryFactory.rebindJndiEntity(string);
            }
        }
    }
}

