/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.RegistryConfig;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import com.ibm.workplace.extension.IExtensionRegistryFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;

class FilterInvoker
implements IRegistryChangeListener {
    private static final Logger s_logger = LoggerFactory.getLogger(FilterInvoker.class);
    private ExtensionRegistry _registry;
    private transient List _filters;
    private boolean _firstTime = true;
    private boolean _needsRefresh = true;
    private String _instanceName;
    private boolean _doAnd = true;

    FilterInvoker(ExtensionRegistry extensionRegistry, String string) {
        try {
            Assert.it(extensionRegistry != null, "null reg");
            Assert.it(string != null, "null name");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException(assert_.getMessage());
        }
        this._registry = extensionRegistry;
        this._instanceName = string;
        this._filters = new ArrayList();
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray;
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "registryChanged");
        }
        if (0 < (iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.extensionregistry", "RegistryFilter")).length) {
            if (s_logger.isTraceDebugEnabled()) {
                IExtensionDelta[] iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas();
                s_logger.traceDebug("FilterInvoker received (" + iExtensionDeltaArray2.length + ") : " + iRegistryChangeEvent.toString());
            }
            this.refreshParticipatingFilters();
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "registryChanged");
        }
    }

    private synchronized void refreshParticipatingFilters() {
        block11: {
            PluginDescriptorProxy pluginDescriptorProxy;
            IExtensionPoint iExtensionPoint;
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "refreshParticipatingFilters");
            }
            IExtensionPoint iExtensionPoint2 = iExtensionPoint = (pluginDescriptorProxy = this._registry.getPlugin("org.eclipse.extensionregistry", false)) != null ? pluginDescriptorProxy.getExtensionPoint("RegistryFilter") : null;
            if (iExtensionPoint != null) {
                this._filters.clear();
                this._needsRefresh = true;
                try {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("FilterInvoker.refreshParticipatingFilters() collecting for: \"" + this._instanceName + "\"");
                    }
                    IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                    for (int i = 0; i < iExtensionArray.length; ++i) {
                        this.addFilterFromExtension(iExtensionArray[i]);
                    }
                    this._needsRefresh = false;
                }
                catch (CoreException coreException) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug(coreException.toString());
                    }
                    break block11;
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException(runtimeException, this.getClass().toString() + ".refreshParticipatingFilters", "1");
                    if (s_logger.isErrorEnabled()) {
                        s_logger.error("err.filter_registration_0", "Configure", null, runtimeException);
                    }
                    break block11;
                }
            }
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Warning! RegistryFilter extension point not found!!");
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "refreshParticipatingFilters");
        }
    }

    private void addFilterFromExtension(IExtension iExtension) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            if (!iConfigurationElementArray[i].getName().equals("filter")) continue;
            String string = iConfigurationElementArray[i].getAttribute("name");
            boolean bl = false;
            if (string == null || string.length() == 0 || string.equals("*")) {
                bl = RegistryConfig.isGlobalFilteringEnabled();
            } else if (0 < this._instanceName.length() && this.matchTarget(string)) {
                bl = true;
            }
            if (!bl) continue;
            IExtensionRegistryFilter iExtensionRegistryFilter = (IExtensionRegistryFilter)iConfigurationElementArray[i].createExecutableExtension("class");
            this._filters.add(iExtensionRegistryFilter);
            if (!s_logger.isTraceDebugEnabled()) continue;
            s_logger.traceDebug("FilterInvoker.addFilterFromExtension() found and added: " + iExtension.getUniqueIdentifier() + " (target=" + string + ")");
        }
    }

    private boolean matchTarget(String string) {
        int n = string.indexOf(42);
        if (n == -1) {
            return string.equals(this._instanceName);
        }
        if (n == 0) {
            return true;
        }
        String string2 = string.substring(0, n);
        return this._instanceName.startsWith(string2);
    }

    IExtension[] doFilter(IExtension[] iExtensionArray) {
        if (iExtensionArray == null) {
            return Constants.EMPTY_EXTENSION_ARRAY;
        }
        if (iExtensionArray.length == 0) {
            return Constants.EMPTY_EXTENSION_ARRAY;
        }
        if (this._needsRefresh) {
            if (this._firstTime) {
                this._registry.addRegistryChangeListener(this, "org.eclipse.extensionregistry");
                this._firstTime = false;
            }
            this.refreshParticipatingFilters();
        }
        IExtension[] iExtensionArray2 = Constants.EMPTY_EXTENSION_ARRAY;
        if (this._filters != null && 0 < this._filters.size()) {
            int n = 0;
            if (this._doAnd) {
                iExtensionArray2 = iExtensionArray;
                while (0 < iExtensionArray2.length && n < this._filters.size()) {
                    iExtensionArray2 = ((IExtensionRegistryFilter)this._filters.get(n++)).doFilter(iExtensionArray2);
                }
            } else {
                HashSet<IExtension> hashSet = new HashSet<IExtension>();
                do {
                    IExtension[] iExtensionArray3 = ((IExtensionRegistryFilter)this._filters.get(n++)).doFilter(iExtensionArray);
                    for (int i = 0; i < iExtensionArray3.length; ++i) {
                        hashSet.add(iExtensionArray3[i]);
                    }
                } while (iExtensionArray2.length < iExtensionArray.length && n < this._filters.size());
                iExtensionArray2 = hashSet.toArray(new ExtensionProxy[hashSet.size()]);
            }
        } else {
            iExtensionArray2 = iExtensionArray;
        }
        return iExtensionArray2;
    }

    boolean isGood(IExtension iExtension) {
        if (iExtension.getExtensionPointUniqueIdentifier().equals("org.eclipse.extensionregistry.RegistryFilter")) {
            return true;
        }
        IExtension[] iExtensionArray = this.doFilter(new IExtension[]{iExtension});
        return iExtensionArray != null && 0 < iExtensionArray.length && iExtensionArray[0] != null;
    }
}

