/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.FilterInvoker;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class FilteredExtensionPointProxy
implements IExtensionPointProxy {
    private static final Logger s_logger = LoggerFactory.getLogger(FilteredExtensionPointProxy.class);
    private ExtensionPointProxy _xpt = null;
    private FilterInvoker _filter = null;

    public FilteredExtensionPointProxy(ExtensionPointProxy extensionPointProxy, FilterInvoker filterInvoker) {
        this._xpt = extensionPointProxy;
        this._filter = filterInvoker;
    }

    private ExtensionPoint getRealObject() {
        return RegistryCache.INSTANCE.getRealExtensionPoint(this._xpt);
    }

    public IConfigurationElement[] getConfigurationElements() {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getConfigurationElements");
        }
        IConfigurationElement[] iConfigurationElementArray = null;
        List list = this.getRealObject().getConfigurationElementsInternal();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                IExtension iExtension = null;
                IConfigurationElement iConfigurationElement = (IConfigurationElement)list.get(i);
                iExtension = iConfigurationElement.getDeclaringExtension();
                if (iExtension != null && this._filter.isGood(iExtension)) continue;
                list.remove(i);
            }
            iConfigurationElementArray = list.toArray(new IConfigurationElement[list.size()]);
        } else {
            iConfigurationElementArray = Constants.EMPTY_CONFIGELEM_ARRAY;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getConfigurationElements", iConfigurationElementArray.length);
        }
        return iConfigurationElementArray;
    }

    public IExtension getExtension(String string) {
        IExtension iExtension;
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getExtension", new Object[]{string});
        }
        if ((iExtension = this.getRealObject().getExtension(string)) != null && !this._filter.isGood(iExtension)) {
            iExtension = null;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getExtension", (Object)iExtension.getUniqueIdentifier());
        }
        return iExtension;
    }

    public IExtension[] getExtensions() {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getExtensions");
        }
        IExtension[] iExtensionArray = this._filter.doFilter(this.getRealObject().getExtensions());
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getExtensions", iExtensionArray.length);
        }
        return iExtensionArray;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return this._xpt.getDeclaringPluginDescriptor();
    }

    public String getNamespace() {
        return this._xpt.getNamespace();
    }

    public String getLabel() {
        return this._xpt.getLabel();
    }

    public String getSchemaReference() {
        return this._xpt.getSchemaReference();
    }

    public String getSimpleIdentifier() {
        return this._xpt.getSimpleIdentifier();
    }

    public String getUniqueIdentifier() {
        return this._xpt.getUniqueIdentifier();
    }

    public boolean isValid() {
        return this._xpt.isValid();
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this._xpt.getNamespaceIdentifier();
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return this._xpt.getContributor();
    }

    public boolean isLoaded() {
        return this._xpt.isLoaded();
    }

    public boolean isResolved() {
        return this._xpt.isResolved();
    }

    public void setResolved(boolean bl) {
        this._xpt.setResolved(bl);
    }

    public boolean isPlaceHolder() {
        return this._xpt.isPlaceHolder();
    }

    public String getVersion() {
        return this._xpt.getVersion();
    }

    public ExtensionPointProxy getProxyObject() {
        return this._xpt;
    }
}

