/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.DumpHelper;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.ExtensionRegistryFactory;
import com.ibm.wkplc.extensionregistry.FilterInvoker;
import com.ibm.wkplc.extensionregistry.FilteredExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.IModifiableRegistry;
import com.ibm.wkplc.extensionregistry.IRegistryTool;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeListener;

public class FilteredExtensionRegistry
implements IModifiableRegistry,
IRegistryTool,
Serializable {
    protected static final Logger s_logger = LoggerFactory.getLogger(FilteredExtensionRegistry.class);
    private transient ExtensionRegistry _registry = null;
    private transient FilterInvoker _filter = null;
    private String _name = null;

    FilteredExtensionRegistry(ExtensionRegistry extensionRegistry, String string) {
        try {
            Assert.it(extensionRegistry != null, "null registry");
            Assert.it(string != null, "null name");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException(assert_.getMessage());
        }
        this._registry = extensionRegistry;
        this._name = string;
        this._filter = new FilterInvoker(extensionRegistry, string);
    }

    public String getName() {
        return this._name;
    }

    private boolean checkFilterOnExtension(String string) {
        return string != null ? this.checkFilterOnExtension(this._registry.getExtension(string)) : false;
    }

    private boolean checkFilterOnExtension(IExtension iExtension) {
        return iExtension != null ? this._filter.isGood(iExtension) : false;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string) {
        List list = this.getFilteredConfigurationElementList(this._registry.getConfigurationElementsFor(string));
        return list.toArray(new IConfigurationElement[list.size()]);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2) {
        List list = this.getFilteredConfigurationElementList(this._registry.getConfigurationElementsFor(string, string2));
        return list.toArray(new IConfigurationElement[list.size()]);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2, String string3) {
        if (this.checkFilterOnExtension(string3)) {
            List list = this.getFilteredConfigurationElementList(this._registry.getConfigurationElementsFor(string, string2, string3));
            return list.toArray(new IConfigurationElement[list.size()]);
        }
        return Constants.EMPTY_CONFIGELEM_ARRAY;
    }

    public IExtension getExtension(String string) {
        IExtension iExtension = this._registry.getExtension(string);
        return this.checkFilterOnExtension(iExtension) ? iExtension : null;
    }

    public IExtension getExtension(String string, String string2) {
        IExtension iExtension = this._registry.getExtension(string, string2);
        return this.checkFilterOnExtension(iExtension) ? iExtension : null;
    }

    public IExtension getExtension(String string, String string2, String string3) {
        IExtension iExtension = this._registry.getExtension(string, string2, string3);
        return this.checkFilterOnExtension(iExtension) ? iExtension : null;
    }

    public IExtensionPoint getExtensionPoint(String string) {
        ExtensionPointProxy extensionPointProxy = (ExtensionPointProxy)this._registry.getExtensionPoint(string);
        return this.convertExtensionPointProxy(extensionPointProxy);
    }

    public IExtensionPoint getExtensionPoint(String string, String string2) {
        ExtensionPointProxy extensionPointProxy = (ExtensionPointProxy)this._registry.getExtensionPoint(string, string2);
        return this.convertExtensionPointProxy(extensionPointProxy);
    }

    public IExtensionPoint[] getExtensionPoints() {
        IExtensionPointProxy[] iExtensionPointProxyArray = (IExtensionPointProxy[])this._registry.getExtensionPoints();
        ArrayList<IExtensionPointProxy> arrayList = new ArrayList<IExtensionPointProxy>();
        for (int i = 0; i < iExtensionPointProxyArray.length; ++i) {
            arrayList.add(this.convertExtensionPointProxy(iExtensionPointProxyArray[i].getProxyObject()));
        }
        return arrayList.toArray(new IExtensionPointProxy[arrayList.size()]);
    }

    public IExtensionPoint[] getExtensionPoints(String string) {
        ExtensionPointProxy[] extensionPointProxyArray = (ExtensionPointProxy[])this._registry.getExtensionPoints(string);
        ArrayList<IExtensionPointProxy> arrayList = new ArrayList<IExtensionPointProxy>();
        for (int i = 0; i < extensionPointProxyArray.length; ++i) {
            arrayList.add(this.convertExtensionPointProxy(extensionPointProxyArray[i]));
        }
        return arrayList.isEmpty() ? Constants.EMPTY_EXTENSIONPOINT_ARRAY : arrayList.toArray(new IExtensionPointProxy[arrayList.size()]);
    }

    public IExtension[] getExtensions(String string) {
        IExtension[] iExtensionArray = this._registry.getExtensions(string);
        return string.equals("org.eclipse.extensionregistry.RegistryFilter") ? iExtensionArray : this._filter.doFilter(iExtensionArray);
    }

    public String[] getNamespaces() {
        return this._registry.getNamespaces();
    }

    public void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener, String string) {
        this._registry.addRegistryChangeListener(iRegistryChangeListener, string);
    }

    public void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        this._registry.addRegistryChangeListener(iRegistryChangeListener);
    }

    public void removeRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        this._registry.removeRegistryChangeListener(iRegistryChangeListener);
    }

    public boolean addContribution(InputStream inputStream, IContributor iContributor, boolean bl, String string, ResourceBundle resourceBundle, Object object) throws IllegalArgumentException {
        return this._registry.addContribution(inputStream, iContributor, bl, string, resourceBundle, object);
    }

    public boolean removeExtension(IExtension iExtension, Object object) {
        return this._registry.removeExtension(iExtension, object);
    }

    public boolean removeExtensionPoint(IExtensionPoint iExtensionPoint, Object object) {
        return this._registry.removeExtensionPoint(iExtensionPoint, object);
    }

    public void stop(Object object) {
        this._registry.stop(object);
    }

    private IExtensionPointProxy convertExtensionPointProxy(ExtensionPointProxy extensionPointProxy) {
        if (extensionPointProxy == null) {
            return null;
        }
        String string = extensionPointProxy.getUniqueIdentifier();
        if (string.equals("org.eclipse.extensionregistry.RegistryFilter")) {
            return extensionPointProxy;
        }
        return new FilteredExtensionPointProxy(extensionPointProxy, this._filter);
    }

    private List getFilteredConfigurationElementList(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            IExtension iExtension = iConfigurationElementArray[i].getDeclaringExtension();
            if (iExtension == null || !this.checkFilterOnExtension(iExtension)) continue;
            arrayList.add(iConfigurationElementArray[i]);
        }
        return arrayList;
    }

    public void load(ClassLoader classLoader) {
        this._registry.load(classLoader);
    }

    public void unload(ClassLoader classLoader) {
        this._registry.unload(classLoader);
    }

    public void addPlugin(PluginDescriptor pluginDescriptor) {
        this._registry.addPlugin(pluginDescriptor);
    }

    public void addPlugin(PluginDescriptor pluginDescriptor, boolean bl) {
        this._registry.addPlugin(pluginDescriptor, bl);
    }

    public void removePlugin(String string, String string2) {
        this._registry.removePlugin(string, string2);
    }

    public void removePlugin(String string, String string2, boolean bl) {
        this._registry.removePlugin(string, string2, bl);
    }

    public PluginDescriptorProxy getPlugin(String string) {
        return this._registry.getPlugin(string);
    }

    public String dumpAll() {
        DumpHelper dumpHelper = new DumpHelper();
        dumpHelper.addHeader();
        String[] stringArray = this.getNamespaces();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.add(stringArray[i]);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PluginDescriptorProxy pluginDescriptorProxy = this.getPlugin(string);
            if (pluginDescriptorProxy == null) continue;
            dumpHelper.addPlugin(pluginDescriptorProxy);
            ExtensionProxy[] extensionProxyArray = (ExtensionProxy[])pluginDescriptorProxy.getExtensions();
            if (extensionProxyArray != null && 0 < extensionProxyArray.length) {
                dumpHelper.addExtensions(extensionProxyArray);
            } else {
                dumpHelper.addNoExtensionsInPlugin();
            }
            IExtensionPointProxy[] iExtensionPointProxyArray = (IExtensionPointProxy[])this.getExtensionPoints(string);
            if (iExtensionPointProxyArray != null && 0 < iExtensionPointProxyArray.length) {
                dumpHelper.addExtensionPoints(iExtensionPointProxyArray);
                continue;
            }
            dumpHelper.addNoExtensionPointsInPlugin();
        }
        dumpHelper.addFooter();
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(dumpHelper.getResult());
        }
        return dumpHelper.getResult();
    }

    public String getContentXml() throws CoreException {
        return this._registry.getContentXml();
    }

    public void shutdown() {
        this._registry.shutdown();
    }

    public void enableResolving() {
        this._registry.enableResolving();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._name = objectInputStream.readUTF();
        this._registry = (ExtensionRegistry)ExtensionRegistryFactory.INSTANCE.getExtensionRegistry();
        this._filter = new FilterInvoker(this._registry, this._name);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this._name);
    }
}

