/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Constants;
import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.OffloadablePluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginPrerequisite;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.ResourceHelper;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginDescriptor
extends OffloadablePluginModelObject
implements IPluginDescriptor,
Serializable {
    private static final Logger s_logger = LoggerFactory.getLogger(PluginDescriptor.class);
    public static final String DOM_TAG_NAME = "plugin-descriptor";
    private String _uniqueId = null;
    private String _providerName = null;
    private String _className = null;
    private HashMap _extensions = new HashMap();
    private HashMap _extensionPoints = new HashMap();
    private PluginPrerequisite[] _requires = null;
    private URL _url = null;
    private transient Stack _classLoaderList = null;
    private Class _class = null;
    private boolean _active = false;
    private Properties _translations = null;

    public IExtension getExtension(String string) {
        return string != null ? (IExtension)this._extensions.get(string) : null;
    }

    public IExtensionPoint getExtensionPoint(String string) {
        return string != null ? (IExtensionPoint)this._extensionPoints.get(string) : null;
    }

    public IExtensionPoint[] getExtensionPoints() {
        int n = this._extensionPoints.size();
        if (0 < n) {
            return this._extensionPoints.values().toArray(new ExtensionPointProxy[n]);
        }
        return Constants.EMPTY_EXTENSIONPOINT_ARRAY;
    }

    Iterator getExtensionPointsInternal() {
        return this._extensionPoints.values().iterator();
    }

    public IExtension[] getExtensions() {
        int n = this._extensions.size();
        if (0 < n) {
            return this._extensions.values().toArray(new ExtensionProxy[n]);
        }
        return Constants.EMPTY_EXTENSION_ARRAY;
    }

    Iterator getExtensionsInternal() {
        return this._extensions.values().iterator();
    }

    public URL getInstallURL() {
        return this._url;
    }

    public String getLabel() {
        return this.getLabel(this, s_logger);
    }

    public Stack getPluginClassLoaders() {
        return this._classLoaderList;
    }

    public ClassLoader getPluginClassLoader() {
        if (this._classLoaderList == null || this._classLoaderList.isEmpty()) {
            return null;
        }
        return (ClassLoader)this._classLoaderList.peek();
    }

    public IPluginPrerequisite[] getPluginResolvedPrerequisites() {
        PluginPrerequisite[] pluginPrerequisiteArray = this.getRequires();
        if (pluginPrerequisiteArray == null || pluginPrerequisiteArray.length == 0) {
            return Constants.EMPTY_PLUGINPREREQ_ARRAY;
        }
        ArrayList<PluginPrerequisite> arrayList = new ArrayList<PluginPrerequisite>(pluginPrerequisiteArray.length);
        for (int i = 0; i < pluginPrerequisiteArray.length; ++i) {
            if (pluginPrerequisiteArray[i].getResolvedVersion() == null) continue;
            arrayList.add(pluginPrerequisiteArray[i]);
        }
        if (arrayList.isEmpty()) {
            return Constants.EMPTY_PLUGINPREREQ_ARRAY;
        }
        return arrayList.toArray(new IPluginPrerequisite[arrayList.size()]);
    }

    public String getProviderName() {
        return this._providerName;
    }

    public String getUniqueIdentifier() {
        return this._uniqueId;
    }

    public boolean isPluginActivated() {
        return this._active;
    }

    public void markActive() {
        this._active = true;
    }

    public void markInactive() {
        this._active = false;
    }

    public boolean isActive() {
        return this._active;
    }

    void setProviderName(String string) {
        this._providerName = string;
        this.setDirty(true);
    }

    void setUniqueIdentifier(String string) {
        this._uniqueId = string;
        this.setDirty(true);
    }

    void setExtensionPoints(Collection collection) {
        this._extensionPoints.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ExtensionPoint extensionPoint = (ExtensionPoint)iterator.next();
                if (extensionPoint.getSimpleIdentifier().indexOf(46) == -1) {
                    this._extensionPoints.put(extensionPoint.getSimpleIdentifier(), extensionPoint);
                    continue;
                }
                if (!s_logger.isTraceEnabled()) continue;
                s_logger.warn("warn.invalid_char_in_id_2", "Create", new Object[]{this.getUniqueIdentifier(), extensionPoint.getSimpleIdentifier()});
            }
        }
        this.setDirty(true);
    }

    void setExtensions(Collection collection) {
        this._extensions.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Extension extension2 = (Extension)iterator.next();
                if (extension2.getSimpleIdentifier().indexOf(46) == -1) {
                    this._extensions.put(extension2.getSimpleIdentifier(), extension2);
                    continue;
                }
                if (!s_logger.isTraceEnabled()) continue;
                s_logger.warn("warn.invalid_char_in_id_2", "Create", new Object[]{this.getUniqueIdentifier(), extension2.getSimpleIdentifier()});
            }
        }
        this.setDirty(true);
    }

    void convertObjectsToProxies() {
        Object v;
        String string;
        Iterator iterator;
        if (!this._extensions.isEmpty()) {
            iterator = this._extensions.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                v = this._extensions.get(string);
                if (v instanceof Extension) {
                    this._extensions.put(string, RegistryCache.INSTANCE.putExtension((Extension)v));
                    continue;
                }
                Assert.it(v instanceof ExtensionProxy, "_extensions contains Object that is neither Extension or ExtensionProxy");
            }
        }
        if (!this._extensionPoints.isEmpty()) {
            iterator = this._extensionPoints.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                v = this._extensionPoints.get(string);
                if (v instanceof ExtensionPoint) {
                    this._extensionPoints.put(string, RegistryCache.INSTANCE.putExtensionPoint((ExtensionPoint)v));
                    continue;
                }
                Assert.it(v instanceof ExtensionPointProxy, "_extensionPoints contains Object that is neither ExtensionPoint or ExtensionPointProxy");
            }
        }
    }

    void setRequires(PluginPrerequisite[] pluginPrerequisiteArray) {
        this._requires = pluginPrerequisiteArray != null ? pluginPrerequisiteArray : Constants.EMPTY_PLUGINPREREQ_ARRAY;
        this.setDirty(true);
    }

    public PluginPrerequisite[] getRequires() {
        return this._requires;
    }

    public IPluginPrerequisite[] getPluginPrerequisites() {
        IPluginPrerequisite[] iPluginPrerequisiteArray = this.getRequires();
        if (iPluginPrerequisiteArray == null) {
            return Constants.EMPTY_PLUGINPREREQ_ARRAY;
        }
        return iPluginPrerequisiteArray;
    }

    void setInstallURL(URL uRL) {
        this._url = uRL;
        this.setDirty(true);
    }

    void setPluginClassLoader(ClassLoader classLoader) {
        if (this._classLoaderList == null) {
            this._classLoaderList = new Stack();
        }
        if (classLoader != null) {
            this._classLoaderList.push(classLoader);
        }
    }

    void setPluginClass(Class clazz) {
        this._class = clazz;
    }

    void setPluginClassName(String string) {
        this._className = string;
    }

    public String toString() {
        return "PluginDescriptor: '" + this.getUniqueIdentifier() + "' [" + this.getVersion() + "]";
    }

    public boolean equals(Object object) {
        boolean bl;
        block6: {
            PluginDescriptor pluginDescriptor;
            block12: {
                ExtensionPointProxy[] extensionPointProxyArray;
                int n;
                block11: {
                    block10: {
                        block9: {
                            ExtensionProxy[] extensionProxyArray;
                            block8: {
                                block7: {
                                    bl = false;
                                    if (!(object instanceof PluginDescriptor) || !this._uniqueId.equals((pluginDescriptor = (PluginDescriptor)object).getUniqueIdentifier()) || !this.getVersion().equals(pluginDescriptor.getVersion()) || this._providerName != null && !this._providerName.equals(pluginDescriptor.getProviderName()) || this._providerName == null && pluginDescriptor.getProviderName() != null) break block6;
                                    extensionProxyArray = (ExtensionProxy[])pluginDescriptor.getExtensions();
                                    if (this._extensions != null) break block7;
                                    if (extensionProxyArray == null || 0 >= extensionProxyArray.length) break block8;
                                    break block6;
                                }
                                if (extensionProxyArray != null ? this._extensions.size() != extensionProxyArray.length : 0 < this._extensions.size()) break block6;
                            }
                            if (this._extensions == null || extensionProxyArray == null) break block9;
                            for (n = 0; n < extensionProxyArray.length && this._extensions.containsValue(extensionProxyArray[n]); ++n) {
                            }
                            if (n < extensionProxyArray.length) break block6;
                        }
                        extensionPointProxyArray = (ExtensionPointProxy[])pluginDescriptor.getExtensionPoints();
                        if (this._extensionPoints != null) break block10;
                        if (extensionPointProxyArray == null || 0 >= extensionPointProxyArray.length) break block11;
                        break block6;
                    }
                    if (extensionPointProxyArray != null ? this._extensionPoints.size() != extensionPointProxyArray.length : 0 < this._extensionPoints.size()) break block6;
                }
                if (this._extensionPoints == null || extensionPointProxyArray == null) break block12;
                for (n = 0; n < extensionPointProxyArray.length && this._extensionPoints.containsValue(extensionPointProxyArray[n]); ++n) {
                }
                if (n < extensionPointProxyArray.length) break block6;
            }
            if (!(this._url != null && !this._url.equals(pluginDescriptor.getInstallURL()) || this._url == null && pluginDescriptor.getInstallURL() != null || this._active != pluginDescriptor.isActive())) {
                bl = true;
            }
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        int n;
        String string2;
        int n2;
        String string3 = objectInputStream.readUTF();
        this._uniqueId = string3.equals("null") ? null : string3;
        string3 = objectInputStream.readUTF();
        this.setVersion(string3.equals("null") ? null : string3);
        string3 = objectInputStream.readUTF();
        this._providerName = string3.equals("null") ? null : string3;
        string3 = objectInputStream.readUTF();
        this._className = string3.equals("null") ? null : string3;
        this._extensions = new HashMap();
        int n3 = objectInputStream.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            String string4 = objectInputStream.readUTF();
            string2 = objectInputStream.readUTF();
            this._extensions.put(string4, RegistryCache.INSTANCE.getExtensionProxy(string4, string2));
        }
        this._extensionPoints = new HashMap();
        n2 = objectInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string2 = objectInputStream.readUTF();
            String string5 = objectInputStream.readUTF();
            this._extensionPoints.put(string2, RegistryCache.INSTANCE.getExtensionPointProxy(string2, string5));
        }
        n = objectInputStream.readInt();
        if (0 < n) {
            this._requires = new PluginPrerequisite[n];
            for (int i = 0; i < n; ++i) {
                this._requires[i] = (PluginPrerequisite)objectInputStream.readObject();
            }
        } else {
            this._requires = null;
        }
        this._url = (string = (String)objectInputStream.readObject()).equals("null") ? null : new URL(string);
        this._active = objectInputStream.readBoolean();
        this.setDirty(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RegistryObjectProxy registryObjectProxy;
        String string;
        Iterator iterator;
        int n;
        objectOutputStream.writeUTF(this._uniqueId != null ? this._uniqueId : "null");
        objectOutputStream.writeUTF(this.getVersion() != null ? this.getVersion() : "null");
        objectOutputStream.writeUTF(this._providerName != null ? this._providerName : "null");
        objectOutputStream.writeUTF(this._className != null ? this._className : "null");
        if (this._extensions != null) {
            n = this._extensions.size();
            objectOutputStream.writeInt(n);
            if (0 < n) {
                iterator = this._extensions.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    registryObjectProxy = (ExtensionProxy)this._extensions.get(string);
                    objectOutputStream.writeUTF(registryObjectProxy.getUniqueIdentifier());
                    objectOutputStream.writeUTF(registryObjectProxy.getVersion());
                }
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        if (this._extensionPoints != null) {
            n = this._extensionPoints.size();
            objectOutputStream.writeInt(n);
            if (0 < n) {
                iterator = this._extensionPoints.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    registryObjectProxy = (ExtensionPointProxy)this._extensionPoints.get(string);
                    objectOutputStream.writeUTF(registryObjectProxy.getUniqueIdentifier());
                    objectOutputStream.writeUTF(registryObjectProxy.getVersion());
                }
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        if (this._requires != null) {
            n = this._requires.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeObject(this._requires[i]);
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        objectOutputStream.writeObject(this._url != null ? this._url.toExternalForm() : "null");
        objectOutputStream.writeBoolean(this._active);
        this.setDirty(false);
    }

    public String getRootElementName() {
        return DOM_TAG_NAME;
    }

    public void initFromDom(Element element) {
        Object object;
        Node node;
        Object object2;
        Object object3;
        super.initFromDom(element);
        this._uniqueId = this.readTextFromDomElement(element, "unique-id");
        this._providerName = this.readTextFromDomElement(element, "provider-name");
        this.readExtensionsFromDomElement(element, this._extensions, this._uniqueId + ".");
        NodeList nodeList = element.getElementsByTagName("extension-points");
        Node node2 = nodeList.item(0);
        if (node2 != null && node2.hasChildNodes()) {
            object3 = node2.getChildNodes();
            for (int i = 0; i < object3.getLength(); ++i) {
                object2 = object3.item(i);
                NamedNodeMap namedNodeMap = object2.getAttributes();
                if (namedNodeMap == null) continue;
                node = namedNodeMap.getNamedItem("id");
                object = namedNodeMap.getNamedItem("version");
                if (node == null || object == null) continue;
                String string = node.getNodeValue();
                StringBuffer stringBuffer = new StringBuffer(this._uniqueId);
                stringBuffer.append(".");
                stringBuffer.append(string);
                this._extensionPoints.put(string, RegistryCache.INSTANCE.getExtensionPointProxy(stringBuffer.toString(), object.getNodeValue()));
            }
        }
        try {
            this._url = new URL(this.readTextFromDomElement(element, "install-url"));
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException(malformedURLException, this.getClass().toString() + ".initFromDom", "1");
        }
        nodeList = element.getElementsByTagName("requires");
        object3 = nodeList.item(0);
        if (object3 != null && object3.hasChildNodes()) {
            NodeList nodeList2 = object3.getChildNodes();
            object2 = new ArrayList();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                node = nodeList2.item(i);
                if (!node.getNodeName().equals("prerequisite")) continue;
                object = new PluginPrerequisite();
                ((PluginPrerequisite)object).initFromDom((Element)node);
                object2.add(object);
            }
            if (0 < object2.size()) {
                this._requires = object2.toArray(new PluginPrerequisite[object2.size()]);
            }
        }
        this.setDirty(false);
    }

    public void toXml(Element element) {
        Object object;
        super.toXml(element);
        Document document = element.getOwnerDocument();
        element.appendChild(this.getDomElementForText(document, "unique-id", this._uniqueId));
        element.appendChild(this.getDomElementForText(document, "provider-name", this._providerName));
        element.appendChild(this.getDomElementForExtensions(document, this._extensions));
        Element element2 = document.createElement("extension-points");
        Object object2 = this._extensionPoints.keySet().iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            object = (ExtensionPointProxy)this._extensionPoints.get(string);
            Element element3 = document.createElement("extension-point");
            element3.setAttribute("id", string);
            element3.setAttribute("version", ((RegistryObjectProxy)object).getVersion());
            element2.appendChild(element3);
        }
        element.appendChild(element2);
        element.appendChild(this.getDomElementForText(document, "install-url", this._url.toExternalForm()));
        object2 = document.createElement("requires");
        if (this._requires != null) {
            for (int i = 0; i < this._requires.length; ++i) {
                object = document.createElement("prerequisite");
                this._requires[i].toXml((Element)object);
                object2.appendChild((Node)object);
            }
        }
        element.appendChild((Node)object2);
    }

    public Plugin getPlugin() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        return ResourceHelper.getBundle(this);
    }

    public String getResourceString(String string) {
        if (string == null) {
            return null;
        }
        if (this._translations != null) {
            String string2 = string.startsWith("%") ? string.substring(1) : string;
            String string3 = this._translations.getProperty(string2);
            return string3 != null ? string3 : string;
        }
        return this.getResourceString(string, this.getResourceBundle());
    }

    public String getResourceString(String string, ResourceBundle resourceBundle) {
        if (string == null) {
            return null;
        }
        if (resourceBundle != null) {
            String string2;
            block4: {
                string2 = string;
                try {
                    String string3 = string.startsWith("%") ? string.substring(1) : string;
                    string2 = resourceBundle.getString(string3);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!s_logger.isErrorEnabled()) break block4;
                    s_logger.error("err.no_translation_found_2", "Other", new Object[]{string, this.getUniqueIdentifier()});
                }
            }
            return string2;
        }
        return string;
    }

    void setTranslations(Properties properties) {
        this._translations = properties;
    }

    public ILibrary[] getRuntimeLibraries() {
        throw new UnsupportedOperationException();
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        try {
            return new PluginVersionIdentifier(this.getVersion());
        }
        catch (Exception exception) {
            return new PluginVersionIdentifier("1.0.0");
        }
    }

    public URL find(IPath iPath) {
        throw new UnsupportedOperationException();
    }

    public URL find(IPath iPath, Map map) {
        throw new UnsupportedOperationException();
    }
}

