/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginPrerequisite;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class PluginDescriptorProxy
extends RegistryObjectProxy
implements IPluginDescriptor,
Serializable {
    private static final Logger s_logger = LoggerFactory.getLogger(PluginDescriptorProxy.class);
    private Stack _classLoaderList = null;

    public PluginDescriptorProxy(String string, String string2) {
        super(string, string2);
    }

    private PluginDescriptor getRealObject() {
        return RegistryCache.INSTANCE.getRealPluginDescriptor(this);
    }

    PluginPrerequisite[] getRequires() {
        return this.getRealObject().getRequires();
    }

    void markActive() {
        this.getRealObject().markActive();
        this.setResolved(true);
    }

    void markInactive() {
        this.getRealObject().markInactive();
        this.setResolved(false);
    }

    boolean isActive() {
        return this.getRealObject().isActive();
    }

    void setPluginClassLoader(ClassLoader classLoader) {
        if (this._classLoaderList == null) {
            this._classLoaderList = new Stack();
        }
        if (classLoader != null) {
            this._classLoaderList.push(classLoader);
        }
    }

    boolean hasClassLoader() {
        return this._classLoaderList != null && !this._classLoaderList.isEmpty();
    }

    void removeClassLoader(ClassLoader classLoader) {
        if (this._classLoaderList != null && classLoader != null) {
            this._classLoaderList.remove(classLoader);
        }
    }

    int numClassLoaders() {
        if (this._classLoaderList == null) {
            return 0;
        }
        return this._classLoaderList.size();
    }

    public String getNamespace() {
        return this.getUniqueIdentifier();
    }

    String getPrefix() {
        return "plg___";
    }

    public IExtension getExtension(String string) {
        return this.getRealObject().getExtension(string);
    }

    public IExtension[] getExtensions() {
        return this.getRealObject().getExtensions();
    }

    public IExtensionPoint getExtensionPoint(String string) {
        return this.getRealObject().getExtensionPoint(string);
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.getRealObject().getExtensionPoints();
    }

    public URL getInstallURL() {
        return this.getRealObject().getInstallURL();
    }

    public String getLabel() {
        return this.getRealObject().getLabel();
    }

    public ClassLoader getPluginClassLoader() {
        if (this._classLoaderList == null || this._classLoaderList.isEmpty()) {
            return null;
        }
        return (ClassLoader)this._classLoaderList.peek();
    }

    public Stack getPluginClassLoaders() {
        return this._classLoaderList;
    }

    public IPluginPrerequisite[] getPluginPrerequisites() {
        return this.getRealObject().getPluginPrerequisites();
    }

    public String getProviderName() {
        return this.getRealObject().getProviderName();
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        return this.getRealObject().getResourceBundle();
    }

    public String getResourceString(String string) {
        return this.getRealObject().getResourceString(string);
    }

    public String getResourceString(String string, ResourceBundle resourceBundle) {
        return this.getRealObject().getResourceString(string, resourceBundle);
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        try {
            return new PluginVersionIdentifier(this.getVersion());
        }
        catch (Exception exception) {
            return new PluginVersionIdentifier("1.0.0");
        }
    }

    public boolean isPluginActivated() {
        return this.getRealObject().isPluginActivated();
    }

    public Plugin getPlugin() throws CoreException {
        return this.getRealObject().getPlugin();
    }

    public ILibrary[] getRuntimeLibraries() {
        return this.getRealObject().getRuntimeLibraries();
    }

    public URL find(IPath iPath) {
        return this.getRealObject().find(iPath);
    }

    public URL find(IPath iPath, Map map) {
        return this.getRealObject().find(iPath, map);
    }

    public String toString() {
        return "PluginDescriptorProxy: '" + this.getUniqueIdentifier() + "' [" + this.getVersion() + "]";
    }
}

