/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.ConfigurationElement;
import com.ibm.wkplc.extensionregistry.ConfigurationProperty;
import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginPrerequisite;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler {
    private static final Logger s_logger = LoggerFactory.getLogger(PluginParser.class);
    private static final String PLUGIN_DTD = "com.ibm.workplace.extension.schema.plugin.dtd";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_REQUIRES_STATE = 3;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 4;
    private static final int PLUGIN_EXTENSION_STATE = 5;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 7;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private String _locationName;
    private Stack _stateStack;
    private Stack _objectStack;
    private static SAXParser _saxParser;
    private static XMLReader _xmlReader;
    private Locator _locator;
    private Vector[] _scratchVectors;
    private int _autoGenId;

    public PluginParser() {
        block4: {
            this._locationName = null;
            this._stateStack = new Stack();
            this._objectStack = new Stack();
            this._locator = null;
            this._scratchVectors = new Vector[2];
            this._autoGenId = 0;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(false);
                _saxParser = sAXParserFactory.newSAXParser();
                _xmlReader = _saxParser.getXMLReader();
                _xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                _xmlReader.setEntityResolver(this);
                _xmlReader.setContentHandler(this);
                _xmlReader.setDTDHandler(this);
                _xmlReader.setErrorHandler(this);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                FFDCFilter.processException(parserConfigurationException, this.getClass().toString() + ".<init>", "1");
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("<PluginParser><constructor> parser with specified options can't be built");
                    parserConfigurationException.printStackTrace();
                }
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException(sAXException, this.getClass().toString() + ".<init>", "2");
                if (!s_logger.isTraceDebugEnabled()) break block4;
                s_logger.traceDebug("<PluginParser><constructor> error generated during parser creation");
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = (Integer)this._stateStack.peek();
        if (n3 != 7) {
            return;
        }
        if (n3 == 7) {
            ConfigurationElement configurationElement = (ConfigurationElement)this._objectStack.peek();
            String string = new String(cArray, n, n2);
            String string2 = configurationElement.getValue();
            if (string2 == null) {
                if (string.trim().length() != 0) {
                    configurationElement.setValue(string);
                }
            } else {
                configurationElement.setValue(string2 + string);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String string, String string2, String string3) {
        switch ((Integer)this._stateStack.peek()) {
            case 0: {
                this._stateStack.pop();
                break;
            }
            case 1: {
                System.out.println("<PluginParser><endElement> internal stack structure error on element " + string3);
                break;
            }
            case 2: {
                Vector vector;
                if (!string3.equals("plugin")) break;
                this._stateStack.pop();
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
                Vector vector2 = this._scratchVectors[0];
                if (vector2.size() > 0) {
                    pluginDescriptor.setExtensionPoints(vector2);
                    this._scratchVectors[0].removeAllElements();
                }
                if ((vector = this._scratchVectors[1]).size() <= 0) break;
                pluginDescriptor.setExtensions(vector);
                this._scratchVectors[1].removeAllElements();
                break;
            }
            case 3: {
                if (!string3.equals("requires")) break;
                this._stateStack.pop();
                Vector vector = (Vector)this._objectStack.pop();
                if (vector.size() <= 0) break;
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
                pluginDescriptor.setRequires(vector.toArray(new PluginPrerequisite[vector.size()]));
                break;
            }
            case 4: {
                if (!string3.equals("extension-point")) break;
                this._stateStack.pop();
                break;
            }
            case 5: {
                Serializable serializable;
                if (!string3.equals("extension")) break;
                this._stateStack.pop();
                Extension extension2 = (Extension)this._objectStack.pop();
                if (extension2.getSimpleIdentifier() == null) {
                    serializable = new StringBuffer("ibmautogeneratedidentifier");
                    ((StringBuffer)serializable).append(Integer.toString(++this._autoGenId));
                    extension2.setSimpleId(((StringBuffer)serializable).toString());
                }
                serializable = (PluginDescriptor)this._objectStack.peek();
                extension2.setParentDescriptor((PluginDescriptor)serializable);
                this._scratchVectors[1].addElement(extension2);
                break;
            }
            case 6: {
                if (!string3.equals("import")) break;
                this._stateStack.pop();
                break;
            }
            case 7: {
                this._stateStack.pop();
                ConfigurationElement configurationElement = (ConfigurationElement)this._objectStack.pop();
                String string4 = configurationElement.getValue();
                if (string4 != null) {
                    configurationElement.setValue(string4.trim());
                }
                Object e2 = this._objectStack.peek();
                configurationElement.setParent(e2);
                if ((Integer)this._stateStack.peek() == 5) {
                    ConfigurationElement[] configurationElementArray = ((Extension)e2).getElements();
                    int n = configurationElementArray == null ? 0 : configurationElementArray.length;
                    ConfigurationElement[] configurationElementArray2 = new ConfigurationElement[n + 1];
                    for (int i = 0; i < n; ++i) {
                        configurationElementArray2[i] = configurationElementArray[i];
                    }
                    configurationElementArray2[n] = configurationElement;
                    ((Extension)e2).setElements(configurationElementArray2);
                    break;
                }
                ConfigurationElement[] configurationElementArray = ((ConfigurationElement)e2).getSubElements();
                int n = configurationElementArray == null ? 0 : configurationElementArray.length;
                ConfigurationElement[] configurationElementArray3 = new ConfigurationElement[n + 1];
                for (int i = 0; i < n; ++i) {
                    configurationElementArray3[i] = configurationElementArray[i];
                }
                configurationElementArray3[n] = configurationElement;
                ((ConfigurationElement)e2).setSubElements(configurationElementArray3);
            }
        }
    }

    public void error(SAXParseException sAXParseException) {
        if (!sAXParseException.getMessage().startsWith("Element type") && !sAXParseException.getMessage().endsWith("must be declared") && s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("");
            s_logger.traceDebug("<PluginParser><error> error generated by parser");
            s_logger.traceDebug("<PluginParser><error> error at line " + sAXParseException.getLineNumber());
            s_logger.traceDebug("<PluginParser><error> for file at " + sAXParseException.getSystemId());
            s_logger.traceDebug("<PluginParser><error> error details: " + sAXParseException.getMessage());
            s_logger.traceDebug("");
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("");
            s_logger.traceDebug("<PluginParser><fatalError> error generated by parser");
            s_logger.traceDebug("<PluginParser><fatalError> error at line " + sAXParseException.getLineNumber());
            s_logger.traceDebug("<PluginParser><fatalError> for file at " + sAXParseException.getSystemId());
            s_logger.traceDebug("<PluginParser><fatalError> error details: " + sAXParseException.getMessage());
            s_logger.traceDebug("");
        }
    }

    public void handleExtensionPointState(String string, Attributes attributes2) {
        this._stateStack.push(new Integer(0));
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("<PluginParser><handleExtensionPointState>: ignored " + string);
        }
    }

    public void handleExtensionState(String string, Attributes attributes2) {
        this._stateStack.push(new Integer(7));
        ConfigurationElement configurationElement = new ConfigurationElement();
        this._objectStack.push(configurationElement);
        configurationElement.setName(string);
        this.parseConfigurationElementAttributes(attributes2);
    }

    public void handleInitialState(String string, Attributes attributes2) {
        if (string.equals("plugin")) {
            this._stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes2);
        } else {
            this._stateStack.push(new Integer(0));
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("<PluginParser><handleInitialState> unknown root element: " + string);
            }
        }
    }

    protected static String[] getArrayFromList(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? null : vector.toArray(new String[0]);
    }

    public void handlePluginState(String string, Attributes attributes2) {
        if (string.equals("requires")) {
            this._stateStack.push(new Integer(3));
            this._objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes2);
            return;
        }
        if (string.equals("extension-point")) {
            this._stateStack.push(new Integer(4));
            this.parseExtensionPointAttributes(attributes2);
            return;
        }
        if (string.equals("extension")) {
            this._stateStack.push(new Integer(5));
            this.parseExtensionAttributes(attributes2);
            return;
        }
        this._stateStack.push(new Integer(0));
    }

    public void handleRequiresImportState(String string, Attributes attributes2) {
        this._stateStack.push(new Integer(0));
    }

    public void handleRequiresState(String string, Attributes attributes2) {
        if (string.equals("import")) {
            this.parsePluginRequiresImport(attributes2);
            return;
        }
        this._stateStack.push(new Integer(0));
    }

    public void ignoreableWhitespace(char[] cArray, int n, int n2) {
    }

    public synchronized PluginDescriptor parsePlugin(InputSource inputSource) {
        PluginDescriptor pluginDescriptor;
        block7: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "parsePlugin", new Object[]{inputSource.getSystemId()});
            }
            pluginDescriptor = null;
            if (inputSource.getSystemId() != null) {
                this._locationName = inputSource.getSystemId();
            }
            try {
                _xmlReader.parse(inputSource);
                pluginDescriptor = (PluginDescriptor)this._objectStack.pop();
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException(sAXException, this.getClass().toString() + ".parsePlugin", "3");
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("<PluginParser><parsePlugin> error generated during parsing");
                    sAXException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.getClass().toString() + ".parsePlugin", "4");
                if (!s_logger.isTraceDebugEnabled()) break block7;
                s_logger.traceDebug("<PluginParser><parsePlugin> i/o error");
                iOException.printStackTrace();
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "parsePlugin");
        }
        return pluginDescriptor;
    }

    public void parseConfigurationElementAttributes(Attributes attributes2) {
        int n;
        ConfigurationElement configurationElement = (ConfigurationElement)this._objectStack.peek();
        configurationElement.setStartLine(this._locator.getLineNumber());
        Vector<ConfigurationProperty> vector = null;
        int n2 = n = attributes2 != null ? attributes2.getLength() : 0;
        if (n == 0) {
            return;
        }
        vector = new Vector<ConfigurationProperty>();
        for (int i = 0; i < n; ++i) {
            String string = attributes2.getQName(i);
            String string2 = attributes2.getValue(i);
            ConfigurationProperty configurationProperty = new ConfigurationProperty();
            configurationProperty.setName(string);
            configurationProperty.setValue(string2);
            vector.addElement(configurationProperty);
        }
        configurationElement.setProperties(vector.toArray(new ConfigurationProperty[vector.size()]));
        vector = null;
    }

    public void parseExtensionAttributes(Attributes attributes2) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
        Extension extension2 = new Extension();
        extension2.setStartLine(this._locator.getLineNumber());
        this._objectStack.push(extension2);
        int n = attributes2 != null ? attributes2.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes2.getQName(i);
            String string2 = attributes2.getValue(i).trim();
            if (string.equals("id")) {
                extension2.setSimpleId(string2);
                continue;
            }
            if (string.equals("point")) {
                String string3;
                if (string2.lastIndexOf(46) == -1) {
                    String string4 = pluginDescriptor.getUniqueIdentifier();
                    string3 = string4 + "." + string2;
                } else {
                    string3 = string2;
                }
                extension2.setExtensionPointUniqueId(string3);
                continue;
            }
            if (!string.equals("name")) continue;
            extension2.setName(string2);
        }
    }

    public void parseExtensionPointAttributes(Attributes attributes2) {
        ExtensionPoint extensionPoint = new ExtensionPoint();
        extensionPoint.setStartLine(this._locator.getLineNumber());
        int n = attributes2 != null ? attributes2.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes2.getQName(i);
            String string2 = attributes2.getValue(i).trim();
            if (string.equals("id")) {
                extensionPoint.setSimpleId(string2);
                continue;
            }
            if (string.equals("schema")) {
                extensionPoint.setSchema(string2);
                continue;
            }
            if (!string.equals("name")) continue;
            extensionPoint.setName(string2);
        }
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
        extensionPoint.setParentDescriptor(pluginDescriptor);
        this._scratchVectors[0].addElement(extensionPoint);
    }

    public void parsePluginAttributes(Attributes attributes2) {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setStartLine(this._locator.getLineNumber());
        this._objectStack.push(pluginDescriptor);
        int n = attributes2.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes2.getQName(i);
            String string2 = attributes2.getValue(i).trim();
            if (string.equals("id")) {
                pluginDescriptor.setUniqueIdentifier(string2);
                continue;
            }
            if (string.equals("version")) {
                pluginDescriptor.setVersion(string2);
                continue;
            }
            if (string.equals("provider-name")) {
                pluginDescriptor.setProviderName(string2);
                continue;
            }
            if (string.equals("name")) {
                pluginDescriptor.setName(string2);
                continue;
            }
            if (string.equals("class")) {
                pluginDescriptor.setPluginClassName(string2);
                continue;
            }
            System.out.println("<PluginParser><parsePluginAttributes> unknown attribute: " + string);
        }
    }

    public void parsePluginRequiresImport(Attributes attributes2) {
        PluginPrerequisite pluginPrerequisite = new PluginPrerequisite();
        pluginPrerequisite.setStartLine(this._locator.getLineNumber());
        int n = attributes2 != null ? attributes2.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes2.getQName(i);
            String string2 = attributes2.getValue(i).trim();
            if (string.equals("plugin")) {
                pluginPrerequisite.setUniqueIdentifier(string2);
                continue;
            }
            if (string.equals("version")) {
                pluginPrerequisite.setVersion(string2);
                continue;
            }
            if (!string.equals("match")) continue;
            if ("exact".equals(string2)) {
                pluginPrerequisite.setMatch("exact");
                continue;
            }
            if ("compatible".equals(string2)) {
                pluginPrerequisite.setMatch("compatible");
                continue;
            }
            if (!"greaterOrEqual".equals(string2)) continue;
            pluginPrerequisite.setMatch("greaterOrEqual");
        }
        ((Vector)this._objectStack.peek()).addElement(pluginPrerequisite);
    }

    public void parseRequiresAttributes(Attributes attributes2) {
    }

    static String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string2.length();
        int n2 = string3.length();
        int n3 = string4.indexOf(string2);
        while (n3 != -1) {
            string4 = string4.substring(0, n3) + string3 + string4.substring(n3 + n);
            n3 = string4.indexOf(string2, n3 + n2);
        }
        return string4;
    }

    public void startDocument() {
        this._stateStack.push(new Integer(1));
        for (int i = 0; i <= 1; ++i) {
            this._scratchVectors[i] = new Vector();
        }
        this._autoGenId = 0;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) {
        switch ((Integer)this._stateStack.peek()) {
            case 1: {
                this.handleInitialState(string3, attributes2);
                break;
            }
            case 2: {
                this.handlePluginState(string3, attributes2);
                break;
            }
            case 3: {
                this.handleRequiresState(string3, attributes2);
                break;
            }
            case 4: {
                this.handleExtensionPointState(string3, attributes2);
                break;
            }
            case 5: 
            case 7: {
                this.handleExtensionState(string3, attributes2);
                break;
            }
            case 6: {
                this.handleRequiresImportState(string3, attributes2);
                break;
            }
            default: {
                this._stateStack.push(new Integer(0));
            }
        }
    }

    public void warning(SAXParseException sAXParseException) {
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (string2 == null) {
            return null;
        }
        string2 = PLUGIN_DTD;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = null;
        inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
        return inputStream != null ? new InputSource(inputStream) : null;
    }

    public void releaseParser() {
        _saxParser = null;
    }
}

