/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.DumpHelper;
import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import com.ibm.wkplc.extensionregistry.util.XmlUtil;
import com.ibm.wkplc.extensionregistry.util.XmlUtilException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PluginVersionTracker {
    private static final Logger s_logger = LoggerFactory.getLogger(PluginVersionTracker.class);
    private ExtensionRegistry _registry = null;
    private Map _plugins = new HashMap();

    PluginVersionTracker(ExtensionRegistry extensionRegistry) {
        this._registry = extensionRegistry;
    }

    boolean addPlugin(PluginDescriptorProxy pluginDescriptorProxy) {
        List list;
        boolean bl = false;
        String string = pluginDescriptorProxy.getUniqueIdentifier();
        boolean bl2 = true;
        if (this._plugins.containsKey(string)) {
            bl2 = false;
            this.addProxyVersion((List)this._plugins.get(string), pluginDescriptorProxy);
        } else {
            list = new ArrayList<PluginDescriptorProxy>();
            list.add(pluginDescriptorProxy);
            this._plugins.put(string, list);
        }
        list = (List)this._plugins.get(string);
        PluginDescriptorProxy pluginDescriptorProxy2 = (PluginDescriptorProxy)list.get(0);
        if (pluginDescriptorProxy2.equals(pluginDescriptorProxy) && !pluginDescriptorProxy.getVersion().equals("0.0.0")) {
            bl = true;
        }
        PluginDescriptorProxy pluginDescriptorProxy3 = null;
        if (1 < list.size()) {
            pluginDescriptorProxy3 = (PluginDescriptorProxy)list.get(1);
        } else if (!bl2) {
            pluginDescriptorProxy3 = pluginDescriptorProxy2;
        }
        if (bl && pluginDescriptorProxy3 != null) {
            this._registry.removePlugin(string, pluginDescriptorProxy3.getVersion(), false);
        }
        return bl;
    }

    private void addProxyVersion(List list, RegistryObjectProxy registryObjectProxy) {
        String string = registryObjectProxy.getVersion();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = ((RegistryObjectProxy)list.get(i)).getVersion();
            int n = PluginVersionTracker.compareVersionStrings(string, string2);
            if (n == 1) {
                list.add(i, registryObjectProxy);
                bl = true;
                break;
            }
            if (n != 0) continue;
            Assert.it(registryObjectProxy == list.get(i), "Different Proxy instances for the same ID/version");
            break;
        }
        if (!bl && PluginVersionTracker.compareVersionStrings(string, ((RegistryObjectProxy)list.get(list.size() - 1)).getVersion()) == -1) {
            list.add(registryObjectProxy);
        }
    }

    boolean removePlugin(String string, String string2) {
        boolean bl = false;
        List list = (List)this._plugins.get(string);
        try {
            Assert.it(list != null, "invalid pluginId");
        }
        catch (Assert assert_) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Invalid pluginId: " + string);
            }
            return false;
        }
        bl = this.removeProxyVersion(list, string2);
        if (list.isEmpty()) {
            this._plugins.remove(string);
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("removed PluginDescriptorProxy: " + string);
            }
        }
        return bl;
    }

    private boolean removeProxyVersion(List list, String string) {
        boolean bl = false;
        if (list != null && 0 < list.size()) {
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)list.get(i);
                if (pluginDescriptorProxy.getVersion().equals(string)) {
                    n = i;
                    continue;
                }
                pluginDescriptorProxy.setResolved(false);
            }
            if (n != -1) {
                list.remove(n);
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("removed version: " + string);
                }
                if (n == 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    PluginDescriptor getHighestVersion(String string) {
        PluginDescriptorProxy pluginDescriptorProxy;
        List list = (List)this._plugins.get(string);
        PluginDescriptorProxy pluginDescriptorProxy2 = pluginDescriptorProxy = list != null && 0 < list.size() ? (PluginDescriptorProxy)list.get(0) : null;
        if (pluginDescriptorProxy != null) {
            ExtensionPointProxy[] extensionPointProxyArray = (ExtensionPointProxy[])pluginDescriptorProxy.getExtensionPoints();
            return RegistryCache.INSTANCE.getRealPluginDescriptor(pluginDescriptorProxy);
        }
        return null;
    }

    static int compareVersionStrings(String string, String string2) throws NumberFormatException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && n == 0) {
            int n2;
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (n3 > (n2 = Integer.parseInt(stringTokenizer2.nextToken()))) {
                n = 1;
                continue;
            }
            if (n3 >= n2) continue;
            n = -1;
        }
        if (n == 0) {
            if (stringTokenizer.hasMoreTokens()) {
                n = 1;
            } else if (stringTokenizer2.hasMoreTokens()) {
                n = -1;
            }
        }
        return n;
    }

    String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        DumpHelper dumpHelper = new DumpHelper();
        dumpHelper.addHeader();
        Iterator iterator = this._plugins.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)iterator2.next();
                dumpHelper.addPlugin(pluginDescriptorProxy);
                ExtensionProxy[] extensionProxyArray = (ExtensionProxy[])pluginDescriptorProxy.getExtensions();
                if (extensionProxyArray != null && 0 < extensionProxyArray.length) {
                    dumpHelper.addExtensions(extensionProxyArray);
                } else {
                    dumpHelper.addNoExtensionsInPlugin();
                }
                IExtensionPointProxy[] iExtensionPointProxyArray = (ExtensionPointProxy[])pluginDescriptorProxy.getExtensionPoints();
                if (iExtensionPointProxyArray != null && 0 < iExtensionPointProxyArray.length) {
                    dumpHelper.addExtensionPoints(iExtensionPointProxyArray);
                    continue;
                }
                dumpHelper.addNoExtensionPointsInPlugin();
            }
        }
        dumpHelper.addFooter();
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    String toXml() throws CoreException {
        Document document = XmlUtil.createXmlDocument("extension-registry");
        Element element = document.getDocumentElement();
        element.setAttribute("version", "1.0");
        Iterator iterator = this._plugins.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Serializable serializable;
                Serializable serializable2;
                CharSequence charSequence;
                Object object;
                Node node;
                Object object2;
                Node node2;
                Object object3;
                PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)iterator2.next();
                PluginDescriptor pluginDescriptor = RegistryCache.INSTANCE.getRealPluginDescriptor(pluginDescriptorProxy);
                if (pluginDescriptor == null) continue;
                Element element2 = document.createElement(pluginDescriptor.getRootElementName());
                pluginDescriptor.toXml(element2);
                NodeList nodeList = element2.getElementsByTagName("extension");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if (node3 == null || !(node3 instanceof Element) || (object3 = (node2 = (Element)node3).getAttributes()) == null) continue;
                    object2 = object3.getNamedItem("id");
                    node = object3.getNamedItem("version");
                    if (object2 == null || node == null) continue;
                    object = object2.getNodeValue();
                    charSequence = new StringBuffer(pluginDescriptor.getUniqueIdentifier());
                    ((StringBuffer)charSequence).append(".");
                    ((StringBuffer)charSequence).append((String)object);
                    serializable2 = RegistryCache.INSTANCE.getRealExtension(((StringBuffer)charSequence).toString(), node.getNodeValue(), true);
                    ((Extension)serializable2).toXml((Element)node2);
                    serializable = RegistryCache.INSTANCE.getExtensionProxy(((StringBuffer)charSequence).toString(), node.getNodeValue());
                    node2.setAttribute("resolved", Boolean.toString(((RegistryObjectProxy)serializable).isResolved()));
                }
                NodeList nodeList2 = element2.getElementsByTagName("extension-point");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    node2 = nodeList2.item(i);
                    if (node2 == null || !(node2 instanceof Element) || (object2 = (object3 = node2).getAttributes()) == null) continue;
                    node = object2.getNamedItem("id");
                    object = object2.getNamedItem("version");
                    if (node == null || object == null) continue;
                    charSequence = node.getNodeValue();
                    serializable2 = new StringBuffer(pluginDescriptor.getUniqueIdentifier());
                    ((StringBuffer)serializable2).append(".");
                    ((StringBuffer)serializable2).append((String)charSequence);
                    serializable = RegistryCache.INSTANCE.getRealExtensionPoint(((StringBuffer)serializable2).toString(), object.getNodeValue(), true);
                    ((ExtensionPoint)serializable).toXml((Element)object3);
                    ExtensionPointProxy extensionPointProxy = RegistryCache.INSTANCE.getExtensionPointProxy(((StringBuffer)serializable2).toString(), object.getNodeValue());
                    object3.setAttribute("resolved", Boolean.toString(extensionPointProxy.isResolved()));
                }
                element2.setAttribute("resolved", Boolean.toString(pluginDescriptorProxy.isResolved()));
                element.appendChild(element2);
            }
        }
        try {
            return XmlUtil.contentXmlToString(document);
        }
        catch (XmlUtilException xmlUtilException) {
            FFDCFilter.processException(xmlUtilException, this.getClass().toString() + ".toXml", "1");
            if (s_logger.isTraceDebugEnabled()) {
                xmlUtilException.printStackTrace();
            }
            throw new CoreException((IStatus)new Status(4, "extension-registry", 0, "", (Throwable)xmlUtilException));
        }
    }
}

