/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.OffloadablePluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.RegistryConfig;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.XmlHelper;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.pmi.PmiModuleFactory;
import com.ibm.wkplc.extensionregistry.util.CacheStatistic;
import com.ibm.ws.cache.spi.DistributedMapFactory;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;

public class RegistryCache {
    private static final Logger s_logger = LoggerFactory.getLogger(RegistryCache.class);
    private static final String PROPFILE_NAME = "extensionregistry";
    private static final String DYNACACHE_NAME = "com.ibm.workplace/ExtensionRegistryCache";
    public static RegistryCache INSTANCE = new RegistryCache();
    private Map _cache = null;
    private String _cacheSize = null;
    private RegistryCacheInvalidationListener _listener = null;
    private HashMap _proxies = new HashMap();
    private CacheStatistic _statistic = new CacheStatistic("ExtensionRegistryCache");
    private Object _pmiModule = null;
    private boolean _bServerStopping = false;

    private RegistryCache() {
        this._listener = new RegistryCacheInvalidationListener(this._statistic);
        this.initDynaCache(RegistryConfig.getMaxRealObjects());
        this._pmiModule = PmiModuleFactory.getPmiModule();
    }

    private void initDynaCache(String string) {
        block7: {
            Properties properties = new Properties();
            properties.put("com.ibm.ws.cache.CacheConfig.cacheSize", string);
            properties.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", RegistryConfig.isPagingEnabled() ? "false" : "true");
            try {
                long l = new Date().getTime();
                this._cache = DistributedMapFactory.getMap(DYNACACHE_NAME + String.valueOf(l), properties);
                if (this._cache != null) {
                    DistributedMap distributedMap = (DistributedMap)this._cache;
                    distributedMap.setSharingPolicy(1);
                    distributedMap.enableListener(true);
                    distributedMap.addInvalidationListener(this._listener);
                    this._cacheSize = string;
                    if (s_logger.isInfoEnabled()) {
                        s_logger.info("info.dynacache_size_1", "Create", new Object[]{string});
                    }
                } else if (s_logger.isWarnEnabled()) {
                    s_logger.warn("warn.dynacache_unavailable_2", "Feature.NOT AVAILABLE", new Object[]{DYNACACHE_NAME, properties.get("com.ibm.ws.cache.CacheConfig.cacheSize")});
                }
            }
            catch (RuntimeException runtimeException) {
                if (!s_logger.isWarnEnabled()) break block7;
                s_logger.warn("warn.dynacache_unavailable_0", "Feature.NOT AVAILABLE", null);
            }
        }
        if (this._cache == null) {
            this._cache = new HashMap();
            this._cacheSize = "-1";
        }
    }

    PluginDescriptor getRealPluginDescriptor(PluginDescriptorProxy pluginDescriptorProxy) {
        return this.getRealPluginDescriptor(pluginDescriptorProxy, true);
    }

    PluginDescriptor getRealPluginDescriptor(PluginDescriptorProxy pluginDescriptorProxy, boolean bl) {
        if (pluginDescriptorProxy != null) {
            return this.getRealPluginDescriptor(pluginDescriptorProxy.getUniqueIdentifier(), pluginDescriptorProxy.getVersion(), bl, pluginDescriptorProxy.getPluginClassLoader());
        }
        return null;
    }

    PluginDescriptor getRealPluginDescriptor(String string, String string2, boolean bl, ClassLoader classLoader) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getRealPluginDescriptor", new Object[]{string, string2});
        }
        PluginDescriptor pluginDescriptor = null;
        if (string != null && string2 != null) {
            Object object = RegistryCache.generateCacheKey(string, string2);
            if (this._cache != null) {
                pluginDescriptor = (PluginDescriptor)this._cache.get(object);
                if (pluginDescriptor == null) {
                    this._statistic.miss();
                    if (bl && (pluginDescriptor = (PluginDescriptor)XmlHelper.readSerializedObject("plg___" + object)) != null) {
                        pluginDescriptor.setPluginClassLoader(classLoader);
                        this._cache.put(object, pluginDescriptor);
                    }
                } else {
                    this._statistic.hit();
                }
            } else if (bl && (pluginDescriptor = (PluginDescriptor)XmlHelper.readSerializedObject("plg___" + object)) != null) {
                pluginDescriptor.setPluginClassLoader(classLoader);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getRealPluginDescriptor", pluginDescriptor);
        }
        return pluginDescriptor;
    }

    PluginDescriptorProxy putPluginDescriptor(PluginDescriptor pluginDescriptor) {
        IPluginDescriptor iPluginDescriptor;
        if (pluginDescriptor == null) {
            return null;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "putPluginDescriptor", new Object[]{pluginDescriptor});
        }
        Object object = RegistryCache.generateCacheKey(pluginDescriptor.getUniqueIdentifier(), pluginDescriptor.getVersion());
        boolean bl = false;
        if (!(this._cache == null || (iPluginDescriptor = (PluginDescriptor)this._cache.get(object)) != null && iPluginDescriptor.equals(pluginDescriptor))) {
            this._cache.put(object, pluginDescriptor);
            bl = true;
        }
        if (bl) {
            XmlHelper.serializeObject(pluginDescriptor, "plg___" + object);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "putPluginDescriptor");
        }
        iPluginDescriptor = this.getPluginDescriptorProxy(pluginDescriptor.getUniqueIdentifier(), pluginDescriptor.getVersion(), pluginDescriptor.getPluginClassLoader(), object);
        if (bl) {
            iPluginDescriptor.setResolved(false);
        }
        return iPluginDescriptor;
    }

    ExtensionPoint getRealExtensionPoint(IExtensionPointProxy iExtensionPointProxy) {
        return this.getRealExtensionPoint(iExtensionPointProxy, true);
    }

    ExtensionPoint getRealExtensionPoint(IExtensionPointProxy iExtensionPointProxy, boolean bl) {
        if (iExtensionPointProxy != null) {
            return this.getRealExtensionPoint(iExtensionPointProxy.getUniqueIdentifier(), iExtensionPointProxy.getVersion(), bl);
        }
        return null;
    }

    ExtensionPoint getRealExtensionPoint(String string, String string2, boolean bl) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getRealExtensionPoint", new Object[]{string, string2});
        }
        ExtensionPoint extensionPoint = null;
        if (string != null && string2 != null) {
            Object object = RegistryCache.generateCacheKey(string, string2);
            if (this._cache != null) {
                extensionPoint = (ExtensionPoint)this._cache.get(object);
                if (extensionPoint == null) {
                    this._statistic.miss();
                    if (bl && (extensionPoint = (ExtensionPoint)XmlHelper.readSerializedObject("xpt___" + object)) != null) {
                        this._cache.put(object, extensionPoint);
                    }
                } else {
                    this._statistic.hit();
                }
            } else {
                extensionPoint = (ExtensionPoint)XmlHelper.readSerializedObject("xpt___" + object);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getRealExtensionPoint", extensionPoint);
        }
        return extensionPoint;
    }

    ExtensionPointProxy putExtensionPoint(ExtensionPoint extensionPoint) {
        IExtensionPoint iExtensionPoint;
        if (extensionPoint == null) {
            return null;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "putExtensionPoint", new Object[]{extensionPoint});
        }
        Object object = RegistryCache.generateCacheKey(extensionPoint.getUniqueIdentifier(), extensionPoint.getVersion());
        boolean bl = false;
        if (!(this._cache == null || (iExtensionPoint = (ExtensionPoint)this._cache.get(object)) != null && iExtensionPoint.equals(extensionPoint))) {
            this._cache.put(object, extensionPoint);
            if (iExtensionPoint != null && s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("RegistryCache replacing " + extensionPoint.toString() + "\n[OLD] " + iExtensionPoint.getExtensions() + "\n[NEW] " + extensionPoint.getExtensions());
            }
            bl = true;
        }
        if (bl) {
            XmlHelper.serializeObject(extensionPoint, "xpt___" + object);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "putExtensionPoint");
        }
        iExtensionPoint = this.getExtensionPointProxy(extensionPoint.getUniqueIdentifier(), extensionPoint.getVersion(), object);
        if (bl) {
            iExtensionPoint.setResolved(false);
        }
        return iExtensionPoint;
    }

    Extension getRealExtension(ExtensionProxy extensionProxy) {
        return this.getRealExtension(extensionProxy, true);
    }

    Extension getRealExtension(ExtensionProxy extensionProxy, boolean bl) {
        if (extensionProxy != null) {
            return this.getRealExtension(extensionProxy.getUniqueIdentifier(), extensionProxy.getVersion(), bl);
        }
        return null;
    }

    Extension getRealExtension(String string, String string2, boolean bl) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "getRealExtension", new Object[]{string, string2});
        }
        Extension extension2 = null;
        if (string != null && string2 != null) {
            Object object = RegistryCache.generateCacheKey(string, string2);
            if (this._cache != null) {
                extension2 = (Extension)this._cache.get(object);
                if (extension2 == null) {
                    this._statistic.miss();
                    if (bl && (extension2 = (Extension)XmlHelper.readSerializedObject("ext___" + object)) != null) {
                        this._cache.put(object, extension2);
                    }
                } else {
                    this._statistic.hit();
                }
            } else {
                extension2 = (Extension)XmlHelper.readSerializedObject("ext___" + object);
            }
        }
        if (extension2 == null && s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("Failed to retrieve the requested Extension: " + string + " [" + string2 + "]");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "getRealExtension", extension2);
        }
        return extension2;
    }

    ExtensionProxy putExtension(Extension extension2) {
        IExtension iExtension;
        if (extension2 == null) {
            return null;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "putExtension", new Object[]{extension2});
        }
        Object object = RegistryCache.generateCacheKey(extension2.getUniqueIdentifier(), extension2.getVersion());
        boolean bl = false;
        if (!(this._cache == null || (iExtension = (Extension)this._cache.get(object)) != null && iExtension.equals(extension2))) {
            this._cache.put(object, extension2);
            bl = true;
        }
        if (bl) {
            XmlHelper.serializeObject(extension2, "ext___" + object);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "putExtension");
        }
        iExtension = this.getExtensionProxy(extension2.getUniqueIdentifier(), extension2.getVersion(), object);
        if (bl) {
            iExtension.setResolved(false);
        }
        return iExtension;
    }

    PluginDescriptorProxy getPluginDescriptorProxy(String string, String string2) {
        return this.getPluginDescriptorProxy(string, string2, null, RegistryCache.generateCacheKey(string, string2));
    }

    PluginDescriptorProxy getPluginDescriptorProxy(String string, String string2, ClassLoader classLoader) {
        return this.getPluginDescriptorProxy(string, string2, classLoader, RegistryCache.generateCacheKey(string, string2));
    }

    PluginDescriptorProxy getPluginDescriptorProxy(String string, String string2, ClassLoader classLoader, Object object) {
        if (object == null) {
            return null;
        }
        PluginDescriptorProxy pluginDescriptorProxy = (PluginDescriptorProxy)this._proxies.get(object);
        if (pluginDescriptorProxy == null) {
            pluginDescriptorProxy = new PluginDescriptorProxy(string, string2);
            pluginDescriptorProxy.setPluginClassLoader(classLoader);
            this._proxies.put(object, pluginDescriptorProxy);
        } else if (!pluginDescriptorProxy.hasClassLoader()) {
            pluginDescriptorProxy.setPluginClassLoader(classLoader);
        }
        return pluginDescriptorProxy;
    }

    ExtensionPointProxy getExtensionPointProxy(String string, String string2) {
        return this.getExtensionPointProxy(string, string2, RegistryCache.generateCacheKey(string, string2));
    }

    ExtensionPointProxy getExtensionPointProxy(String string, String string2, Object object) {
        ExtensionPointProxy extensionPointProxy = (ExtensionPointProxy)this._proxies.get(object);
        if (extensionPointProxy == null) {
            extensionPointProxy = new ExtensionPointProxy(string, string2);
            this._proxies.put(object, extensionPointProxy);
        }
        return extensionPointProxy;
    }

    ExtensionProxy getExtensionProxy(String string, String string2) {
        return this.getExtensionProxy(string, string2, RegistryCache.generateCacheKey(string, string2));
    }

    ExtensionProxy getExtensionProxy(String string, String string2, Object object) {
        ExtensionProxy extensionProxy = (ExtensionProxy)this._proxies.get(object);
        if (extensionProxy == null) {
            extensionProxy = new ExtensionProxy(string, string2);
            this._proxies.put(object, extensionProxy);
        }
        return extensionProxy;
    }

    void removeObject(String string, String string2) {
        Object object = RegistryCache.generateCacheKey(string, string2);
        RegistryObjectProxy registryObjectProxy = this.invalidateProxyObject(object);
        if (registryObjectProxy != null && !this._bServerStopping) {
            this.invalidateRealObject(object);
            XmlHelper.deleteSerializedData(registryObjectProxy.getPrefix() + object);
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("Warning! RegistryCache.removeObject was asked to remove something that hadn't had the proxy loaded: " + string + " [" + string2 + "]");
        }
    }

    OffloadablePluginModelObject invalidateRealObject(Object object) {
        return (OffloadablePluginModelObject)this._cache.remove(object);
    }

    RegistryObjectProxy invalidateProxyObject(Object object) {
        return (RegistryObjectProxy)this._proxies.remove(object);
    }

    static Object generateCacheKey(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Warning! RegistryCache.generateCacheKey: ID=" + string + ", VER=" + string2);
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("___");
        stringBuffer.append(string2);
        CRC32 cRC32 = new CRC32();
        byte[] byArray = null;
        try {
            byArray = stringBuffer.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (s_logger.isTraceDebugEnabled()) {
                unsupportedEncodingException.printStackTrace();
            }
            byArray = stringBuffer.toString().getBytes();
        }
        cRC32.update(byArray);
        return Long.toString(cRC32.getValue());
    }

    void updateSerializedFiles() {
        if (this._bServerStopping) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("RegistryCache.updateSerializedFiles: aborting as the server is shutting down...");
            }
            return;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "updateSerializedFiles");
        }
        Iterator iterator = this._proxies.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            OffloadablePluginModelObject offloadablePluginModelObject;
            RegistryObjectProxy registryObjectProxy;
            RegistryObjectProxy registryObjectProxy2 = (RegistryObjectProxy)iterator.next();
            if (registryObjectProxy2 instanceof PluginDescriptorProxy) {
                registryObjectProxy = (PluginDescriptorProxy)registryObjectProxy2;
                offloadablePluginModelObject = INSTANCE.getRealPluginDescriptor((PluginDescriptorProxy)registryObjectProxy, false);
                if (offloadablePluginModelObject == null || !offloadablePluginModelObject.isDirty()) continue;
                object = RegistryCache.generateCacheKey(((PluginDescriptor)offloadablePluginModelObject).getUniqueIdentifier(), offloadablePluginModelObject.getVersion());
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("serializing plg: " + object);
                }
                XmlHelper.serializeObject(offloadablePluginModelObject, ((PluginDescriptorProxy)registryObjectProxy).getPrefix() + object);
                continue;
            }
            if (registryObjectProxy2 instanceof ExtensionPointProxy) {
                registryObjectProxy = (ExtensionPointProxy)registryObjectProxy2;
                offloadablePluginModelObject = INSTANCE.getRealExtensionPoint((IExtensionPointProxy)((Object)registryObjectProxy), false);
                if (offloadablePluginModelObject == null || !offloadablePluginModelObject.isDirty()) continue;
                object = RegistryCache.generateCacheKey(((ExtensionPoint)offloadablePluginModelObject).getUniqueIdentifier(), offloadablePluginModelObject.getVersion());
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("serializing xpt: " + object);
                }
                XmlHelper.serializeObject(offloadablePluginModelObject, ((ExtensionPointProxy)registryObjectProxy).getPrefix() + object);
                continue;
            }
            if (!(registryObjectProxy2 instanceof ExtensionProxy) || (offloadablePluginModelObject = INSTANCE.getRealExtension((ExtensionProxy)(registryObjectProxy = (ExtensionProxy)registryObjectProxy2), false)) == null || !offloadablePluginModelObject.isDirty()) continue;
            object = RegistryCache.generateCacheKey(((Extension)offloadablePluginModelObject).getUniqueIdentifier(), offloadablePluginModelObject.getVersion());
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("serializing ext: " + object);
            }
            XmlHelper.serializeObject(offloadablePluginModelObject, ((ExtensionProxy)registryObjectProxy).getPrefix() + object);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "updateSerializedFiles");
        }
    }

    void setServerStopping() {
        this._bServerStopping = true;
    }

    public String getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSize(String string) {
        if (this._cache != null && this._cache instanceof DistributedMap) {
            ((DistributedMap)this._cache).removeInvalidationListener(this._listener);
            this._cache.clear();
            this._cache = null;
            this.initDynaCache(string);
            this._statistic.reset();
        }
    }

    public String getCacheStats() {
        return this._statistic.toString();
    }

    public long getTotalCacheRequests() {
        return this._statistic.getTries();
    }

    public long getCacheHits() {
        return this._statistic.getHits();
    }

    public long getCacheDisplaces() {
        return this._statistic.getDisplaces();
    }

    static class RegistryCacheInvalidationListener
    implements InvalidationListener {
        private CacheStatistic _statistic = null;

        RegistryCacheInvalidationListener(CacheStatistic cacheStatistic) {
            this._statistic = cacheStatistic;
        }

        public void fireEvent(InvalidationEvent invalidationEvent) {
            int n = invalidationEvent.getCauseOfInvalidation();
            if (n == 2) {
                Extension extension2;
                this._statistic.displacement();
                Object object = invalidationEvent.getValue();
                if (object instanceof PluginDescriptor) {
                    PluginDescriptor pluginDescriptor = (PluginDescriptor)object;
                    if (pluginDescriptor.isDirty()) {
                        String string = "plg___" + RegistryCache.generateCacheKey(pluginDescriptor.getUniqueIdentifier(), pluginDescriptor.getVersion());
                        XmlHelper.serializeObject(pluginDescriptor, string);
                    }
                } else if (object instanceof ExtensionPoint) {
                    ExtensionPoint extensionPoint = (ExtensionPoint)object;
                    if (extensionPoint.isDirty()) {
                        String string = "xpt___" + RegistryCache.generateCacheKey(extensionPoint.getUniqueIdentifier(), extensionPoint.getVersion());
                        XmlHelper.serializeObject(extensionPoint, string);
                    }
                } else if (object instanceof Extension && (extension2 = (Extension)object).isDirty()) {
                    String string = "ext___" + RegistryCache.generateCacheKey(extension2.getUniqueIdentifier(), extension2.getVersion());
                    XmlHelper.serializeObject(extension2, string);
                }
            }
        }
    }
}

