/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.bootstrap.WSLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class RegistryConfig {
    protected static final Logger s_logger = LoggerFactory.getLogger(RegistryConfig.class);
    private static final String THIS_CLASS = "com.ibm.wkplc.extensionregistry.RegistryConfig";
    private static String s_storageLocation = null;
    private static boolean s_diskOffload = true;
    private static String s_maxRealObjs = "5000";
    private static boolean s_globalFilter = true;
    private static boolean s_debugDump = false;
    private static boolean s_zOS = WSLauncher.isZOS();

    private RegistryConfig() {
    }

    public static String getStorageLocation() {
        AdminService adminService;
        if (s_storageLocation == null && (adminService = AdminServiceFactory.getAdminService()) != null) {
            File file;
            s_storageLocation = RegistryConfig.getWasHome() + File.separator + "temp" + File.separator + adminService.getNodeName() + File.separator + adminService.getProcessName() + File.separator + "_extensionregistry";
            if (s_zOS) {
                s_storageLocation = s_storageLocation + File.separator + ServerName.getjsabpref();
            }
            if (!(file = new File(s_storageLocation)).exists()) {
                file.mkdirs();
            }
            if (s_logger.isInfoEnabled()) {
                s_logger.info("info.objects_storage_location_1", "Feature", new Object[]{s_storageLocation});
            }
        }
        return s_storageLocation;
    }

    private static String getWasHome() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() == 0) {
            string = System.getProperty("was.install.root");
        }
        return string;
    }

    public static boolean isPagingEnabled() {
        return s_diskOffload;
    }

    public static String getMaxRealObjects() {
        return s_maxRealObjs;
    }

    public static boolean isGlobalFilteringEnabled() {
        return s_globalFilter;
    }

    public static boolean isDebugDumpEnabled() {
        return s_debugDump;
    }

    public static boolean isZOS() {
        return s_zOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Properties properties = new Properties();
            boolean bl = false;
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null) {
                StringBuffer stringBuffer = new StringBuffer(RegistryConfig.getWasHome());
                stringBuffer.append("/config/cells/");
                stringBuffer.append(adminService.getCellName());
                stringBuffer.append("/nodes/");
                stringBuffer.append(adminService.getNodeName());
                stringBuffer.append("/servers/");
                stringBuffer.append(adminService.getProcessName());
                stringBuffer.append("/extensionregistry.properties");
                FileInputStream fileInputStream = new FileInputStream(stringBuffer.toString());
                properties.load(fileInputStream);
                bl = true;
            }
            if (!bl && s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("No configuration file found for Application Extension Registry");
            }
            try {
                String string = properties.getProperty("enable.disk.offload");
                s_diskOffload = Boolean.valueOf(string);
                if (!s_diskOffload && s_logger.isInfoEnabled()) {
                    s_logger.info("info.no_paging_0", "Configure");
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                s_maxRealObjs = properties.getProperty("max.in-memory.objects");
                int n = Integer.parseInt(s_maxRealObjs);
                if (n <= 0 && s_logger.isInfoEnabled()) {
                    s_logger.info("info.unlimited_real_objects_0", "Configure");
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                String string = properties.getProperty("enable.global.filter");
                s_globalFilter = Boolean.valueOf(string);
                if (!s_globalFilter && s_logger.isInfoEnabled()) {
                    s_logger.info("info.no_global_filtering_0", "Configure");
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                String string = properties.getProperty("dump.registry.contents");
                s_debugDump = Boolean.valueOf(string);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (s_logger.isTraceDebugEnabled()) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (s_logger.isTraceDebugEnabled()) {
                iOException.printStackTrace();
            }
        }
        catch (RuntimeException runtimeException) {
            if (s_logger.isTraceDebugEnabled()) {
                runtimeException.printStackTrace();
            }
        }
        finally {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("ExtensionRegistry: diskOffload=" + s_diskOffload + ", maxRealObjs=" + s_maxRealObjs + ", globalFilter=" + s_globalFilter);
            }
        }
    }
}

