/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.PluginParser;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryConfig;
import com.ibm.wkplc.extensionregistry.XmlHelper;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import com.ibm.wkplc.extensionregistry.util.XmlUtil;
import com.ibm.wkplc.extensionregistry.util.XmlUtilException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RegistryLoader {
    protected static final Logger s_logger = LoggerFactory.getLogger(RegistryLoader.class);
    private static final String PLUGINXML = "plugin.xml";
    private static final String PLUGINXML2 = "WEB-INF/plugin.xml";
    private static final String BUNDLE_URL_PREFIX = "bundleresource:";
    private static final String LOADER_FILE = "loader.xml";
    private static final String LOADER_FILE_VERSION = "1.0";
    private static final String LOADER_ROOT_TAG = "registry-loader";
    private static final String PLUGINXML_TAG = "plugin-xml";
    private static final String PLG_PROXY_TAG = "plugin-proxy";
    private static final String XPT_PROXY_TAG = "extensionpoint-proxy";
    private static final String EXT_PROXY_TAG = "extension-proxy";
    private static final String LOCATION_ATTR = "location";
    private static final String TIMESTAMP_ATTR = "timestamp";
    private ExtensionRegistry _registry = null;
    private PluginParser _parser = null;
    private HashMap _knownPluginXmls = null;

    public RegistryLoader(ExtensionRegistry extensionRegistry) {
        this._registry = extensionRegistry;
        this._parser = new PluginParser();
        this._knownPluginXmls = new HashMap();
    }

    boolean restore() {
        boolean bl;
        block14: {
            if (RegistryConfig.isZOS()) {
                return false;
            }
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "restore");
            }
            bl = false;
            try {
                String string = RegistryConfig.getStorageLocation() + File.separator + LOADER_FILE;
                FileInputStream fileInputStream = new FileInputStream(string);
                Element element = XmlUtil.getDomFromStream(fileInputStream);
                String string2 = element.getAttribute("version");
                if (XmlHelper.isXmlCompatible(string2)) {
                    NodeList nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        String string3;
                        String string4;
                        Node node = nodeList.item(i);
                        if (!(node instanceof Element)) continue;
                        Element element2 = (Element)node;
                        String string5 = element2.getTagName();
                        if (string5.equals(PLUGINXML_TAG)) {
                            string4 = element2.getAttribute(LOCATION_ATTR);
                            string3 = element2.getAttribute(TIMESTAMP_ATTR);
                            String string6 = element2.getAttribute("plugin");
                            String string7 = element2.getAttribute("version");
                            this._knownPluginXmls.put(string4, new PluginMeta(Long.parseLong(string3), string6, string7));
                            continue;
                        }
                        if (string5.equals(PLG_PROXY_TAG)) {
                            string4 = element2.getAttribute("id");
                            string3 = element2.getAttribute("version");
                            this._registry.addPluginDescriptorProxy(RegistryCache.INSTANCE.getPluginDescriptorProxy(string4, string3), true);
                            continue;
                        }
                        if (string5.equals(XPT_PROXY_TAG)) {
                            string4 = element2.getAttribute("id");
                            string3 = element2.getAttribute("version");
                            this._registry.addExtensionPointProxy(RegistryCache.INSTANCE.getExtensionPointProxy(string4, string3), true);
                            continue;
                        }
                        if (!string5.equals(EXT_PROXY_TAG)) continue;
                        string4 = element2.getAttribute("id");
                        string3 = element2.getAttribute("version");
                        this._registry.addExtensionProxy(RegistryCache.INSTANCE.getExtensionProxy(string4, string3), true);
                    }
                    fileInputStream.close();
                    bl = true;
                    File file = new File(string);
                    file.delete();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (s_logger.isTraceDebugEnabled()) {
                    fileNotFoundException.printStackTrace();
                }
            }
            catch (XmlUtilException xmlUtilException) {
                FFDCFilter.processException(xmlUtilException, this.getClass().toString() + ".restore", "1");
                if (s_logger.isTraceDebugEnabled()) {
                    xmlUtilException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.getClass().toString() + ".restore", "2");
                if (!s_logger.isTraceDebugEnabled()) break block14;
                iOException.printStackTrace();
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "restore", bl);
        }
        return bl;
    }

    void loadSelf() {
        block4: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "loadSelf");
            }
            Assert.it(this._registry != null, "_registry != null");
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Enumeration<URL> enumeration = classLoader.getResources("app-plugin.xml");
                this.loadAllPluginXmls(enumeration, classLoader);
            }
            catch (IOException iOException) {
                if (!s_logger.isTraceDebugEnabled()) break block4;
                s_logger.traceDebug("app-plugin.xml not found");
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "loadSelf");
        }
    }

    void save(PluginDescriptorProxy[] pluginDescriptorProxyArray, ExtensionPointProxy[] extensionPointProxyArray, ExtensionProxy[] extensionProxyArray) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "shutdown");
        }
        if (RegistryConfig.isPagingEnabled()) {
            try {
                int n;
                Object object;
                File file = new File(RegistryConfig.getStorageLocation() + File.separator + LOADER_FILE);
                Document document = XmlUtil.createXmlDocument(LOADER_ROOT_TAG);
                Element element = document.getDocumentElement();
                element.setAttribute("version", LOADER_FILE_VERSION);
                Iterator iterator = this._knownPluginXmls.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    object = (PluginMeta)this._knownPluginXmls.get(string);
                    Element element2 = document.createElement(PLUGINXML_TAG);
                    element2.setAttribute(LOCATION_ATTR, string);
                    element2.setAttribute(TIMESTAMP_ATTR, Long.toString(((PluginMeta)object).getTimestamp()));
                    element2.setAttribute("plugin", ((PluginMeta)object).getPluginIdentifier());
                    element2.setAttribute("version", ((PluginMeta)object).getVersion());
                    element.appendChild(element2);
                }
                for (n = 0; n < pluginDescriptorProxyArray.length; ++n) {
                    object = document.createElement(PLG_PROXY_TAG);
                    object.setAttribute("id", pluginDescriptorProxyArray[n].getUniqueIdentifier());
                    object.setAttribute("version", pluginDescriptorProxyArray[n].getVersion());
                    element.appendChild((Node)object);
                }
                for (n = 0; n < extensionPointProxyArray.length; ++n) {
                    object = document.createElement(XPT_PROXY_TAG);
                    object.setAttribute("id", extensionPointProxyArray[n].getUniqueIdentifier());
                    object.setAttribute("version", extensionPointProxyArray[n].getVersion());
                    element.appendChild((Node)object);
                }
                for (n = 0; n < extensionProxyArray.length; ++n) {
                    object = document.createElement(EXT_PROXY_TAG);
                    object.setAttribute("id", extensionProxyArray[n].getUniqueIdentifier());
                    object.setAttribute("version", extensionProxyArray[n].getVersion());
                    element.appendChild((Node)object);
                }
                XmlUtil.outputXml(document, file);
            }
            catch (XmlUtilException xmlUtilException) {
                FFDCFilter.processException(xmlUtilException, this.getClass().toString() + ".save", "3");
                if (s_logger.isWarnEnabled()) {
                    s_logger.warn("warn.failed_to_save_loaderxml_0", "Feature", new Object[0], xmlUtilException);
                }
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("RegistryLoader.shutdown() aborted because disk.offload==false");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "shutdown");
        }
    }

    public synchronized void loadModule(ClassLoader classLoader) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "loadModule", new Object[]{"CLID=" + classLoader.hashCode()});
        }
        if (0 < this.addToRegistry(classLoader)) {
            if (!this._registry.isSkippingResolve()) {
                this._registry.resolve();
            }
            this._registry.notifyChanges();
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "loadModule");
        }
    }

    private int addToRegistry(ClassLoader classLoader) {
        int n;
        block4: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "addToRegistry", new Object[]{"CLID=" + classLoader.hashCode()});
            }
            n = 0;
            Assert.it(this._registry != null, "_registry != null");
            try {
                Enumeration<URL> enumeration = classLoader.getResources(PLUGINXML);
                n += this.loadAllPluginXmls(enumeration, classLoader);
                enumeration = classLoader.getResources(PLUGINXML2);
                n += this.loadAllPluginXmls(enumeration, classLoader);
            }
            catch (IOException iOException) {
                if (!s_logger.isInfoEnabled()) break block4;
                s_logger.info("info.no_pluginxml_found_0", "Request");
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "addToRegistry", n);
        }
        return n;
    }

    private int loadAllPluginXmls(Enumeration enumeration, ClassLoader classLoader) {
        int n = 0;
        try {
            while (true) {
                Object object;
                URL uRL = (URL)enumeration.nextElement();
                boolean bl = false;
                String string = uRL.toExternalForm();
                if (this._knownPluginXmls.containsKey(string) && (string.startsWith("jar:file:") || string.startsWith(BUNDLE_URL_PREFIX)) && ((PluginMeta)(object = (PluginMeta)this._knownPluginXmls.get(string))).getRefCount() != 0) {
                    ((PluginMeta)object).incrementRefCount();
                    continue;
                }
                object = null;
                try {
                    object = uRL.openConnection();
                }
                catch (IOException iOException) {
                    continue;
                }
                long l = ((URLConnection)object).getLastModified();
                if (this._knownPluginXmls.containsKey(string)) {
                    PluginMeta pluginMeta = (PluginMeta)this._knownPluginXmls.get(string);
                    if (pluginMeta == null || pluginMeta.getTimestamp() != l) {
                        if (!this.loadPluginXml(uRL, l, pluginMeta, classLoader)) continue;
                        ++n;
                        pluginMeta.incrementRefCount();
                        continue;
                    }
                    this._registry.setClassLoaderInPlugin(pluginMeta.getPluginIdentifier(), pluginMeta.getVersion(), classLoader);
                    ++n;
                    pluginMeta.incrementRefCount();
                    if (!s_logger.isTraceDebugEnabled()) continue;
                    s_logger.traceDebug("skipped: " + string + " (ts=" + l + ",cnt=" + pluginMeta.getRefCount() + ")");
                    PluginDescriptorProxy pluginDescriptorProxy = RegistryCache.INSTANCE.getPluginDescriptorProxy(pluginMeta.getPluginIdentifier(), pluginMeta.getVersion());
                    if (pluginDescriptorProxy == null) continue;
                    s_logger.traceDebug("  CLID=" + pluginDescriptorProxy.getPluginClassLoader().hashCode() + " in " + pluginDescriptorProxy);
                    continue;
                }
                if (!this.loadPluginXml(uRL, l, null, classLoader)) continue;
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return n;
        }
    }

    private boolean loadPluginXml(URL uRL, long l, PluginMeta pluginMeta, ClassLoader classLoader) {
        boolean bl;
        block7: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "loadPluginXml", new Object[]{uRL});
            }
            bl = false;
            String string = uRL.toExternalForm();
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("loading: " + string + " (ts=" + l + ")");
            }
            try {
                InputSource inputSource = new InputSource(uRL.openStream());
                inputSource.setSystemId(string);
                PluginDescriptor pluginDescriptor = this._parser.parsePlugin(inputSource);
                if (pluginDescriptor != null) {
                    if (!string.startsWith(BUNDLE_URL_PREFIX) || pluginDescriptor.getUniqueIdentifier().equals("org.eclipse.extensionregistry")) {
                        pluginDescriptor.setPluginClassLoader(classLoader);
                        pluginDescriptor.setInstallURL(uRL);
                        this._registry.addPlugin(pluginDescriptor);
                    }
                    bl = true;
                    PluginMeta pluginMeta2 = new PluginMeta(l, pluginDescriptor.getUniqueIdentifier(), pluginDescriptor.getVersion());
                    this._knownPluginXmls.put(string, pluginMeta2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, this.getClass().toString() + ".loadPluginXml", "4");
                if (!s_logger.isWarnEnabled()) break block7;
                s_logger.warn("warn.loading_pluginxml_1", "Request", new Object[]{string}, exception);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "loadPluginXml", bl);
        }
        return bl;
    }

    public boolean unloadModule(ClassLoader classLoader) {
        boolean bl;
        block7: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "unloadModule", new Object[]{"CLID=" + classLoader.hashCode()});
            }
            bl = false;
            try {
                Enumeration<URL> enumeration = classLoader.getResources(PLUGINXML);
                boolean bl2 = this.unloadAllPluginXmls(enumeration, classLoader);
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("unloadModule from plugin.xml: " + bl2);
                }
                enumeration = classLoader.getResources(PLUGINXML2);
                boolean bl3 = this.unloadAllPluginXmls(enumeration, classLoader);
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("unloadModule from WEB-INF/plugin.xml: " + bl3);
                }
                if (bl2 && bl3) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, this.getClass().toString() + ".loadPluginXml", "5");
                if (!s_logger.isErrorEnabled()) break block7;
                s_logger.error("err.loader_io_0", "Request", null, iOException);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "unloadModule", bl);
        }
        return bl;
    }

    private boolean unloadAllPluginXmls(Enumeration enumeration, ClassLoader classLoader) {
        boolean bl = false;
        if (enumeration != null || enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                String string = uRL.toExternalForm();
                if (this._knownPluginXmls.containsKey(string)) {
                    PluginMeta pluginMeta = (PluginMeta)this._knownPluginXmls.get(string);
                    pluginMeta.decrementRefCount();
                    PluginDescriptorProxy pluginDescriptorProxy = this._registry.getPlugin(pluginMeta.getPluginIdentifier());
                    if (pluginDescriptorProxy != null) {
                        pluginDescriptorProxy.removeClassLoader(classLoader);
                        if (s_logger.isTraceDebugEnabled()) {
                            s_logger.traceDebug("removed last classloader for " + pluginMeta.getPluginIdentifier());
                            s_logger.traceDebug("number of classloaders remaining for this plugin: " + pluginDescriptorProxy.numClassLoaders());
                            s_logger.traceDebug("number of references remaining: " + pluginMeta.getRefCount());
                        }
                    } else if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("unloadAllPluginXmls: WARNING - PluginDescriptorProxy could not be found for plugin with id: " + pluginMeta.getPluginIdentifier());
                    }
                    if (pluginMeta.getRefCount() == 0) {
                        if (s_logger.isTraceDebugEnabled()) {
                            s_logger.traceDebug("unloading: " + string);
                        }
                        this._knownPluginXmls.remove(string);
                        if (!string.startsWith(BUNDLE_URL_PREFIX) || pluginMeta.getPluginIdentifier().equals("org.eclipse.extensionregistry")) {
                            this.removePlugin(pluginMeta.getPluginIdentifier(), pluginMeta.getVersion());
                        }
                        bl = true;
                        if (!s_logger.isTraceDebugEnabled()) continue;
                        s_logger.traceDebug(pluginMeta.getPluginIdentifier() + " removed");
                        continue;
                    }
                    if (!s_logger.isTraceDebugEnabled()) continue;
                    s_logger.traceDebug("skipping as somebody [" + pluginMeta.getRefCount() + "] still references to this plugin...");
                    continue;
                }
                if (!s_logger.isTraceDebugEnabled()) continue;
                s_logger.traceDebug(string + " ignored");
            }
        }
        return bl;
    }

    private synchronized void removePlugin(String string, String string2) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "removePlugin", new Object[]{string, string2});
        }
        if (this._registry != null) {
            this._registry.removePlugin(string, string2);
            this._registry.resolve();
            this._registry.notifyChanges();
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "removePlugin");
        }
    }

    static class PluginMeta {
        private long _timestamp = 0L;
        private String _pluginId = null;
        private String _version = null;
        private int _refCnt = 0;

        PluginMeta(long l, String string, String string2) {
            this._timestamp = l;
            this._pluginId = string;
            this._version = string2;
            this._refCnt = 0;
        }

        long getTimestamp() {
            return this._timestamp;
        }

        String getPluginIdentifier() {
            return this._pluginId;
        }

        String getVersion() {
            return this._version;
        }

        int getRefCount() {
            return this._refCnt;
        }

        void incrementRefCount() {
            ++this._refCnt;
        }

        void decrementRefCount() {
            if (0 < this._refCnt) {
                --this._refCnt;
            }
        }
    }
}

