/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionDelta;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.PluginDelta;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryChangeEvent;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.Assert;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;

public class RegistryNotifier {
    private static final Logger s_logger = LoggerFactory.getLogger(RegistryNotifier.class);
    private ExtensionRegistry _registry = null;
    private Map _listeners = null;
    private Map _deltas = null;

    RegistryNotifier(ExtensionRegistry extensionRegistry) {
        this._registry = extensionRegistry;
        this._listeners = new HashMap();
        this._deltas = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener, String string) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "addRegistryChangeListener", new Object[]{iRegistryChangeListener, string});
        }
        try {
            Assert.it(iRegistryChangeListener != null, "null listener");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException(assert_.getMessage());
        }
        Map map = this._listeners;
        synchronized (map) {
            this._listeners.put(iRegistryChangeListener, string);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "addRegistryChangeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "removeRegistryChangeListener", new Object[]{iRegistryChangeListener});
        }
        try {
            Assert.it(iRegistryChangeListener != null, "null listener");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException(assert_.getMessage());
        }
        Map map = this._listeners;
        synchronized (map) {
            this._listeners.remove(iRegistryChangeListener);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "removeRegistryChangeListener");
        }
    }

    void addDelta(IPluginDescriptor iPluginDescriptor, int n, boolean bl) {
        PluginDelta pluginDelta;
        if (this._listeners.isEmpty()) {
            return;
        }
        try {
            Assert.it(iPluginDescriptor != null, "null pd");
        }
        catch (Assert assert_) {
            throw new IllegalArgumentException(assert_.getMessage());
        }
        String string = iPluginDescriptor.getUniqueIdentifier();
        try {
            Assert.it(string != null, "null pluginId");
        }
        catch (Assert assert_) {
            s_logger.error("err.invalid_plugin_id_0", "Request");
            return;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "addDelta", new Object[]{string, "[" + iPluginDescriptor.getVersionIdentifier() + "] being " + (n == 1 ? "added" : "removed")});
        }
        if ((pluginDelta = this.getDelta(iPluginDescriptor, n)) != null && 2 == n) {
            PluginDescriptor pluginDescriptor = null;
            if (bl && iPluginDescriptor instanceof PluginDescriptor) {
                pluginDescriptor = (PluginDescriptor)iPluginDescriptor;
            }
            this.updateDelta(pluginDelta, iPluginDescriptor, pluginDescriptor, n);
            this._deltas.put(string, pluginDelta);
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("RegistryNotifier.getDelta() returned null for: " + string);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "addDelta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChangeEvent() {
        IExtensionDelta[] iExtensionDeltaArray;
        Object object;
        if (this._deltas.isEmpty() || this._listeners.isEmpty()) {
            return;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "fireChangeEvent");
        }
        this.processQueued(this._deltas);
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        Object object2 = this;
        synchronized (object2) {
            hashMap.putAll(this._deltas);
            this._deltas.clear();
            hashSet.addAll(this._listeners.keySet());
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (IRegistryChangeListener)object2.next();
            if (object == null || (iExtensionDeltaArray = (IExtensionDelta[])this._listeners.get(object)) != null && !hashMap.containsKey(iExtensionDeltaArray)) continue;
            try {
                object.registryChanged((IRegistryChangeEvent)new RegistryChangeEvent(hashMap, (String)iExtensionDeltaArray));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().toString() + ".fireChangeEvent", "1");
                if (!s_logger.isWarnEnabled()) continue;
                s_logger.warn("warn.error_in_changelistener_0", "Other", new Object[0], throwable);
            }
        }
        if (s_logger.isTraceDebugEnabled()) {
            object = new RegistryChangeEvent(hashMap, null);
            iExtensionDeltaArray = object.getExtensionDeltas();
            s_logger.traceDebug("RegistryNotifier.fireChangeEvent() notified " + hashSet.size() + " listener(s) of " + iExtensionDeltaArray.length + " deltas, and now _deltas has " + this._deltas.size() + " element(s).");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "fireChangeEvent");
        }
    }

    private PluginDelta getDelta(IPluginDescriptor iPluginDescriptor, int n) {
        if (iPluginDescriptor == null) {
            return null;
        }
        String string = iPluginDescriptor.getUniqueIdentifier();
        PluginDelta pluginDelta = (PluginDelta)this._deltas.get(string);
        if (pluginDelta == null) {
            pluginDelta = new PluginDelta(iPluginDescriptor);
            this._deltas.put(string, pluginDelta);
        }
        if (n == 1) {
            pluginDelta.setDelayedProcessing(true);
        }
        return pluginDelta;
    }

    private void updateDelta(PluginDelta pluginDelta, IPluginDescriptor iPluginDescriptor, PluginDescriptor pluginDescriptor, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (n == 1) {
            iPluginDescriptor = this._registry.getPlugin(iPluginDescriptor.getUniqueIdentifier(), false);
            pluginDelta.setDelayedProcessing(false);
            if (pluginDescriptor != null && s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Warning! RegistryNotifier.updateDelta() gets non-null 'realPD' when 'kind' != ADDED");
            }
        }
        if (iPluginDescriptor == null) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Warning! RegistryNotifier.updateDelta is aborting as pd==null...");
            }
            return;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("RegistryNotifier.updateDelta: " + iPluginDescriptor + " (" + (n == 1 ? "added" : "removed") + ")");
        }
        if (pluginDescriptor != null && n == 2 && (object4 = pluginDescriptor.getResourceBundle()) != null) {
            Properties properties = new Properties();
            object3 = ((ResourceBundle)object4).getKeys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                String string = pluginDescriptor.getResourceString((String)object2);
                properties.put(object2, string);
            }
            pluginDescriptor.setTranslations(properties);
        }
        object4 = (ExtensionPointProxy[])iPluginDescriptor.getExtensionPoints();
        for (int i = 0; object4 != null && i < ((ExtensionPointProxy[])object4).length; ++i) {
            object3 = RegistryCache.INSTANCE.getRealExtensionPoint((IExtensionPointProxy)object4[i]);
            if (object3 != null) {
                if (pluginDescriptor != null) {
                    ((ExtensionPoint)object3).setParentDescriptorAsIs(pluginDescriptor);
                }
                object2 = (ExtensionProxy[])((ExtensionPoint)object3).getExtensions();
                for (int j = 0; j < ((ExtensionProxy[])object2).length; ++j) {
                    object = RegistryCache.INSTANCE.getRealExtension((ExtensionProxy)object2[j]);
                    if (object == null) continue;
                    ExtensionDelta extensionDelta = new ExtensionDelta((IExtensionPoint)object3, (IExtension)object, n);
                    pluginDelta.addDelta(extensionDelta);
                    this.updateDeltasForAffected(((ExtensionProxy)object2[j]).getDeclaringPluginDescriptor(), extensionDelta);
                }
                continue;
            }
            if (!s_logger.isTraceDebugEnabled()) continue;
            s_logger.traceDebug("Invalid " + ((ExtensionPointProxy)object4[i]).toString());
        }
        ExtensionProxy[] extensionProxyArray = (ExtensionProxy[])iPluginDescriptor.getExtensions();
        for (int i = 0; extensionProxyArray != null && i < extensionProxyArray.length; ++i) {
            object2 = RegistryCache.INSTANCE.getRealExtension(extensionProxyArray[i]);
            if (object2 != null) {
                String string;
                PluginDescriptorProxy pluginDescriptorProxy;
                int n2;
                if (pluginDescriptor != null) {
                    ((Extension)object2).setParentDescriptorAsIs(pluginDescriptor);
                }
                if (n == 2) {
                    ((Extension)object2).setRealExtensionObjectInConfigElements();
                }
                IExtensionPointProxy iExtensionPointProxy = null;
                object = ((Extension)object2).getExtensionPointUniqueIdentifier();
                if (object != null && (n2 = ((String)object).lastIndexOf(46)) != -1 && (pluginDescriptorProxy = this._registry.getPlugin(string = ((String)object).substring(0, n2), false)) != null && pluginDescriptorProxy.hasClassLoader()) {
                    iExtensionPointProxy = (IExtensionPointProxy)pluginDescriptorProxy.getExtensionPoint(((String)object).substring(n2 + 1));
                }
                if (iExtensionPointProxy == null || (object = RegistryCache.INSTANCE.getRealExtensionPoint(iExtensionPointProxy)) == null) continue;
                ExtensionDelta extensionDelta = new ExtensionDelta((IExtensionPoint)object, (IExtension)object2, n);
                pluginDelta.addDelta(extensionDelta);
                this.updateDeltasForAffected(((ExtensionPoint)object).getDeclaringPluginDescriptor(), extensionDelta);
                continue;
            }
            if (!s_logger.isTraceDebugEnabled()) continue;
            s_logger.traceDebug("Invalid " + extensionProxyArray[i].toString());
        }
    }

    private void updateDeltasForAffected(IPluginDescriptor iPluginDescriptor, ExtensionDelta extensionDelta) {
        PluginDelta pluginDelta;
        if (iPluginDescriptor != null && extensionDelta != null && (pluginDelta = this.getDelta(iPluginDescriptor, extensionDelta.getKind())) != null) {
            pluginDelta.addDelta(extensionDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueued(Map map) {
        HashSet hashSet = new HashSet();
        Object object = this;
        synchronized (object) {
            hashSet.addAll(map.keySet());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            PluginDelta pluginDelta = (PluginDelta)map.get(object.next());
            if (pluginDelta == null || !pluginDelta.needsProcessing()) continue;
            this.updateDelta(pluginDelta, pluginDelta.getPluginDescriptor(), null, 1);
        }
    }
}

