/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.ExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.ExtensionProxy;
import com.ibm.wkplc.extensionregistry.ExtensionRegistry;
import com.ibm.wkplc.extensionregistry.IExtensionPointProxy;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.PluginDescriptorProxy;
import com.ibm.wkplc.extensionregistry.PluginPrerequisite;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.RegistryObjectProxy;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class RegistryResolver {
    protected static final Logger s_logger = LoggerFactory.getLogger(RegistryResolver.class);
    private static final String SEPARATOR = ".";
    private ExtensionRegistry _reg;

    public RegistryResolver(ExtensionRegistry extensionRegistry) {
        this._reg = extensionRegistry;
    }

    void resolve() {
        PluginDescriptorProxy pluginDescriptorProxy;
        Collection collection = this._reg.getAllPluginProxies();
        if (collection == null || collection.isEmpty()) {
            if (s_logger.isWarnEnabled()) {
                s_logger.warn("warn.empty_plugin_list_0", "Request");
            }
            return;
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "resolve", new Object[]{"tackling " + collection.size() + " plug-in(s)"});
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            pluginDescriptorProxy = (PluginDescriptorProxy)iterator.next();
            if (pluginDescriptorProxy.isResolved() || pluginDescriptorProxy.isPlaceHolder()) continue;
            this.resolvePluginDescriptorPrereqs(pluginDescriptorProxy);
            this.syncClassLoaderRef(pluginDescriptorProxy);
            if (!pluginDescriptorProxy.hasClassLoader()) {
                pluginDescriptorProxy.markInactive();
            }
            this.resolvePluginDescriptorExtensionPoints(pluginDescriptorProxy);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            pluginDescriptorProxy = (PluginDescriptorProxy)iterator.next();
            this.resolvePluginDescriptorExtensions(pluginDescriptorProxy);
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "resolve");
        }
    }

    private void resolvePluginDescriptorPrereqs(PluginDescriptorProxy pluginDescriptorProxy) {
        PluginPrerequisite[] pluginPrerequisiteArray;
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "resolvePluginDescriptorPrereqs", new Object[]{pluginDescriptorProxy.toString()});
        }
        if ((pluginPrerequisiteArray = pluginDescriptorProxy.getRequires()) == null || pluginPrerequisiteArray.length == 0) {
            pluginDescriptorProxy.markActive();
        } else {
            for (int i = 0; i < pluginPrerequisiteArray.length; ++i) {
                boolean bl = this.resolvePrereq(pluginPrerequisiteArray[i]);
                if (!bl) continue;
                pluginDescriptorProxy.markActive();
            }
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(pluginDescriptorProxy.toString() + (pluginDescriptorProxy.isActive() ? " active" : " inactive"));
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "resolvePluginDescriptorPrereqs");
        }
    }

    private boolean resolvePrereq(PluginPrerequisite pluginPrerequisite) {
        String string = pluginPrerequisite.getUniqueIdentifier();
        PluginVersionIdentifier pluginVersionIdentifier = pluginPrerequisite.getVersionIdentifier();
        PluginDescriptorProxy pluginDescriptorProxy = this._reg.getPlugin(string, false);
        if (pluginDescriptorProxy == null) {
            return false;
        }
        PluginVersionIdentifier pluginVersionIdentifier2 = new PluginVersionIdentifier(pluginDescriptorProxy.getVersion());
        if (pluginPrerequisite.isMatchedUnspecified() || pluginVersionIdentifier == null) {
            if (pluginPrerequisite.isMatchedUnspecified() || pluginVersionIdentifier == null) {
                // empty if block
            }
            if (!pluginPrerequisite.isMatchedUnspecified() || pluginVersionIdentifier != null) {
                // empty if block
            }
            pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
            return true;
        }
        if (pluginPrerequisite.isMatchedAsGreaterOrEqual()) {
            if (pluginVersionIdentifier2.isGreaterOrEqualTo(pluginVersionIdentifier)) {
                pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
                return true;
            }
        } else if (pluginPrerequisite.isMatchedAsEquivalent()) {
            if (pluginVersionIdentifier2.isEquivalentTo(pluginVersionIdentifier)) {
                pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
                return true;
            }
        } else if (pluginPrerequisite.isMatchedAsCompatible() && pluginVersionIdentifier2.isCompatibleWith(pluginVersionIdentifier)) {
            pluginPrerequisite.setResolvedVersionIdentifier(pluginVersionIdentifier2.toString());
            return true;
        }
        return false;
    }

    private void syncClassLoaderRef(PluginDescriptorProxy pluginDescriptorProxy) {
        if (pluginDescriptorProxy.isPlaceHolder()) {
            return;
        }
        PluginDescriptor pluginDescriptor = RegistryCache.INSTANCE.getRealPluginDescriptor(pluginDescriptorProxy, false);
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        if (classLoader != null) {
            pluginDescriptorProxy.setPluginClassLoader(classLoader);
        } else {
            pluginDescriptor.setPluginClassLoader(pluginDescriptorProxy.getPluginClassLoader());
        }
    }

    private void resolvePluginDescriptorExtensionPoints(PluginDescriptorProxy pluginDescriptorProxy) {
        ExtensionPointProxy[] extensionPointProxyArray = (ExtensionPointProxy[])pluginDescriptorProxy.getExtensionPoints();
        if (extensionPointProxyArray == null) {
            return;
        }
        for (int i = 0; i < extensionPointProxyArray.length; ++i) {
            extensionPointProxyArray[i].setResolved(pluginDescriptorProxy.hasClassLoader() ? pluginDescriptorProxy.isResolved() : false);
        }
    }

    private void resolvePluginDescriptorExtensions(PluginDescriptorProxy pluginDescriptorProxy) {
        ExtensionProxy[] extensionProxyArray;
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "resolvePluginDescriptorExtensions", new Object[]{pluginDescriptorProxy.toString()});
        }
        if ((extensionProxyArray = (ExtensionProxy[])pluginDescriptorProxy.getExtensions()) != null && 0 < extensionProxyArray.length) {
            for (int i = 0; i < extensionProxyArray.length; ++i) {
                Extension extension2;
                if (!pluginDescriptorProxy.hasClassLoader()) {
                    extensionProxyArray[i].setResolved(false);
                    continue;
                }
                if (extensionProxyArray[i].isResolved() || (extension2 = RegistryCache.INSTANCE.getRealExtension(extensionProxyArray[i], true)) == null) continue;
                boolean bl = this.resolveExtension(extension2);
                extensionProxyArray[i].setResolved(bl);
                if (!s_logger.isTraceDebugEnabled()) continue;
                s_logger.traceDebug(extensionProxyArray[i].toString() + (bl ? " resolved" : " unresolved"));
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "resolvePluginDescriptorExtensions");
        }
    }

    private boolean resolveExtension(Extension extension2) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "resolveExtension", new Object[]{extension2.toString()});
        }
        boolean bl = false;
        String string = extension2.getExtensionPointUniqueIdentifier();
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("target xpt=" + string);
        }
        int n = string.lastIndexOf(SEPARATOR);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = null;
        Object object = ((PluginDescriptorProxy)extension2.getDeclaringPluginDescriptor()).getRequires();
        if (object != null && 0 < ((PluginPrerequisite[])object).length) {
            for (int i = 0; i < ((PluginPrerequisite[])object).length; ++i) {
                if (!object[i].getUniqueIdentifier().equals(string2)) continue;
                string4 = ((PluginPrerequisite)object[i]).getResolvedVersion();
            }
        }
        if (!(string4 != null && string4.equals("0.0.0") || (object = this._reg.getPlugin(string2)) == null || string4 != null && !((RegistryObjectProxy)object).getVersion().equals(string4))) {
            ExtensionPoint extensionPoint = RegistryCache.INSTANCE.getRealExtensionPoint((IExtensionPointProxy)((PluginDescriptorProxy)object).getExtensionPoint(string3));
            if (extensionPoint == null) {
                if (s_logger.isWarnEnabled()) {
                    s_logger.warn("warn.nonexistent_extension_point_2", "Feature.NOT AVAILABLE", new Object[]{string, extension2.getUniqueIdentifier()});
                }
            } else {
                extensionPoint.addExtension(RegistryCache.INSTANCE.getExtensionProxy(extension2.getUniqueIdentifier(), extension2.getVersion()));
                bl = true;
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "resolveExtension", bl);
        }
        return bl;
    }

    public boolean checkPluginDescriptorBasics(PluginDescriptor pluginDescriptor) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "requiredPluginDescriptor", new Object[]{pluginDescriptor});
        }
        boolean bl = true;
        boolean bl2 = bl = pluginDescriptor.getUniqueIdentifier() != null && this.checkVersionFormat(pluginDescriptor.getVersion());
        if (bl) {
            PluginPrerequisite[] pluginPrerequisiteArray = pluginDescriptor.getRequires();
            if (pluginPrerequisiteArray != null) {
                for (int i = 0; bl && i < pluginPrerequisiteArray.length; ++i) {
                    bl = bl && this.requiredPrerequisite(pluginPrerequisiteArray[i]);
                }
            }
            if (bl) {
                Iterator iterator;
                Iterator iterator2 = pluginDescriptor.getExtensionPointsInternal();
                while (bl && iterator2.hasNext()) {
                    iterator = (IExtensionPoint)iterator2.next();
                    bl = bl && this.requiredExtensionPoint((IExtensionPoint)iterator);
                }
                if (bl) {
                    iterator = pluginDescriptor.getExtensionsInternal();
                    while (bl && iterator.hasNext()) {
                        IExtension iExtension = (IExtension)iterator.next();
                        bl = bl && this.requiredExtension(iExtension);
                    }
                }
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "requiredPluginDescriptor", bl);
        }
        return bl;
    }

    private boolean requiredPrerequisite(PluginPrerequisite pluginPrerequisite) {
        if (pluginPrerequisite.getVersion() != null) {
            return this.checkVersionFormat(pluginPrerequisite.getVersion()) && pluginPrerequisite.getUniqueIdentifier() != null;
        }
        return pluginPrerequisite.getUniqueIdentifier() != null;
    }

    private boolean requiredExtension(IExtension iExtension) {
        return iExtension != null && iExtension.getExtensionPointUniqueIdentifier() != null;
    }

    private boolean requiredExtensionPoint(IExtensionPoint iExtensionPoint) {
        return iExtensionPoint != null && iExtensionPoint.getSimpleIdentifier() != null;
    }

    private boolean checkVersionFormat(String string) {
        boolean bl;
        block39: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "checkVersionFormat", new Object[]{string});
            }
            bl = false;
            if (string == null) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("versionId == null");
                }
            } else {
                String string2 = string.trim();
                if (string2.equals("")) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("versionId == \"\"");
                    }
                } else if (string2.startsWith(SEPARATOR)) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("versionId starts with '.'");
                    }
                } else if (string2.endsWith(SEPARATOR)) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("versionId ends with '.'");
                    }
                } else if (string2.indexOf("..") != -1) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("versionId is malformed");
                    }
                } else {
                    Vector<String> vector = new Vector<String>(3);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, SEPARATOR);
                    while (stringTokenizer.hasMoreTokens()) {
                        vector.addElement(stringTokenizer.nextToken());
                    }
                    int n = vector.size();
                    if (n <= 0) {
                        if (s_logger.isTraceDebugEnabled()) {
                            s_logger.traceDebug("zero elements in version");
                        }
                    } else if (n > 3) {
                        if (s_logger.isTraceDebugEnabled()) {
                            s_logger.traceDebug("over three elements in version");
                        }
                    } else {
                        block41: {
                            int[] nArray;
                            block40: {
                                block38: {
                                    nArray = new int[3];
                                    try {
                                        nArray[0] = Integer.parseInt((String)vector.elementAt(0));
                                        if (nArray[0] >= 0) break block38;
                                        if (s_logger.isTraceDebugEnabled()) {
                                            s_logger.traceDebug("major is less than zero");
                                        }
                                        break block39;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        FFDCFilter.processException(numberFormatException, this.getClass().toString() + "checkVersionFormat", "1");
                                        if (s_logger.isTraceDebugEnabled()) {
                                            s_logger.traceDebug("major is not numerical");
                                        }
                                        break block39;
                                    }
                                }
                                try {
                                    if (n >= 2) {
                                        nArray[1] = Integer.parseInt((String)vector.elementAt(1));
                                        if (nArray[1] >= 0) break block40;
                                        if (s_logger.isTraceDebugEnabled()) {
                                            s_logger.traceDebug("minor is less than zero");
                                        }
                                        break block39;
                                    }
                                    nArray[1] = 0;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    FFDCFilter.processException(numberFormatException, this.getClass().toString() + "checkVersionFormat", "2");
                                    if (s_logger.isTraceDebugEnabled()) {
                                        s_logger.traceDebug("minor is not numerical");
                                    }
                                    break block39;
                                }
                            }
                            try {
                                if (n >= 3) {
                                    nArray[2] = Integer.parseInt((String)vector.elementAt(2));
                                    if (nArray[2] >= 0) break block41;
                                    if (s_logger.isTraceDebugEnabled()) {
                                        s_logger.traceDebug("service is less than zero");
                                    }
                                    break block39;
                                }
                                nArray[2] = 0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                FFDCFilter.processException(numberFormatException, this.getClass().toString() + "checkVersionFormat", "3");
                                if (s_logger.isTraceDebugEnabled()) {
                                    s_logger.traceDebug("service is not numerical");
                                }
                                break block39;
                            }
                        }
                        bl = true;
                    }
                }
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit((Object)this, "checkVersionFormat", bl);
        }
        return bl;
    }
}

