/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPluginDescriptor;

public class ResourceHelper {
    private static final Logger s_logger = LoggerFactory.getLogger(ResourceHelper.class);
    private static final String THIS_CLASS = "com.ibm.wkplc.extensionregistry.ResourceHelper";
    private static Object s_callerI18n = null;
    private static boolean s_i18nTried = false;
    private static HashMap s_resBundles = new HashMap();
    private static ResourceBundle s_logBundle = null;
    private static ResourceBundle s_dumpBundle = null;

    private ResourceHelper() {
    }

    static ResourceBundle getBundle(IPluginDescriptor iPluginDescriptor) {
        return ResourceHelper.getBundle(iPluginDescriptor, ResourceHelper.getCallerLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getBundle(IPluginDescriptor iPluginDescriptor, Locale locale) {
        ResourceBundle resourceBundle;
        block18: {
            String string = iPluginDescriptor.getUniqueIdentifier();
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(THIS_CLASS, "getBundle", new Object[]{string, locale});
            }
            resourceBundle = null;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("___");
            stringBuffer.append(iPluginDescriptor.getVersionIdentifier().toString());
            stringBuffer.append("___");
            stringBuffer.append(locale.toString());
            String string2 = stringBuffer.toString();
            if (s_resBundles.containsKey(string2)) {
                resourceBundle = (ResourceBundle)s_resBundles.get(string2);
            } else {
                try {
                    int n;
                    URL uRL = iPluginDescriptor.getInstallURL();
                    if (uRL == null) {
                        break block18;
                    }
                    String string3 = uRL.toExternalForm();
                    if (!string3.endsWith("plugin.xml")) {
                        break block18;
                    }
                    StringBuffer stringBuffer2 = new StringBuffer(string3);
                    int n2 = string3.length();
                    stringBuffer2.replace(n2 - 4, n2, "_");
                    stringBuffer2.append(locale.toString());
                    stringBuffer2.append(".properties");
                    resourceBundle = ResourceHelper.findBundle(stringBuffer2.toString());
                    if (resourceBundle != null) {
                        break block18;
                    }
                    int n3 = string3.lastIndexOf("plugin.xml");
                    while ((n = stringBuffer2.toString().lastIndexOf("_")) != -1) {
                        if (n < n3) {
                        } else {
                            stringBuffer2.replace(n, stringBuffer2.length(), ".properties");
                            resourceBundle = ResourceHelper.findBundle(stringBuffer2.toString());
                            if (resourceBundle == null) continue;
                        }
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException(runtimeException, "com.ibm.wkplc.extensionregistry.ResourceHelper.getBundle", "1");
                    if (s_logger.isTraceDebugEnabled()) {
                        runtimeException.printStackTrace();
                    }
                }
                finally {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug("putting in the cache: " + string2 + " <-> " + resourceBundle);
                    }
                    s_resBundles.put(string2, resourceBundle);
                }
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "getBundle", (Object)resourceBundle);
        }
        return resourceBundle;
    }

    private static ResourceBundle findBundle(String string) {
        PropertyResourceBundle propertyResourceBundle = null;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (inputStream != null) {
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
            }
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException(malformedURLException, "com.ibm.wkplc.extensionregistry.ResourceHelper.findBundle", "2");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return propertyResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locale getCallerLocale() {
        Locale locale;
        block16: {
            GenericDeclaration genericDeclaration;
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(THIS_CLASS, "getCallerLocale");
            }
            locale = null;
            if (s_callerI18n == null && !s_i18nTried) {
                try {
                    genericDeclaration = Class.forName("com.ibm.websphere.i18n.context.UserInternationalization");
                    Object object = null;
                    GenericDeclaration genericDeclaration2 = Class.forName("com.ibm.ws.i18n.context.I18nService");
                    Method method2 = ((Class)genericDeclaration2).getMethod("getUserInternationalization", null);
                    Method method3 = ((Class)genericDeclaration2).getMethod("getInstance", null);
                    object = method2.invoke(method3.invoke(null, null), null);
                    if (object != null) {
                        genericDeclaration2 = object.getClass().getMethod("getCallerInternationalization", null);
                        s_callerI18n = ((Method)genericDeclaration2).invoke(object, null);
                    }
                }
                catch (Exception exception) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.warn("warn.failed_to_locate_i18n_service_0", "Available");
                    }
                    if (s_logger.isTraceDebugEnabled()) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    s_i18nTried = true;
                }
            }
            if (s_callerI18n != null) {
                try {
                    genericDeclaration = s_callerI18n.getClass().getMethod("getLocale", null);
                    locale = (Locale)((Method)genericDeclaration).invoke(s_callerI18n, null);
                }
                catch (Throwable throwable) {
                    if (!s_logger.isTraceDebugEnabled()) break block16;
                    s_logger.traceDebug("Failed to invoke getLocale() method on the user Internationalization object");
                    throwable.printStackTrace();
                }
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "getCallerLocale", (Object)locale);
        }
        return locale;
    }

    public static String getString(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = resourceBundle.getString(string);
        if (string2 != null) {
            return MessageFormat.format(string2, objectArray);
        }
        return null;
    }

    static ResourceBundle getResourceBundle() {
        if (s_logBundle == null) {
            s_logBundle = ResourceBundle.getBundle("com.ibm.wkplc.extensionregistry.extensionregistry");
        }
        return s_logBundle;
    }

    static ResourceBundle getDumpResourceBundle() {
        if (s_dumpBundle == null) {
            s_dumpBundle = ResourceBundle.getBundle("com.ibm.wkplc.extensionregistry.dumptool");
        }
        return s_dumpBundle;
    }

    static String getString(String string, Object[] objectArray) {
        String string2 = ResourceHelper.getResourceBundle().getString(string);
        if (objectArray != null) {
            return MessageFormat.format(string2, objectArray);
        }
        return string2;
    }
}

