/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry;

import com.ibm.wkplc.extensionregistry.Extension;
import com.ibm.wkplc.extensionregistry.ExtensionPoint;
import com.ibm.wkplc.extensionregistry.OffloadablePluginModelObject;
import com.ibm.wkplc.extensionregistry.PluginDescriptor;
import com.ibm.wkplc.extensionregistry.RegistryConfig;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wkplc.extensionregistry.util.XmlUtil;
import com.ibm.wkplc.extensionregistry.util.XmlUtilException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlHelper {
    private static final Logger s_logger = LoggerFactory.getLogger(XmlHelper.class);
    private static final String THIS_CLASS = "com.ibm.wkplc.extensionregistry.XmlHelper";
    public static final String DOM_NAME_ATTR = "name";
    public static final String DOM_ID_ATTR = "id";
    public static final String DOM_VERSION_ATTR = "version";
    public static final String DOM_PARENT_TAG = "parent";
    public static final String DOM_EXTENSIONS_TAG = "extensions";
    private static final String XML_ROOT_TAG = "extension-registry-object";
    private static final String DOM_TYPE_ATTR = "type";
    static final String MY_VERSION = "1.0";

    public static boolean serializeObject(OffloadablePluginModelObject offloadablePluginModelObject, String string) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(THIS_CLASS, "serializeObject", new Object[]{offloadablePluginModelObject.getClass(), string});
        }
        boolean bl = false;
        if (RegistryConfig.isPagingEnabled()) {
            try {
                File file = new File(RegistryConfig.getStorageLocation() + File.separator + string + ".ser");
                Document document = XmlUtil.createXmlDocument(XML_ROOT_TAG);
                Element element = document.getDocumentElement();
                element.setAttribute(DOM_VERSION_ATTR, MY_VERSION);
                element.setAttribute(DOM_TYPE_ATTR, offloadablePluginModelObject.getRootElementName());
                Element element2 = document.createElement(offloadablePluginModelObject.getRootElementName());
                element.appendChild(element2);
                offloadablePluginModelObject.toXml(element2);
                XmlUtil.outputXml(document, file);
                bl = true;
                offloadablePluginModelObject.setDirty(false);
            }
            catch (XmlUtilException xmlUtilException) {
                FFDCFilter.processException(xmlUtilException, "com.ibm.wkplc.extensionregistry.XmlHelper.serializeObject", "1");
                if (s_logger.isErrorEnabled()) {
                    s_logger.error("err.failed_to_serialize_object_1", "Feature", new Object[]{string}, xmlUtilException);
                }
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("RegistryConfig.serializedObject aborted because disk.offload==false");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "serializeObject", bl);
        }
        return bl;
    }

    public static OffloadablePluginModelObject readSerializedObject(String string) {
        Object object;
        block12: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(THIS_CLASS, "readSerializedObject", new Object[]{string});
            }
            object = null;
            if (RegistryConfig.isPagingEnabled()) {
                try {
                    String string2 = RegistryConfig.getStorageLocation() + File.separator + string + ".ser";
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    Element element = XmlUtil.getDomFromStream(fileInputStream);
                    if (element.getTagName().equals(XML_ROOT_TAG) && XmlHelper.isXmlCompatible(element.getAttribute(DOM_VERSION_ATTR))) {
                        String string3 = element.getAttribute(DOM_TYPE_ATTR);
                        NodeList nodeList = element.getElementsByTagName(string3);
                        Element element2 = null;
                        for (int i = 0; element2 == null && i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            if (!(node instanceof Element)) continue;
                            element2 = (Element)node;
                        }
                        object = XmlHelper.getRegistryObjectFromDom(string3, element2);
                        if (object == null && s_logger.isErrorEnabled()) {
                            s_logger.error("err.failed_to_read_stored_object_1", "Feature", new Object[]{string});
                        }
                        break block12;
                    }
                    XmlHelper.deleteSerializedData(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FFDCFilter.processException(fileNotFoundException, "com.ibm.wkplc.extensionregistry.XmlHelper.readSerializedObject", "2");
                    if (s_logger.isErrorEnabled()) {
                        s_logger.error("err.failed_to_read_stored_object_1", "Feature", new Object[]{string}, fileNotFoundException);
                    }
                    break block12;
                }
                catch (XmlUtilException xmlUtilException) {
                    FFDCFilter.processException(xmlUtilException, "com.ibm.wkplc.extensionregistry.XmlHelper.readSerializedObject", "3");
                    if (s_logger.isErrorEnabled()) {
                        s_logger.error("err.failed_to_read_stored_object_1", "Feature", new Object[]{string}, xmlUtilException);
                    }
                    break block12;
                }
            }
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("RegistryConfig.readSerializedObject aborted because disk.offload==false");
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "readSerializedObject", object.getClass());
        }
        return object;
    }

    private static OffloadablePluginModelObject getRegistryObjectFromDom(String string, Element element) {
        OffloadablePluginModelObject offloadablePluginModelObject = null;
        if (string.equals("extension")) {
            offloadablePluginModelObject = new Extension();
        } else if (string.equals("extension-point")) {
            offloadablePluginModelObject = new ExtensionPoint();
        } else if (string.equals("plugin-descriptor")) {
            offloadablePluginModelObject = new PluginDescriptor();
        }
        if (offloadablePluginModelObject != null) {
            ((OffloadablePluginModelObject)offloadablePluginModelObject).initFromDom(element);
        }
        return offloadablePluginModelObject;
    }

    static boolean isXmlCompatible(String string) {
        return string.startsWith("1.");
    }

    static boolean deleteSerializedData(String string) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(THIS_CLASS, "deleteSerializedData", new Object[]{string});
        }
        boolean bl = false;
        if (RegistryConfig.isPagingEnabled()) {
            try {
                File file = new File(RegistryConfig.getStorageLocation() + File.separator + string + ".ser");
                file.delete();
                bl = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.wkplc.extensionregistry.XmlHelper.deleteSerializedData", "4");
                if (s_logger.isWarnEnabled()) {
                    s_logger.warn("warn.failed_to_delete_orphan_ser_1", "Destroy", new Object[]{string}, exception);
                }
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("RegistryConfig.deleteSerializedData aborted because disk.offload==false");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "deleteSerializedData", bl);
        }
        return bl;
    }
}

