/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.jmx;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;

public class ExtensionRegistryTool
extends AdminTool {
    public static final String BUNDLE_NAME = "com.ibm.wkplc.extensionregistry.jmx.jmx";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.wkplc.extensionregistry.jmx.jmx", Locale.getDefault());
    private ServerIdentifiers _sid;
    private String _filter = null;
    private String _command = "dump";

    public static void main(String[] stringArray) {
        System.exit(new ExtensionRegistryTool().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return "*=all=disabled";
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + this._sid.getServerName();
        string = string + File.separator + "ExtensionRegistry.log";
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        try {
            String string = RESOURCE_BUNDLE.getString("info.usage");
            if (string != null && 0 < string.length()) {
                System.out.println(MessageFormat.format(string, "dumpExtensionRegistry"));
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        System.out.println("Usage: dumpExtensionRegistry <servername> [registryname]");
    }

    protected int parseRequiredArgs(String[] stringArray) throws AdminException {
        this._sid = new ServerIdentifiers();
        this._sid.setConfigRoot(stringArray[0]);
        this._sid.setCellName(stringArray[1]);
        this._sid.setNodeName(stringArray[2]);
        this._sid.setServerName(stringArray[3]);
        if (4 < stringArray.length) {
            this._filter = stringArray[4];
            this._command = "filteredDump";
            return 5;
        }
        return 4;
    }

    protected int runTool() throws Exception {
        String string = this._sid.getServerName();
        if (!this.serverConfigExists(this._sid)) {
            this.issueMessage("ADMU0522E", new Object[]{this._sid.getServerName()}, null);
            return -1;
        }
        this.issueMessage("ADMU0506I", new Object[]{string}, null);
        this.executeCommand(string);
        return 0;
    }

    private boolean serverConfigExists(ServerIdentifiers serverIdentifiers) {
        String string = serverIdentifiers.getConfigRoot() + "/cells/" + serverIdentifiers.getCellName() + "/nodes/" + serverIdentifiers.getNodeName() + "/servers/" + serverIdentifiers.getServerName();
        File file = new File(string);
        return file.exists();
    }

    private void executeCommand(String string) throws Exception {
        JMXConnector jMXConnector;
        Object object;
        Object object2;
        AdminClient adminClient;
        block14: {
            adminClient = null;
            try {
                object2 = RepositoryFactory.createRepository("ws-server", this._sid.getConfigRoot(), this._sid.getCellName(), this._sid.getNodeName(), this._sid.getServerName());
                object = object2.getConfigRoot().getResource(4, "server.xml");
                jMXConnector = LaunchUtils.getJMXConnector(object);
                if (jMXConnector == null) break block14;
                try {
                    adminClient = LaunchUtils.getAdminClient((Repository)object2, jMXConnector, this.userid, this.pwd);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, this.getClass().toString() + ".executeCommand", "1");
                    this.issueMessage("ADMU0509I", new Object[]{"Application Server", string}, null);
                    return;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, this.getClass().toString() + ".executeCommand", "2");
                throw exception;
            }
        }
        if (adminClient != null) {
            object2 = "WebSphere:type=ExtensionRegistryService,*";
            object = new ObjectName((String)object2);
            jMXConnector = null;
            Set set = adminClient.queryNames((ObjectName)object, null);
            if (!set.isEmpty()) {
                ObjectName objectName = (ObjectName)set.iterator().next();
                if (this._command.equals("filteredDump")) {
                    String string2 = (String)adminClient.invoke(objectName, "getFilteredDump", new Object[]{this._filter}, new String[]{"java.lang.String"});
                    System.out.println(string2);
                } else if (this._command.equals("cacheStats")) {
                    String string3 = this.getServerAttribute(adminClient, objectName, "cacheStats");
                    System.out.println(string3);
                } else if (this._command.equals("getCacheSize")) {
                    String string4 = this.getServerAttribute(adminClient, objectName, "cacheSize");
                    System.out.println("Current cache size = " + string4);
                } else if (this._command.equals("setCacheSize")) {
                    Attribute attribute = new Attribute("cacheSize", this._filter);
                    adminClient.setAttribute(objectName, attribute);
                } else {
                    String string5 = this.getServerAttribute(adminClient, objectName, "contentDump");
                    System.out.println(string5);
                }
            }
        }
    }

    private String getServerAttribute(AdminClient adminClient, ObjectName objectName, String string) throws Exception {
        String string2 = null;
        if (adminClient != null) {
            Object object = adminClient.getAttribute(objectName, string);
            string2 = object.toString();
        } else {
            string2 = "RUNTIME/CONFIG MISMATCH";
        }
        return string2;
    }
}

