/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.logging;

import com.ibm.wkplc.extensionregistry.logging.JdkLoggerWrapper;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LwpLoggerWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class LoggerFactory {
    private static final String LWP_FACTORY_CLASS = "com.ibm.workplace.util.logging.Log";
    private static final String JDK_FACTORY_CLASS = "java.util.logging.Logger";
    private static Class s_lwpFactory = null;
    private static Method s_lwpFactoryMethod = null;
    private static Class s_lwpLoggerInterface = null;
    private static Class s_wasFactory = null;
    private static Method s_wasFactoryMethod = null;

    public static Logger getLogger(Class clazz) {
        try {
            Class.forName(LWP_FACTORY_CLASS);
            return LoggerFactory.getLwpLogger(clazz);
        }
        catch (Exception exception) {
            return LoggerFactory.getWasLogger(clazz.getName(), LoggerFactory.resourceBundleName(LoggerFactory.getPackageName(clazz)));
        }
    }

    private static String getPackageName(Class clazz) {
        String string;
        int n;
        Package package_ = clazz.getPackage();
        String string2 = package_ == null ? ((n = (string = clazz.getName()).lastIndexOf(46)) > 0 ? string.substring(0, n) : "") : clazz.getPackage().getName();
        return string2;
    }

    private static String resourceBundleName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string + "." + string.substring(++n);
        return string2;
    }

    private static Logger getLwpLogger(Class clazz) {
        Object object = null;
        try {
            if (s_lwpFactory == null) {
                s_lwpFactory = Class.forName(LWP_FACTORY_CLASS);
            }
            if (s_lwpLoggerInterface == null) {
                s_lwpLoggerInterface = Class.forName("com.ibm.workplace.util.logging.LogMgr");
            }
            if (s_lwpFactoryMethod == null) {
                s_lwpFactoryMethod = s_lwpFactory.getMethod("get", Class.class);
            }
            object = s_lwpFactoryMethod.invoke(null, clazz);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (Logger)Proxy.newProxyInstance(LoggerFactory.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new LwpLoggerWrapper(object, new Class[]{s_lwpLoggerInterface}));
    }

    private static Logger getWasLogger(String string, String string2) {
        Object object = null;
        try {
            if (s_wasFactory == null) {
                s_wasFactory = Class.forName(JDK_FACTORY_CLASS);
            }
            if (s_wasFactoryMethod == null) {
                s_wasFactoryMethod = s_wasFactory.getMethod("getLogger", String.class, String.class);
            }
            object = s_wasFactoryMethod.invoke(null, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new JdkLoggerWrapper(object);
    }
}

