/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

public class LwpLoggerWrapper
implements InvocationHandler {
    private Object _impl;
    private HashMap _availableMethods;

    public LwpLoggerWrapper(Object object, Class[] classArray) {
        if (object == null) {
            throw new NullPointerException("impl");
        }
        this._impl = object;
        this._availableMethods = new HashMap();
        for (int i = 0; i < classArray.length; ++i) {
            Method[] methodArray = classArray[i].getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                this._availableMethods.put(this.getMethodKey(methodArray[j]), methodArray[j]);
            }
        }
    }

    private String getMethodKey(Method method2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(method2.getReturnType().getName()).append(' ');
        stringBuffer.append(method2.getName()).append('(');
        Object object = method2.getParameterTypes();
        if (((Class<?>[])object).length > 0) {
            stringBuffer.append(object[0].getName());
            for (int i = 1; i < ((Class<?>[])object).length; ++i) {
                stringBuffer.append(',').append(object[i].getName());
            }
        }
        stringBuffer.append(')');
        object = stringBuffer.toString();
        return object;
    }

    public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
        if (method2 == null) {
            throw new NullPointerException("method");
        }
        String string = this.getMethodKey(method2);
        Method method3 = (Method)this._availableMethods.get(string);
        if (method3 != null) {
            return method3.invoke(this._impl, objectArray);
        }
        throw new IllegalArgumentException("method");
    }
}

