/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.pmi;

import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIDoubleStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class ExtensionRegistryModule
implements StatisticActionListener {
    protected static final Logger s_logger = LoggerFactory.getLogger(ExtensionRegistryModule.class);
    private static final long serialVersionUID = 1L;
    private static final String TEMPLATE = "/com/ibm/websphere/pmi/xml/ExtensionRegistryModule.xml";
    private StatsInstance _statsInstance = StatsFactory.createStatsInstance("ExtensionRegistryStats.name", "/com/ibm/websphere/pmi/xml/ExtensionRegistryModule.xml", null, (StatisticActionListener)this);
    private SPICountStatistic _numRequests;
    private SPICountStatistic _numHits;
    private SPICountStatistic _numDisplaces;
    private SPIDoubleStatistic _hitRate;

    public ExtensionRegistryModule() throws StatsFactoryException {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("ExtensionRegistryModule: created StatsInstance (v6): " + this._statsInstance.getName());
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "statisticCreated", new Object[]{sPIStatistic});
        }
        if (sPIStatistic.getId() == 1) {
            this._numRequests = (SPICountStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 2) {
            this._numHits = (SPICountStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 3) {
            this._hitRate = (SPIDoubleStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 4) {
            this._numDisplaces = (SPICountStatistic)sPIStatistic;
        } else if (s_logger.isErrorEnabled()) {
            s_logger.error("err.invalid_stats_id_1", "Create", new Object[]{Integer.toString(sPIStatistic.getId())});
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "statisticCreated");
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceEntry(this, "updateStatisticOnRequest", new Object[]{String.valueOf(n)});
        }
        if (RegistryCache.INSTANCE != null) {
            if (n == 3 && this._hitRate != null) {
                double d = 100.0;
                long l = RegistryCache.INSTANCE.getTotalCacheRequests();
                long l2 = RegistryCache.INSTANCE.getCacheHits();
                if (0L < l) {
                    d = (double)l2 * 100.0 / (double)l;
                }
                this._hitRate.setDouble(d);
            } else if (n == 1 && this._numRequests != null) {
                this._numRequests.setCount(RegistryCache.INSTANCE.getTotalCacheRequests());
            } else if (n == 2 && this._numHits != null) {
                this._numHits.setCount(RegistryCache.INSTANCE.getCacheHits());
            } else if (n == 4 && this._numDisplaces != null) {
                this._numDisplaces.setCount(RegistryCache.INSTANCE.getCacheDisplaces());
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("ExtensionRegistryModule.updateStatisticOnRequest(" + n + ") aborted as RegistryCache.INSTANCE isn't ready yet...");
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(this, "updateStatisticOnRequest");
        }
    }
}

