/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.pmi;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.websphere.websphere;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;

public class PmiModuleFactory {
    protected static final Logger s_logger = LoggerFactory.getLogger(PmiModuleFactory.class);
    private static final String THIS_CLASS = "com.ibm.wkplc.extensionregistry.pmi.PmiModuleFactory";
    private static final String FACTORY_V5 = "com.ibm.websphere.pmi.factory.StatsFactory";
    private static final String FACTORY_V6 = "com.ibm.wsspi.pmi.factory.StatsFactory";
    private static final String MODULE_V5 = "com.ibm.wkplc.extensionregistry.pmi.ExtensionRegistryModule5";
    private static final String MODULE_V6 = "com.ibm.wkplc.extensionregistry.pmi.ExtensionRegistryModule";
    private static String s_serverVersion = null;

    public static Object getPmiModule() {
        Object var0;
        block5: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(THIS_CLASS, "getPmiModule");
            }
            var0 = null;
            if (PmiModuleFactory.isPmiEnabled()) {
                try {
                    String string = PmiModuleFactory.getServerVersion();
                    Class<?> clazz = Class.forName(string.startsWith("5.") ? MODULE_V5 : MODULE_V6);
                    var0 = clazz.newInstance();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.wkplc.extensionregistry.pmi.PmiModuleFactory.getPmiModule", "1");
                    if (!s_logger.isErrorEnabled()) break block5;
                    s_logger.error("err.create_pmi_module_0", "Request", null, exception);
                }
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "getPmiModule", var0);
        }
        return var0;
    }

    private static boolean isPmiEnabled() {
        boolean bl;
        block7: {
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(THIS_CLASS, "isPmiEnabled");
            }
            bl = false;
            try {
                String string = PmiModuleFactory.getServerVersion();
                Class<?> clazz = Class.forName(string.startsWith("5.") ? FACTORY_V5 : FACTORY_V6);
                Method method2 = clazz.getMethod("isPMIEnabled", null);
                if (method2 != null) {
                    Boolean bl2 = (Boolean)method2.invoke(null, null);
                    bl = bl2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, "com.ibm.wkplc.extensionregistry.pmi.PmiModuleFactory.isPmiEnabled", "2");
                if (s_logger.isErrorEnabled()) {
                    s_logger.error("err.no_stats_factory_0", "Configure", null, classNotFoundException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.wkplc.extensionregistry.pmi.PmiModuleFactory.isPmiEnabled", "3");
                if (!s_logger.isErrorEnabled()) break block7;
                s_logger.error("err.get_pmi_setting_0", "Configure", null, exception);
            }
        }
        if (s_logger.isTraceEntryExitEnabled()) {
            s_logger.traceExit(THIS_CLASS, "isPmiEnabled", bl);
        }
        return bl;
    }

    private static String getServerVersion() {
        WASProduct wASProduct;
        websphere websphere2;
        if (s_serverVersion == null && (websphere2 = (wASProduct = new WASProduct()).getPlatform()) != null) {
            s_serverVersion = websphere2.getVersion();
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("PmiModuleFactory detected WAS version as: " + s_serverVersion);
            }
        }
        return s_serverVersion;
    }
}

