/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.util;

import com.ibm.wkplc.extensionregistry.util.NumberStatistic;
import com.ibm.wkplc.extensionregistry.util.ReadWriteLock;
import com.ibm.wkplc.extensionregistry.util.Statistic;

public class CacheStatistic
extends Statistic {
    ReadWriteLock _lock = new ReadWriteLock();
    long _nTries;
    long _nHits;
    long _nDisplaces;
    NumberStatistic _statHitRate;
    NumberStatistic _statDisplaceRate;
    NumberStatistic _statCount;
    NumberStatistic _statMax;
    NumberStatistic _statTries;

    public CacheStatistic(String string) {
        this(string, true);
    }

    protected CacheStatistic(String string, boolean bl) {
        super(string, bl);
        this._statHitRate = new NumberStatistic(string + ".HitRate");
        this._statDisplaceRate = new NumberStatistic(string + ".DisplaceRate");
        this._statCount = new NumberStatistic(string + ".Count");
        this._statMax = new NumberStatistic(string + ".MaxSize");
        this._statTries = new NumberStatistic(string + ".Tries");
        this._nTries = 0L;
        this._nHits = 0L;
        this._nDisplaces = 0L;
    }

    protected void compute() {
        if (this._nTries > 0L) {
            this._statHitRate.set(100.0 * (double)this._nHits / (double)this._nTries);
            this._statDisplaceRate.set(100.0 * (double)this._nDisplaces / (double)this._nTries);
            this._statTries.set(this._nTries);
        } else {
            this._statHitRate.set(0.0);
            this._statDisplaceRate.set(0.0);
            this._statTries.set(0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this._lock.getWriteLock();
        try {
            this._nTries = 0L;
            this._nHits = 0L;
            this._nDisplaces = 0L;
            this.compute();
        }
        finally {
            this._lock.releaseLock();
        }
    }

    public void setCount(int n) {
        this._statCount.set(n);
    }

    public void setMax(int n) {
        this._statMax.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDisplaces() {
        this._lock.getReadLock();
        try {
            long l = this._nDisplaces;
            return l;
        }
        finally {
            this._lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHits() {
        this._lock.getReadLock();
        try {
            long l = this._nHits;
            return l;
        }
        finally {
            this._lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTries() {
        this._lock.getReadLock();
        try {
            long l = this._nTries;
            return l;
        }
        finally {
            this._lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hit() {
        this._lock.getWriteLock();
        try {
            ++this._nTries;
            ++this._nHits;
            this.compute();
        }
        finally {
            this._lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miss() {
        this._lock.getWriteLock();
        try {
            ++this._nTries;
            this.compute();
        }
        finally {
            this._lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displacement() {
        this._lock.getWriteLock();
        try {
            ++this._nDisplaces;
            this.compute();
        }
        finally {
            this._lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hitWasMiss() {
        this._lock.getWriteLock();
        try {
            --this._nHits;
            this.compute();
        }
        finally {
            this._lock.releaseLock();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public Object getValue() {
        return "Cache Statistic";
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this._statHitRate.toString());
        stringBuffer.append(this._statDisplaceRate.toString());
        stringBuffer.append(this._statCount.toString());
        stringBuffer.append(this._statMax.toString());
        stringBuffer.append(this._statTries.toString());
    }
}

