/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.util;

import com.ibm.wkplc.extensionregistry.util.CacheStatistic;
import com.ibm.wkplc.extensionregistry.util.Statistic;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class StatisticsCollector {
    private static StatisticsCollector c_statisticsCollector = new StatisticsCollector();
    private Hashtable s_stats = new Hashtable();

    public static StatisticsCollector getInstance() {
        return c_statisticsCollector;
    }

    private StatisticsCollector() {
    }

    protected void register(Statistic statistic) {
        this.s_stats.put(statistic.getName(), statistic);
    }

    protected void unregister(String string) {
        this.s_stats.remove(string);
    }

    protected Statistic get(String string) {
        return (Statistic)this.s_stats.get(string);
    }

    public void reset() {
        Collection collection = this.s_stats.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Statistic statistic = (Statistic)iterator.next();
            statistic.reset();
        }
    }

    public Collection getAllStats() {
        Vector vector = new Vector(this.s_stats.keySet());
        Collections.sort(vector);
        LinkedList linkedList = new LinkedList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            linkedList.add(this.s_stats.get(string));
        }
        return linkedList;
    }

    public void resetCacheStatistics() {
        Enumeration enumeration = this.s_stats.elements();
        while (enumeration.hasMoreElements()) {
            Statistic statistic = (Statistic)enumeration.nextElement();
            if (!(statistic instanceof CacheStatistic)) continue;
            statistic.reset();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getAllStats().iterator();
        while (iterator.hasNext()) {
            Statistic statistic = (Statistic)iterator.next();
            statistic.toStringBuffer(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public StringBuffer find(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getAllStats().iterator();
        while (iterator.hasNext()) {
            Statistic statistic = (Statistic)iterator.next();
            boolean bl = false;
            if (string == null) {
                bl = true;
            } else if (string.length() == 0) {
                bl = true;
            } else if (statistic.getName().startsWith(string)) {
                bl = true;
            }
            if (!bl) continue;
            statistic.toStringBuffer(stringBuffer);
        }
        return stringBuffer;
    }
}

