/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.util;

import com.ibm.wkplc.extensionregistry.util.XmlUtilException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static String[][] s_entityTable = new String[][]{{"quot", "\""}, {"amp", "&"}, {"apos", "'"}, {"lt", "<"}, {"gt", ">"}};
    private static HashMap s_entToCodeMap = new HashMap();

    private XmlUtil() {
    }

    private static int privateLookup(String string) {
        char c = string.charAt(0);
        if (c == '#') {
            try {
                int n = Integer.parseInt(string.substring(1));
                if (n > 65535) {
                    return -1;
                }
                return (char)n;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        if (Character.isLetter(c)) {
            String string2 = (String)s_entToCodeMap.get(string);
            if (string2 == null) {
                string2 = (String)s_entToCodeMap.get(string.toLowerCase());
            }
            return string2 != null ? (int)string2.charAt(0) : -1;
        }
        return -1;
    }

    public static String unescape(String string) {
        if (string.indexOf(38) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                int n = string.indexOf(59, i);
                if (n != -1 && n > i + 1) {
                    String string2 = string.substring(i + 1, n);
                    int n2 = XmlUtil.privateLookup(string2);
                    if (n2 == -1) {
                        stringBuffer.append('&').append(string2).append(';');
                    } else {
                        stringBuffer.append((char)n2);
                    }
                    i = n;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        if (string != null) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            block7: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block7;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        continue block7;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block7;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static Element getDomFromString(String string) throws XmlUtilException {
        try {
            DOMParser dOMParser = new DOMParser();
            InputSource inputSource = new InputSource(new StringReader(string));
            dOMParser.parse(inputSource);
            return dOMParser.getDocument().getDocumentElement();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Couldn't parse XML", iOException);
        }
        catch (SAXException sAXException) {
            throw new XmlUtilException("Couldn't parse XML", sAXException);
        }
    }

    public static Element getDomFromStream(InputStream inputStream) throws XmlUtilException {
        try {
            DOMParser dOMParser = new DOMParser();
            InputSource inputSource = new InputSource(inputStream);
            dOMParser.parse(inputSource);
            return dOMParser.getDocument().getDocumentElement();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Couldn't parse XML", iOException);
        }
        catch (SAXException sAXException) {
            throw new XmlUtilException("Couldn't parse XML", sAXException);
        }
    }

    public static String getStringFromDom(Element element) throws XmlUtilException {
        try {
            OutputFormat outputFormat = new OutputFormat();
            StringWriter stringWriter = new StringWriter();
            outputFormat.setOmitXMLDeclaration(true);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(element);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Couldn't serialize XML", iOException);
        }
    }

    public static NodeList getRealChildNodes(Node node) {
        BuildableNodeList buildableNodeList = new BuildableNodeList();
        block4: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 2: {
                    buildableNodeList.add(node2);
                    continue block4;
                }
                case 3: 
                case 4: {
                    String string = node2.getNodeValue().trim();
                    if (string.equals("")) continue block4;
                    buildableNodeList.add(node2);
                    continue block4;
                }
            }
        }
        return buildableNodeList;
    }

    public static int getElementChildCount(Element element) {
        int n = 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            ++n;
        }
        return n;
    }

    public static int getElementChildCount(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        return nodeList.getLength();
    }

    public static int getElementChildCount(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        return nodeList.getLength();
    }

    public static boolean hasChildElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChildElement(Element element, String string) {
        return XmlUtil.getElementChildCount(element, string) > 0;
    }

    public static boolean hasChildElement(Element element, String string, String string2) {
        return XmlUtil.getElementChildCount(element, string, string2) > 0;
    }

    public static Element getFirstChildElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstChildElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static Element getFirstChildElement(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static String getElementText(Element element) {
        return XmlUtil.getElementText(element, true);
    }

    public static String getElementText(Element element, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node instanceof Text) {
                string = node.getNodeValue();
                if (string == null) continue;
                stringBuffer.append(string);
                continue;
            }
            if (!bl || !(node instanceof Element) || (string = XmlUtil.getElementText((Element)node, true)) == null) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Document createXmlDocument(String string) {
        DocumentImpl documentImpl = new DocumentImpl();
        documentImpl.appendChild(documentImpl.createElement(string));
        return documentImpl;
    }

    public static Document parseXml(File file) throws XmlUtilException {
        try {
            FileReader fileReader = new FileReader(file);
            InputSource inputSource = new InputSource(fileReader);
            return XmlUtil.parseXml(inputSource);
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to read from source string", iOException);
        }
    }

    public static Document parseXml(String string) throws XmlUtilException {
        InputSource inputSource = new InputSource(new StringReader(string));
        return XmlUtil.parseXml(inputSource);
    }

    private static Document parseXml(InputSource inputSource) throws XmlUtilException {
        Document document = null;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            document = dOMParser.getDocument();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to read from source string", iOException);
        }
        catch (SAXParseException sAXParseException) {
            int n = sAXParseException.getLineNumber();
            throw new XmlUtilException("Unable to parse the input (line " + n + ")", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new XmlUtilException("Unable to parse the given string", sAXException);
        }
        return document;
    }

    public static Document transformXml(Document document, Document document2) throws XmlUtilException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new DOMSource(document2));
            DOMResult dOMResult = new DOMResult();
            transformer.transform(new DOMSource(document), dOMResult);
            Node node = dOMResult.getNode();
            if (node instanceof Document) {
                return (Document)node;
            }
            return dOMResult.getNode().getOwnerDocument();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XmlUtilException("Unable to perform transform " + transformerConfigurationException.getLocationAsString(), transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XmlUtilException("Unable to perform transform " + transformerException.getLocationAsString(), transformerException);
        }
    }

    public static void outputXml(Document document, PrintStream printStream) throws XmlUtilException {
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndenting(true);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)printStream, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to write to the given print stream", iOException);
        }
    }

    public static void outputTextToFile(String string, String string2) throws XmlUtilException {
        File file = new File(string2);
        XmlUtil.outputTextToFile(string, file);
    }

    public static void outputTextToFile(String string, File file) throws XmlUtilException {
        try {
            File file2 = new File(file.getParent());
            file2.mkdirs();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to write to the given file", iOException);
        }
    }

    public static void outputXml(Document document, File file) throws XmlUtilException {
        try {
            if (document == null) {
                throw new IOException("Output XML document was null");
            }
            if (file == null) {
                throw new IOException("Bad File given");
            }
            OutputFormat outputFormat = new OutputFormat(document, "UTF-8", true);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat);
            xMLSerializer.serialize(document);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to write to the given file", iOException);
        }
    }

    public static void outputXml(Document document, String string) throws XmlUtilException {
        XmlUtil.outputXml(document, new File(string));
    }

    public static String contentXmlToString(Document document) throws XmlUtilException {
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndenting(true);
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to write to the string", iOException);
        }
    }

    public static String contentXmlToMetaString(Document document) throws XmlUtilException {
        String string = XmlUtil.contentXmlToString(document);
        StringWriter stringWriter = new StringWriter();
        String string2 = null;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    string2 = "\\\"";
                    break;
                }
                case '\n': {
                    string2 = "\\n";
                    break;
                }
                case '\f': {
                    string2 = "\\f";
                    break;
                }
                case '\b': {
                    string2 = "\\b";
                    break;
                }
                case '\r': {
                    string2 = "\\r";
                    break;
                }
                case '\t': {
                    string2 = "\\t";
                    break;
                }
                case '\'': {
                    string2 = "\\'";
                    break;
                }
                case '\\': {
                    string2 = "\\\\";
                }
            }
            if (string2 == null) continue;
            stringWriter.write(string, n, i - n);
            stringWriter.write(string2);
            n = i + 1;
            string2 = null;
        }
        stringWriter.write(string, n, string.length() - n);
        return stringWriter.toString();
    }

    public static String contentXmlToString(Document document, boolean bl, boolean bl2) throws XmlUtilException {
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            if (bl2) {
                outputFormat.setIndenting(false);
                outputFormat.setOmitXMLDeclaration(true);
            } else {
                outputFormat.setIndenting(true);
            }
            if (bl) {
                outputFormat.setPreserveSpace(true);
            }
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new XmlUtilException("Unable to write to the string", iOException);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("XmlUtil usage:\n");
            System.out.println("~> XmlUtil data_file.xml transform.xsl result.xml");
            System.exit(0);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[2]);
        try {
            Document document = XmlUtil.parseXml(file);
            Document document2 = XmlUtil.parseXml(file2);
            Document document3 = XmlUtil.transformXml(document, document2);
            XmlUtil.outputXml(document3, file3);
            System.out.println("Wrote resulting XML to " + file3.getAbsolutePath());
        }
        catch (XmlUtilException xmlUtilException) {
            System.err.println(xmlUtilException.getMessage());
        }
    }

    static {
        for (int i = 0; i < s_entityTable.length; ++i) {
            String string = s_entityTable[i][0];
            String string2 = s_entityTable[i][1];
            s_entToCodeMap.put(string, string2);
        }
    }

    private static class BuildableNodeList
    implements NodeList {
        private ArrayList nodes = new ArrayList();

        public void add(Node node) {
            this.nodes.add(node);
        }

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int n) {
            return (Node)this.nodes.get(n);
        }
    }
}

