/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wkplc.extensionregistry.wasservice;

import com.ibm.websphere.management.JMXManageable;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.wkplc.extensionregistry.ExtensionRegistryFactory;
import com.ibm.wkplc.extensionregistry.IModifiableRegistry;
import com.ibm.wkplc.extensionregistry.IRegistryTool;
import com.ibm.wkplc.extensionregistry.RegistryCache;
import com.ibm.wkplc.extensionregistry.logging.Logger;
import com.ibm.wkplc.extensionregistry.logging.LoggerFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;

public class ExtensionRegistryService
extends ComponentImpl {
    protected static final Logger s_logger = LoggerFactory.getLogger(ExtensionRegistryService.class);
    private static final String SERVICE_NAME = "ExtensionRegistryService";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start() throws RuntimeWarning, RuntimeError {
        if (ExtensionRegistryService.s_logger.isTraceEntryExitEnabled()) {
            ExtensionRegistryService.s_logger.traceEntry(this, "start");
        }
        super.start();
        ExtensionRegistryFactory.init();
        var1_1 = (IModifiableRegistry)ExtensionRegistryFactory.INSTANCE.getExtensionRegistry();
        if (var1_1 != null) {
            var1_1.load(this.getClass().getClassLoader());
            var2_2 = (MetaDataService)this.getService(MetaDataService.class);
            if (var2_2 == null) {
                if (ExtensionRegistryService.s_logger.isErrorEnabled()) {
                    ExtensionRegistryService.s_logger.error("err.obtain_runtime_service_1", "Start", new Object[]{"MetaDataService.class"});
                }
                throw new RuntimeError("Can not find MetaDataService");
            }
            try {
                var2_2.addMetaDataListener(new ExtensionRegistryMetaDataListener(var1_1));
            }
            catch (Throwable var3_3) {
                FFDCFilter.processException(var3_3, this.getClass().toString() + ".start", "1");
                if (!ExtensionRegistryService.s_logger.isErrorEnabled()) ** GOTO lbl26
                ExtensionRegistryService.s_logger.error("err.register_as_listener_1", "Start", new Object[]{"MetaDataListener"}, var3_3);
            }
            finally {
                this.releaseService(var2_2);
            }
        } else if (ExtensionRegistryService.s_logger.isErrorEnabled()) {
            ExtensionRegistryService.s_logger.error("err.failed_to_locate_registry_0", "Start", null);
        }
lbl26:
        // 6 sources

        if ((var2_2 = (Server)this.getService(Server.class)) == null) {
            if (ExtensionRegistryService.s_logger.isErrorEnabled()) {
                ExtensionRegistryService.s_logger.error("err.obtain_runtime_service_1", "Start", new Object[]{"Server.class"});
            }
            throw new RuntimeError("Can not find Server service");
        }
        try {
            var2_2.addPropertyChangeListener("state", new ExtensionRegistryPropertyChangeListener());
        }
        catch (Throwable var3_4) {
            FFDCFilter.processException(var3_4, this.getClass().toString() + ".start", "2");
            if (ExtensionRegistryService.s_logger.isErrorEnabled()) {
                ExtensionRegistryService.s_logger.error("err.register_as_listener_1", "Start", new Object[]{"PropertyChangeListener"}, var3_4);
            }
        }
        finally {
            this.releaseService(var2_2);
        }
        var3_5 = new DefaultRuntimeCollaborator(new ExtensionRegistryMBean(), "ExtensionRegistryService");
        this.registerMBean("ExtensionRegistryService", (RuntimeCollaborator)var3_5, "ExtensionRegistryService", "ExtensionRegistryService", null);
        if (ExtensionRegistryService.s_logger.isTraceEntryExitEnabled()) {
            ExtensionRegistryService.s_logger.traceExit(this, "start");
        }
    }

    private static void setServerStarted() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("ExtensionRegistry starts resolving from this point on");
        }
        IRegistryTool iRegistryTool = (IRegistryTool)ExtensionRegistryFactory.INSTANCE.getExtensionRegistry();
        iRegistryTool.enableResolving();
    }

    private static void setServerStopping() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("ExtensionRegistry is now in STOPPING mode");
        }
        IRegistryTool iRegistryTool = (IRegistryTool)ExtensionRegistryFactory.INSTANCE.getExtensionRegistry();
        iRegistryTool.shutdown();
    }

    public static class ExtensionRegistryMBean
    implements JMXManageable {
        public String getType() {
            return ExtensionRegistryService.SERVICE_NAME;
        }

        public Properties getMBeanProperties() {
            return null;
        }

        public boolean getPingResult() {
            return true;
        }

        public String getCacheSize() {
            return RegistryCache.INSTANCE.getCacheSize();
        }

        public void setCacheSize(String string) {
            RegistryCache.INSTANCE.setCacheSize(string);
        }

        public String getCacheStats() {
            return RegistryCache.INSTANCE.getCacheStats();
        }

        public String getContentDump() {
            IRegistryTool iRegistryTool = this.getRegistryTool("");
            return iRegistryTool.dumpAll();
        }

        public String getContentXml() {
            try {
                IRegistryTool iRegistryTool = this.getRegistryTool("");
                return iRegistryTool.getContentXml();
            }
            catch (CoreException coreException) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><extension-registry>");
                coreException.printStackTrace(new PrintWriter(stringWriter));
                stringWriter.write("</extension-registry>");
                return stringWriter.toString();
            }
        }

        public String getFilteredDump(String string) {
            IRegistryTool iRegistryTool = this.getRegistryTool(string);
            return iRegistryTool.dumpAll();
        }

        private IRegistryTool getRegistryTool(String string) {
            return (IRegistryTool)ExtensionRegistryFactory.INSTANCE.getExtensionRegistry(string);
        }
    }

    static class ExtensionRegistryPropertyChangeListener
    implements PropertyChangeListener {
        ExtensionRegistryPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (string.equals("STARTED")) {
                ExtensionRegistryService.setServerStarted();
            } else if (string.equals("STOPPING")) {
                ExtensionRegistryService.setServerStopping();
            }
        }
    }

    static class ExtensionRegistryMetaDataListener
    implements MetaDataListener {
        IModifiableRegistry _registry = null;

        ExtensionRegistryMetaDataListener(IModifiableRegistry iModifiableRegistry) {
            this._registry = iModifiableRegistry;
        }

        public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
            DeployedObject deployedObject;
            MetaData metaData = metaDataEvent.getMetaData();
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "metaDataCreated", new Object[]{metaData.getName()});
            }
            if ((metaData instanceof ApplicationMetaData || metaData instanceof WebModuleMetaData) && (deployedObject = metaDataEvent.getDeployedObject()) != null) {
                this._registry.load(deployedObject.getClassLoader());
            }
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceExit(this, "metaDataCreated");
            }
        }

        public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
            MetaData metaData = metaDataEvent.getMetaData();
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceEntry(this, "metaDataDestroyed", new Object[]{metaData.getName()});
            }
            if (metaData instanceof ApplicationMetaData || metaData instanceof WebModuleMetaData) {
                ClassLoader classLoader;
                DeployedObject deployedObject;
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("  Class: " + metaData.getClass());
                }
                if ((deployedObject = metaDataEvent.getDeployedObject()) != null && (classLoader = deployedObject.getClassLoader()) != null) {
                    this._registry.unload(classLoader);
                }
            }
            if (s_logger.isTraceEntryExitEnabled()) {
                s_logger.traceExit(this, "metaDataDestroyed");
            }
        }
    }
}

